/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class IncludeExcludeSet<T, P>
implements Predicate<P> {
    private final Set<T> _includes;
    private final Predicate<P> _includePredicate;
    private final Set<T> _excludes;
    private final Predicate<P> _excludePredicate;

    public IncludeExcludeSet() {
        this(HashSet.class);
    }

    public <SET extends Set<T>> IncludeExcludeSet(Class<SET> clazz) {
        try {
            this._includes = (Set)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this._excludes = (Set)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this._includePredicate = this._includes instanceof Predicate ? (Predicate<Object>)((Object)this._includes) : new SetContainsPredicate<P>(this._includes);
            this._excludePredicate = this._excludes instanceof Predicate ? (Predicate<Object>)((Object)this._excludes) : new SetContainsPredicate<P>(this._excludes);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public <SET extends Set<T>> IncludeExcludeSet(Set<T> set, Predicate<P> predicate, Set<T> set2, Predicate<P> predicate2) {
        Objects.requireNonNull(set, "Include Set");
        Objects.requireNonNull(predicate, "Include Predicate");
        Objects.requireNonNull(set2, "Exclude Set");
        Objects.requireNonNull(predicate2, "Exclude Predicate");
        this._includes = set;
        this._includePredicate = predicate;
        this._excludes = set2;
        this._excludePredicate = predicate2;
    }

    public void include(T t) {
        this._includes.add(t);
    }

    public void include(T ... TArray) {
        for (T t : TArray) {
            this._includes.add(t);
        }
    }

    public void exclude(T t) {
        this._excludes.add(t);
    }

    public void exclude(T ... TArray) {
        for (T t : TArray) {
            this._excludes.add(t);
        }
    }

    @Deprecated
    public boolean matches(P p) {
        return this.test(p);
    }

    @Override
    public boolean test(P p) {
        if (!this._includes.isEmpty() && !this._includePredicate.test(p)) {
            return false;
        }
        return !this._excludePredicate.test(p);
    }

    public Boolean isIncludedAndNotExcluded(P p) {
        if (this._excludePredicate.test(p)) {
            return Boolean.FALSE;
        }
        if (this._includePredicate.test(p)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean hasIncludes() {
        return !this._includes.isEmpty();
    }

    public boolean hasExcludes() {
        return !this._excludes.isEmpty();
    }

    public int size() {
        return this._includes.size() + this._excludes.size();
    }

    public Set<T> getIncluded() {
        return this._includes;
    }

    public Set<T> getExcluded() {
        return this._excludes;
    }

    public void clear() {
        this._includes.clear();
        this._excludes.clear();
    }

    public String toString() {
        return String.format("%s@%x{i=%s,ip=%s,e=%s,ep=%s}", this.getClass().getSimpleName(), this.hashCode(), this._includes, this._includePredicate == this._includes ? "SELF" : this._includePredicate, this._excludes, this._excludePredicate == this._excludes ? "SELF" : this._excludePredicate);
    }

    public boolean isEmpty() {
        return this._includes.isEmpty() && this._excludes.isEmpty();
    }

    public static <T1, T2> boolean matchCombined(T1 T1, IncludeExcludeSet<?, T1> includeExcludeSet, T2 T2, IncludeExcludeSet<?, T2> includeExcludeSet2) {
        Boolean bl = includeExcludeSet.isIncludedAndNotExcluded(T1);
        Boolean bl2 = includeExcludeSet2.isIncludedAndNotExcluded(T2);
        if (Boolean.FALSE.equals(bl) || Boolean.FALSE.equals(bl2)) {
            return false;
        }
        if (includeExcludeSet.hasIncludes() || includeExcludeSet2.hasIncludes()) {
            return Boolean.TRUE.equals(bl) || Boolean.TRUE.equals(bl2);
        }
        return true;
    }

    private static class SetContainsPredicate<T>
    implements Predicate<T> {
        private final Set<T> set;

        public SetContainsPredicate(Set<T> set) {
            this.set = set;
        }

        @Override
        public boolean test(T t) {
            return this.set.contains(t);
        }

        public String toString() {
            return "CONTAINS";
        }
    }
}

