/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;

public class HostPort {
    private final String _host;
    private final int _port;

    public HostPort(String string, int n) {
        this._host = HostPort.normalizeHost(string);
        this._port = n;
    }

    public HostPort(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("No Authority");
        }
        try {
            if (string.isEmpty()) {
                this._host = string;
                this._port = 0;
            } else if (string.charAt(0) == '[') {
                int n = string.lastIndexOf(93);
                if (n < 0) {
                    throw new IllegalArgumentException("Bad IPv6 host");
                }
                this._host = string.substring(0, n + 1);
                if (string.length() > n + 1) {
                    if (string.charAt(n + 1) != ':') {
                        throw new IllegalArgumentException("Bad IPv6 port");
                    }
                    this._port = HostPort.parsePort(string.substring(n + 2));
                } else {
                    this._port = 0;
                }
            } else {
                int n = string.lastIndexOf(58);
                if (n >= 0) {
                    if (n != string.indexOf(58)) {
                        this._host = "[" + string + "]";
                        this._port = 0;
                    } else {
                        this._host = string.substring(0, n);
                        this._port = HostPort.parsePort(string.substring(n + 1));
                    }
                } else {
                    this._host = string;
                    this._port = 0;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Bad HostPort", exception);
        }
    }

    @ManagedAttribute(value="host")
    public String getHost() {
        return this._host;
    }

    @ManagedAttribute(value="port")
    public int getPort() {
        return this._port;
    }

    public int getPort(int n) {
        return this._port > 0 ? this._port : n;
    }

    public boolean hasHost() {
        return StringUtil.isNotBlank(this._host);
    }

    public boolean hasPort() {
        return this._port > 0;
    }

    public String toString() {
        if (this._port > 0) {
            return this._host + ":" + this._port;
        }
        return this._host;
    }

    public static String normalizeHost(String string) {
        if (string == null || string.isEmpty() || string.charAt(0) == '[' || string.indexOf(58) < 0) {
            return string;
        }
        return "[" + string + "]";
    }

    public static int parsePort(String string) throws IllegalArgumentException {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Bad port");
        }
        int n = Integer.parseInt(string);
        if (n <= 0 || n > 65535) {
            throw new IllegalArgumentException("Bad port");
        }
        return n;
    }
}

