/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;
import org.eclipse.jetty.util.MathUtils;

public class ArrayTrie<V>
extends AbstractTrie<V> {
    private static final int ROW_SIZE = 32;
    private static final int MAX_CAPACITY = 65534;
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private final char[] _rowIndex;
    private final String[] _key;
    private final V[] _value;
    private char[][] _bigIndex;
    private char _rows;

    public ArrayTrie() {
        this(128);
    }

    public ArrayTrie(int n) {
        super(true);
        if (n > 65534) {
            throw new IllegalArgumentException("Capacity " + n + " > " + 65534);
        }
        this._value = new Object[n + 1];
        this._rowIndex = new char[(n + 1) * 32];
        this._key = new String[n + 1];
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._rowIndex, '\u0000');
        Arrays.fill(this._key, null);
    }

    @Override
    public boolean put(String string, V v) {
        int n = 0;
        int n2 = string.length();
        if (n2 > 65534) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = __lookup[c & 0x7F];
            if (n3 >= 0) {
                int n4 = n * 32 + n3;
                if ((n = this._rowIndex[n4]) != 0) continue;
                this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
                if (this._rows == this._value.length) {
                    return false;
                }
                this._rowIndex[n4] = this._rows;
                n = this._rowIndex[n4];
                continue;
            }
            if (c > '\u007f') {
                throw new IllegalArgumentException("non ascii character");
            }
            if (this._bigIndex == null) {
                this._bigIndex = new char[this._value.length][];
            }
            if (n >= this._bigIndex.length) {
                return false;
            }
            char[] cArray = this._bigIndex[n];
            if (cArray == null) {
                this._bigIndex[n] = new char[128];
                cArray = this._bigIndex[n];
            }
            if ((n = cArray[c]) != 0) continue;
            this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
            if (this._rows == this._value.length) {
                return false;
            }
            cArray[c] = this._rows;
            n = cArray[c];
        }
        if (n >= this._key.length) {
            this._rows = (char)this._key.length;
            return false;
        }
        this._key[n] = v == null ? null : string;
        this._value[n] = v;
        return true;
    }

    @Override
    public V get(String string, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char[] cArray;
            char c = string.charAt(n + i);
            if (c > '\u007f') {
                return null;
            }
            int n4 = __lookup[c & 0x7F];
            if (n4 >= 0) {
                int n5 = n3 * 32 + n4;
                if ((n3 = this._rowIndex[n5]) != 0) continue;
                return null;
            }
            char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n3];
            if (cArray == null) {
                return null;
            }
            n3 = cArray[c & 0x7F];
            if (n3 != 0) continue;
            return null;
        }
        return this._value[n3];
    }

    @Override
    public V get(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char[] cArray;
            byte by = byteBuffer.get(n + i);
            int n4 = __lookup[by & 0x7F];
            if (n4 >= 0) {
                int n5 = n3 * 32 + n4;
                if ((n3 = this._rowIndex[n5]) != 0) continue;
                return null;
            }
            char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n3];
            if (cArray == null) {
                return null;
            }
            n3 = cArray[by];
            if (n3 != 0) continue;
            return null;
        }
        return this._value[n3];
    }

    @Override
    public V getBest(byte[] byArray, int n, int n2) {
        return this.getBest(0, byArray, n, n2);
    }

    @Override
    public V getBest(ByteBuffer byteBuffer, int n, int n2) {
        if (byteBuffer.hasArray()) {
            return this.getBest(0, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + n, n2);
        }
        return this.getBest(0, byteBuffer, n, n2);
    }

    @Override
    public V getBest(String string, int n, int n2) {
        return this.getBest(0, string, n, n2);
    }

    private V getBest(int n, String string, int n2, int n3) {
        int n4 = n2;
        for (int i = 0; i < n3; ++i) {
            int n5;
            char c;
            int n6;
            if ((n6 = __lookup[(c = string.charAt(n4++)) & 0x7F]) >= 0) {
                int n7 = n * 32 + n6;
                n5 = this._rowIndex[n7];
                if (n5 == 0) {
                    break;
                }
            } else {
                char[] cArray;
                char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n];
                if (cArray == null || (n5 = cArray[c]) == 0) break;
            }
            if (this._key[n] != null) {
                V v = this.getBest(n5, string, n2 + i + 1, n3 - i - 1);
                if (v != null) {
                    return v;
                }
                return this._value[n];
            }
            n = n5;
        }
        return this._value[n];
    }

    private V getBest(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4;
            byte by = byArray[n2 + i];
            int n5 = __lookup[by & 0x7F];
            if (n5 >= 0) {
                int n6 = n * 32 + n5;
                n4 = this._rowIndex[n6];
                if (n4 == 0) {
                    break;
                }
            } else {
                char[] cArray;
                char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n];
                if (cArray == null || (n4 = cArray[by]) == 0) break;
            }
            if (this._key[n] != null) {
                V v = this.getBest(n4, byArray, n2 + i + 1, n3 - i - 1);
                if (v == null) break;
                return v;
            }
            n = n4;
        }
        return this._value[n];
    }

    private V getBest(int n, ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = byteBuffer.position() + n2;
        for (int i = 0; i < n3; ++i) {
            int n5;
            byte by;
            int n6;
            if (n4 >= byteBuffer.limit()) {
                return null;
            }
            if ((n6 = __lookup[(by = byteBuffer.get(n4++)) & 0x7F]) >= 0) {
                int n7 = n * 32 + n6;
                n5 = this._rowIndex[n7];
                if (n5 == 0) {
                    break;
                }
            } else {
                char[] cArray;
                char[] cArray2 = cArray = this._bigIndex == null ? null : this._bigIndex[n];
                if (cArray == null || (n5 = cArray[by]) == 0) break;
                n = n5;
            }
            if (this._key[n] != null) {
                V v = this.getBest(n5, byteBuffer, n2 + i + 1, n3 - i - 1);
                if (v == null) break;
                return v;
            }
            n = n5;
        }
        return this._value[n];
    }

    public String toString() {
        int n = this._rows;
        if (n == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 123;
        for (int i = 0; i <= n; ++i) {
            String string = this._key[i];
            if (string == null) continue;
            stringBuilder.append((char)n2).append(string).append('=').append(this._value[i]);
            n2 = 44;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this._key) {
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public boolean isFull() {
        return this._rows >= this._key.length;
    }
}

