/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Retainable;

public class RetainableByteBuffer
implements Retainable {
    private final ByteBufferPool pool;
    private final ByteBuffer buffer;
    private final AtomicInteger references;

    public RetainableByteBuffer(ByteBufferPool byteBufferPool, int n) {
        this(byteBufferPool, n, false);
    }

    public RetainableByteBuffer(ByteBufferPool byteBufferPool, int n, boolean bl) {
        this.pool = byteBufferPool;
        this.buffer = byteBufferPool.acquire(n, bl);
        this.references = new AtomicInteger(1);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getReferences() {
        return this.references.get();
    }

    @Override
    public void retain() {
        int n;
        do {
            if ((n = this.references.get()) != 0) continue;
            throw new IllegalStateException("released " + this);
        } while (!this.references.compareAndSet(n, n + 1));
    }

    public int release() {
        int n = this.references.decrementAndGet();
        if (n == 0) {
            this.pool.release(this.buffer);
        } else if (n < 0) {
            throw new IllegalStateException("already released " + this);
        }
        return n;
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public boolean isEmpty() {
        return !this.hasRemaining();
    }

    public void clear() {
        BufferUtil.clear(this.buffer);
    }

    public String toString() {
        return String.format("%s@%x{%s,r=%d}", this.getClass().getSimpleName(), this.hashCode(), BufferUtil.toDetailString(this.buffer), this.getReferences());
    }
}

