/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.eclipse.jetty.io.AbstractByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class MappedByteBufferPool
extends AbstractByteBufferPool
implements Dumpable {
    private static final Logger LOG = Log.getLogger(MappedByteBufferPool.class);
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _directBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _heapBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final Function<Integer, ByteBufferPool.Bucket> _newBucket;
    private boolean _detailedDump = false;

    public MappedByteBufferPool() {
        this(-1);
    }

    public MappedByteBufferPool(int n) {
        this(n, -1);
    }

    public MappedByteBufferPool(int n, int n2) {
        this(n, n2, null);
    }

    public MappedByteBufferPool(int n, int n2, Function<Integer, ByteBufferPool.Bucket> function) {
        this(n, n2, function, 0L, 0L);
    }

    public MappedByteBufferPool(int n, int n2, Function<Integer, ByteBufferPool.Bucket> function, long l, long l2) {
        super(n, n2, l, l2);
        this._newBucket = function;
    }

    private ByteBufferPool.Bucket newBucket(int n, boolean bl) {
        return this._newBucket != null ? this._newBucket.apply(n) : new ByteBufferPool.Bucket(this, this.capacityFor(n), this.getMaxQueueLength(), this.updateMemory(bl));
    }

    @Override
    public ByteBuffer acquire(int n, boolean bl) {
        int n2 = this.bucketFor(n);
        int n3 = this.capacityFor(n2);
        ConcurrentMap<Integer, ByteBufferPool.Bucket> concurrentMap = this.bucketsFor(bl);
        ByteBufferPool.Bucket bucket = (ByteBufferPool.Bucket)concurrentMap.get(n2);
        if (bucket == null) {
            return this.newByteBuffer(n3, bl);
        }
        ByteBuffer byteBuffer = bucket.acquire();
        if (byteBuffer == null) {
            return this.newByteBuffer(n3, bl);
        }
        return byteBuffer;
    }

    @Override
    public void release(ByteBuffer byteBuffer) {
        int n2;
        if (byteBuffer == null) {
            return;
        }
        int n3 = byteBuffer.capacity();
        if (n3 != this.capacityFor(n2 = this.bucketFor(n3))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer {} does not belong to this pool, discarding it", BufferUtil.toDetailString(byteBuffer));
            }
            return;
        }
        boolean bl = byteBuffer.isDirect();
        ConcurrentMap<Integer, ByteBufferPool.Bucket> concurrentMap = this.bucketsFor(bl);
        ByteBufferPool.Bucket bucket = concurrentMap.computeIfAbsent(n2, n -> this.newBucket((int)n, bl));
        bucket.release(byteBuffer);
        this.releaseExcessMemory(bl, this::releaseMemory);
    }

    @Override
    public void clear() {
        super.clear();
        this._directBuffers.values().forEach(ByteBufferPool.Bucket::clear);
        this._directBuffers.clear();
        this._heapBuffers.values().forEach(ByteBufferPool.Bucket::clear);
        this._heapBuffers.clear();
    }

    protected void releaseMemory(boolean bl) {
        long l = Long.MAX_VALUE;
        int n = -1;
        ConcurrentMap<Integer, ByteBufferPool.Bucket> concurrentMap = this.bucketsFor(bl);
        Object object = concurrentMap.entrySet().iterator();
        while (object.hasNext()) {
            long l2;
            Map.Entry entry = object.next();
            ByteBufferPool.Bucket bucket = (ByteBufferPool.Bucket)entry.getValue();
            if (bucket.isEmpty() || (l2 = bucket.getLastUpdate()) >= l) continue;
            l = l2;
            n = (Integer)entry.getKey();
        }
        if (n >= 0 && (object = (ByteBufferPool.Bucket)concurrentMap.remove(n)) != null) {
            ((ByteBufferPool.Bucket)object).clear();
        }
    }

    protected int bucketFor(int n) {
        return (int)Math.ceil((double)n / (double)this.getCapacityFactor());
    }

    protected int capacityFor(int n) {
        return n * this.getCapacityFactor();
    }

    @ManagedAttribute(value="The number of pooled direct ByteBuffers")
    public long getDirectByteBufferCount() {
        return this.getByteBufferCount(true);
    }

    @ManagedAttribute(value="The number of pooled heap ByteBuffers")
    public long getHeapByteBufferCount() {
        return this.getByteBufferCount(false);
    }

    private long getByteBufferCount(boolean bl) {
        return this.bucketsFor(bl).values().stream().mapToLong(ByteBufferPool.Bucket::size).sum();
    }

    ConcurrentMap<Integer, ByteBufferPool.Bucket> bucketsFor(boolean bl) {
        return bl ? this._directBuffers : this._heapBuffers;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean bl) {
        this._detailedDump = bl;
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(String.format("HeapMemory: %d/%d", this.getHeapMemory(), this.getMaxHeapMemory()));
        arrayList.add(String.format("DirectMemory: %d/%d", this.getDirectMemory(), this.getMaxDirectMemory()));
        if (this.isDetailedDump()) {
            arrayList.add(new DumpableCollection("Indirect Buckets", this._heapBuffers.values()));
            arrayList.add(new DumpableCollection("Direct Buckets", this._directBuffers.values()));
        } else {
            arrayList.add("Indirect Buckets size=" + this._heapBuffers.size());
            arrayList.add("Direct Buckets size=" + this._directBuffers.size());
        }
        Dumpable.dumpObjects(appendable, string, this, arrayList);
    }

    public String toString() {
        return String.format("%s@%x{maxQueueLength=%s, factor=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getMaxQueueLength(), this.getCapacityFactor());
    }

    public static class Tagged
    extends MappedByteBufferPool {
        private final AtomicInteger tag = new AtomicInteger();

        @Override
        public ByteBuffer newByteBuffer(int n, boolean bl) {
            ByteBuffer byteBuffer = super.newByteBuffer(n + 4, bl);
            byteBuffer.limit(byteBuffer.capacity());
            byteBuffer.putInt(this.tag.incrementAndGet());
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            BufferUtil.clear(byteBuffer2);
            return byteBuffer2;
        }
    }
}

