/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class IdleTimeout {
    private static final Logger LOG = Log.getLogger(IdleTimeout.class);
    private final Scheduler _scheduler;
    private final AtomicReference<Scheduler.Task> _timeout = new AtomicReference();
    private volatile long _idleTimeout;
    private volatile long _idleTimestamp = System.nanoTime();

    public IdleTimeout(Scheduler scheduler) {
        this._scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this._scheduler;
    }

    public long getIdleFor() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this._idleTimestamp);
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long l) {
        long l2 = this._idleTimeout;
        this._idleTimeout = l;
        if (l2 > 0L) {
            if (l2 <= l) {
                return;
            }
            this.deactivate();
        }
        if (this.isOpen()) {
            this.activate();
        }
    }

    public void notIdle() {
        this._idleTimestamp = System.nanoTime();
    }

    private void idleCheck() {
        long l = this.checkIdleTimeout();
        if (l >= 0L) {
            this.scheduleIdleTimeout(l > 0L ? l : this.getIdleTimeout());
        }
    }

    private void scheduleIdleTimeout(long l) {
        Scheduler.Task task;
        Scheduler.Task task2 = null;
        if (this.isOpen() && l > 0L && this._scheduler != null) {
            task2 = this._scheduler.schedule(this::idleCheck, l, TimeUnit.MILLISECONDS);
        }
        if ((task = (Scheduler.Task)this._timeout.getAndSet(task2)) != null) {
            task.cancel();
        }
    }

    public void onOpen() {
        this.activate();
    }

    private void activate() {
        if (this._idleTimeout > 0L) {
            this.idleCheck();
        }
    }

    public void onClose() {
        this.deactivate();
    }

    private void deactivate() {
        Scheduler.Task task = this._timeout.getAndSet(null);
        if (task != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long checkIdleTimeout() {
        if (this.isOpen()) {
            long l = this._idleTimestamp;
            long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
            long l3 = this.getIdleTimeout();
            long l4 = l3 - l2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} idle timeout check, elapsed: {} ms, remaining: {} ms", this, l2, l4);
            }
            if (l3 > 0L && l4 <= 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} idle timeout expired", this);
                }
                try {
                    this.onIdleExpired(new TimeoutException("Idle timeout expired: " + l2 + "/" + l3 + " ms"));
                }
                finally {
                    this.notIdle();
                }
            }
            return l4 >= 0L ? l4 : 0L;
        }
        return -1L;
    }

    protected abstract void onIdleExpired(TimeoutException var1);

    public abstract boolean isOpen();
}

