/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.io.AbstractByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class ArrayByteBufferPool
extends AbstractByteBufferPool
implements Dumpable {
    private static final Logger LOG = Log.getLogger(ArrayByteBufferPool.class);
    private final int _maxCapacity;
    private final int _minCapacity;
    private final ByteBufferPool.Bucket[] _direct;
    private final ByteBufferPool.Bucket[] _indirect;
    private boolean _detailedDump = false;

    public ArrayByteBufferPool() {
        this(-1, -1, -1);
    }

    public ArrayByteBufferPool(int n, int n2, int n3) {
        this(n, n2, n3, -1, 0L, 0L);
    }

    public ArrayByteBufferPool(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0L, 0L);
    }

    public ArrayByteBufferPool(int n, int n2, int n3, int n4, long l, long l2) {
        super(n2, n4, l, l2);
        n2 = this.getCapacityFactor();
        if (n <= 0) {
            n = 0;
        }
        if (n3 <= 0) {
            n3 = 65536;
        }
        if (n3 % n2 != 0 || n2 >= n3) {
            throw new IllegalArgumentException("The capacity factor must be a divisor of maxCapacity");
        }
        this._maxCapacity = n3;
        this._minCapacity = n;
        int n5 = this.bucketFor(n3) + 1;
        this._direct = new ByteBufferPool.Bucket[n5];
        this._indirect = new ByteBufferPool.Bucket[n5];
        for (int i = 0; i < n5; ++i) {
            this._direct[i] = this.newBucket(i, true);
            this._indirect[i] = this.newBucket(i, false);
        }
    }

    @Override
    public ByteBuffer acquire(int n, boolean bl) {
        int n2 = n < this._minCapacity ? n : this.capacityFor(this.bucketFor(n));
        ByteBufferPool.Bucket bucket = this.bucketFor(n, bl);
        if (bucket == null) {
            return this.newByteBuffer(n2, bl);
        }
        ByteBuffer byteBuffer = bucket.acquire();
        if (byteBuffer == null) {
            return this.newByteBuffer(n2, bl);
        }
        return byteBuffer;
    }

    @Override
    public void release(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        int n = byteBuffer.capacity();
        if (n != this.capacityFor(this.bucketFor(n))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer {} does not belong to this pool, discarding it", BufferUtil.toDetailString(byteBuffer));
            }
            return;
        }
        if (n > this._maxCapacity) {
            return;
        }
        boolean bl = byteBuffer.isDirect();
        ByteBufferPool.Bucket bucket = this.bucketFor(n, bl);
        if (bucket != null) {
            bucket.release(byteBuffer);
            this.releaseExcessMemory(bl, this::releaseMemory);
        }
    }

    private ByteBufferPool.Bucket newBucket(int n, boolean bl) {
        return new ByteBufferPool.Bucket(this, this.capacityFor(n), this.getMaxQueueLength(), this.updateMemory(bl));
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this._direct.length; ++i) {
            this._direct[i].clear();
            this._indirect[i].clear();
        }
    }

    protected void releaseMemory(boolean bl) {
        long l = Long.MAX_VALUE;
        int n = -1;
        ByteBufferPool.Bucket[] bucketArray = this.bucketsFor(bl);
        for (int i = 0; i < bucketArray.length; ++i) {
            long l2;
            ByteBufferPool.Bucket bucket = bucketArray[i];
            if (bucket.isEmpty() || (l2 = bucket.getLastUpdate()) >= l) continue;
            l = l2;
            n = i;
        }
        if (n >= 0) {
            ByteBufferPool.Bucket bucket = bucketArray[n];
            bucket.clear();
        }
    }

    protected int bucketFor(int n) {
        return (int)Math.ceil((double)n / (double)this.getCapacityFactor());
    }

    protected int capacityFor(int n) {
        return n * this.getCapacityFactor();
    }

    private ByteBufferPool.Bucket bucketFor(int n, boolean bl) {
        if (n < this._minCapacity) {
            return null;
        }
        int n2 = this.bucketFor(n);
        if (n2 >= this._direct.length) {
            return null;
        }
        ByteBufferPool.Bucket[] bucketArray = this.bucketsFor(bl);
        return bucketArray[n2];
    }

    @ManagedAttribute(value="The number of pooled direct ByteBuffers")
    public long getDirectByteBufferCount() {
        return this.getByteBufferCount(true);
    }

    @ManagedAttribute(value="The number of pooled heap ByteBuffers")
    public long getHeapByteBufferCount() {
        return this.getByteBufferCount(false);
    }

    private long getByteBufferCount(boolean bl) {
        return Arrays.stream(this.bucketsFor(bl)).filter(Objects::nonNull).mapToLong(ByteBufferPool.Bucket::size).sum();
    }

    ByteBufferPool.Bucket[] bucketsFor(boolean bl) {
        return bl ? this._direct : this._indirect;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean bl) {
        this._detailedDump = bl;
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(String.format("HeapMemory: %d/%d", this.getHeapMemory(), this.getMaxHeapMemory()));
        arrayList.add(String.format("DirectMemory: %d/%d", this.getDirectMemory(), this.getMaxDirectMemory()));
        List list = Arrays.stream(this._indirect).filter(bucket -> !bucket.isEmpty()).collect(Collectors.toList());
        List list2 = Arrays.stream(this._direct).filter(bucket -> !bucket.isEmpty()).collect(Collectors.toList());
        if (this.isDetailedDump()) {
            arrayList.add(new DumpableCollection("Indirect Buckets", list));
            arrayList.add(new DumpableCollection("Direct Buckets", list2));
        } else {
            arrayList.add("Indirect Buckets size=" + list.size());
            arrayList.add("Direct Buckets size=" + list2.size());
        }
        Dumpable.dumpObjects(appendable, string, this, arrayList);
    }

    public String toString() {
        return String.format("%s@%x{minBufferCapacity=%s, maxBufferCapacity=%s, maxQueueLength=%s, factor=%s}", this.getClass().getSimpleName(), this.hashCode(), this._minCapacity, this._maxCapacity, this.getMaxQueueLength(), this.getCapacityFactor());
    }
}

