/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.http.pathmap.AbstractPathSpec;
import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RegexPathSpec
extends AbstractPathSpec {
    private static final Logger LOG = Log.getLogger(UriTemplatePathSpec.class);
    private static final Map<Character, String> FORBIDDEN_ESCAPED = new HashMap<Character, String>();
    private final String _declaration;
    private final PathSpecGroup _group;
    private final int _pathDepth;
    private final int _specLength;
    private final Pattern _pattern;

    public RegexPathSpec(String string) {
        Object object;
        String string2 = string.startsWith("regex|") ? string.substring("regex|".length()) : string;
        int n = string2.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        char c = '\u0000';
        for (int i = 0; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            block0 : switch (c2) {
                case '$': 
                case '\'': 
                case '(': 
                case ')': 
                case '^': {
                    break;
                }
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '|': {
                    stringBuilder.append('g');
                    break;
                }
                case '{': {
                    bl2 = true;
                    break;
                }
                case '}': {
                    bl2 = false;
                    break;
                }
                case '[': {
                    bl = true;
                    break;
                }
                case ']': {
                    bl = false;
                    stringBuilder.append('g');
                    break;
                }
                case '/': {
                    if (bl || bl2) break;
                    ++n2;
                    break;
                }
                default: {
                    if (bl || bl2 || !Character.isLetterOrDigit(c2)) break;
                    if (c == '\\') {
                        object = FORBIDDEN_ESCAPED.get(Character.valueOf(c2));
                        if (object != null) {
                            throw new IllegalArgumentException(String.format("%s does not support \\%c (%s) for \"%s\"", this.getClass().getSimpleName(), Character.valueOf(c2), object, string2));
                        }
                        switch (c2) {
                            case 'D': 
                            case 'S': 
                            case 'W': 
                            case 'd': 
                            case 'w': {
                                stringBuilder.append('g');
                                break block0;
                            }
                        }
                        stringBuilder.append('l');
                        break;
                    }
                    stringBuilder.append('l');
                }
            }
            c = c2;
        }
        Pattern pattern = Pattern.compile(string2);
        String string3 = stringBuilder.toString();
        object = Pattern.matches("^l*$", string3) ? PathSpecGroup.EXACT : (Pattern.matches("^l*g+", string3) ? PathSpecGroup.PREFIX_GLOB : (Pattern.matches("^g+l+.*", string3) ? PathSpecGroup.SUFFIX_GLOB : PathSpecGroup.MIDDLE_GLOB));
        this._declaration = string2;
        this._group = object;
        this._pathDepth = n2;
        this._specLength = n;
        this._pattern = pattern;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating RegexPathSpec[{}] (signature: [{}], group: {})", new Object[]{this._declaration, string3, this._group});
        }
    }

    protected Matcher getMatcher(String string) {
        int n = string.indexOf(63);
        if (n >= 0) {
            return this._pattern.matcher(string.substring(0, n));
        }
        return this._pattern.matcher(string);
    }

    @Override
    public int getSpecLength() {
        return this._specLength;
    }

    @Override
    public PathSpecGroup getGroup() {
        return this._group;
    }

    @Override
    public int getPathDepth() {
        return this._pathDepth;
    }

    @Override
    public String getPathInfo(String string) {
        Matcher matcher;
        if (this._group == PathSpecGroup.PREFIX_GLOB && (matcher = this.getMatcher(string)).matches() && matcher.groupCount() >= 1) {
            String string2 = matcher.group(1);
            if ("".equals(string2)) {
                return "/";
            }
            return string2;
        }
        return null;
    }

    @Override
    public String getPathMatch(String string) {
        Matcher matcher = this.getMatcher(string);
        if (matcher.matches()) {
            int n;
            if (this._group == PathSpecGroup.PREFIX_GLOB && matcher.groupCount() >= 1 && (n = matcher.start(1)) > 0) {
                if (string.charAt(n - 1) == '/') {
                    --n;
                }
                return string.substring(0, n);
            }
            return string;
        }
        return null;
    }

    @Override
    public String getDeclaration() {
        return this._declaration;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getSuffix() {
        return null;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    @Override
    public boolean matches(String string) {
        return this.getMatcher(string).matches();
    }

    @Override
    public MatchedPath matched(String string) {
        Matcher matcher = this.getMatcher(string);
        if (matcher.matches()) {
            return new RegexMatchedPath(this, string, matcher);
        }
        return null;
    }

    static {
        FORBIDDEN_ESCAPED.put(Character.valueOf('s'), "any whitespace");
        FORBIDDEN_ESCAPED.put(Character.valueOf('n'), "newline");
        FORBIDDEN_ESCAPED.put(Character.valueOf('r'), "carriage return");
        FORBIDDEN_ESCAPED.put(Character.valueOf('t'), "tab");
        FORBIDDEN_ESCAPED.put(Character.valueOf('f'), "form-feed");
        FORBIDDEN_ESCAPED.put(Character.valueOf('b'), "bell");
        FORBIDDEN_ESCAPED.put(Character.valueOf('e'), "escape");
        FORBIDDEN_ESCAPED.put(Character.valueOf('c'), "control char");
    }

    private class RegexMatchedPath
    implements MatchedPath {
        private final RegexPathSpec pathSpec;
        private final String path;
        private final Matcher matcher;

        public RegexMatchedPath(RegexPathSpec regexPathSpec2, String string, Matcher matcher) {
            this.pathSpec = regexPathSpec2;
            this.path = string;
            this.matcher = matcher;
        }

        @Override
        public String getPathMatch() {
            int n;
            try {
                String string = this.matcher.group("name");
                if (string != null) {
                    return string;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.pathSpec.getGroup() == PathSpecGroup.PREFIX_GLOB && this.matcher.groupCount() >= 1 && (n = this.matcher.start(1)) > 0) {
                if (this.path.charAt(n - 1) == '/') {
                    --n;
                }
                return this.path.substring(0, n);
            }
            return this.path;
        }

        @Override
        public String getPathInfo() {
            String string;
            try {
                string = this.matcher.group("info");
                if (string != null) {
                    return string;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.pathSpec.getGroup() == PathSpecGroup.PREFIX_GLOB && this.matcher.groupCount() >= 1) {
                string = this.matcher.group(1);
                if ("".equals(string)) {
                    return "/";
                }
                return string;
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[pathSpec=" + this.pathSpec + ", path=\"" + this.path + "\", matcher=" + this.matcher + ']';
        }
    }
}

