/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Objects;

public final class Syntax {
    public static void requireValidRFC2616Token(String string, String string2) {
        Objects.requireNonNull(string2, "msg cannot be null");
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= '\u001f' || c == '\u007f') {
                throw new IllegalArgumentException(string2 + ": RFC2616 tokens may not contain control characters");
            }
            if (c == '(' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ';' || c == ':' || c == '\\' || c == '\"' || c == '/' || c == '[' || c == ']' || c == '?' || c == '=' || c == '{' || c == '}' || c == ' ') {
                throw new IllegalArgumentException(string2 + ": RFC2616 tokens may not contain separator character: [" + c + "]");
            }
            if (c < '\u0080') continue;
            throw new IllegalArgumentException(string2 + ": RFC2616 tokens characters restricted to US-ASCII: 0x" + Integer.toHexString(c));
        }
    }

    public static void requireValidRFC6265CookieValue(String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        if (string.charAt(0) == '\"') {
            if (n <= 1 || string.charAt(n - 1) != '\"') {
                throw new IllegalArgumentException("RFC6265 Cookie values must have balanced DQUOTES (if used)");
            }
            ++n2;
            --n;
        }
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c <= '\u001f' || c == '\u007f') {
                throw new IllegalArgumentException("RFC6265 Cookie values may not contain control characters");
            }
            if (c == ' ' || c == '\"' || c == ';' || c == '\\') {
                throw new IllegalArgumentException("RFC6265 Cookie values may not contain character: [" + c + "]");
            }
            if (c >= '\u0080') {
                throw new IllegalArgumentException("RFC6265 Cookie values characters restricted to US-ASCII: 0x" + Integer.toHexString(c));
            }
            ++n2;
        }
    }
}

