/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Objects;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class HttpURI {
    private static final Trie<Boolean> __ambiguousSegments = new ArrayTrie<Boolean>();
    private String _scheme;
    private String _user;
    private String _host;
    private int _port;
    private String _path;
    private String _param;
    private String _query;
    private String _fragment;
    private String _uri;
    private String _decodedPath;
    private final EnumSet<Violation> _violations = EnumSet.noneOf(Violation.class);
    private boolean _emptySegment;

    public static HttpURI createHttpURI(String string, String string2, int n, String string3, String string4, String string5, String string6) {
        if (n == 80 && HttpScheme.HTTP.is(string)) {
            n = 0;
        }
        if (n == 443 && HttpScheme.HTTPS.is(string)) {
            n = 0;
        }
        return new HttpURI(string, string2, n, string3, string4, string5, string6);
    }

    public HttpURI() {
    }

    public HttpURI(String string, String string2, int n, String string3, String string4, String string5, String string6) {
        this._scheme = string;
        this._host = string2;
        this._port = n;
        if (string3 != null) {
            this.parse(State.PATH, string3, 0, string3.length());
        }
        if (string4 != null) {
            this._param = string4;
        }
        if (string5 != null) {
            this._query = string5;
        }
        if (string6 != null) {
            this._fragment = string6;
        }
    }

    public HttpURI(HttpURI httpURI) {
        this._scheme = httpURI._scheme;
        this._user = httpURI._user;
        this._host = httpURI._host;
        this._port = httpURI._port;
        this._path = httpURI._path;
        this._param = httpURI._param;
        this._query = httpURI._query;
        this._fragment = httpURI._fragment;
        this._uri = httpURI._uri;
        this._decodedPath = httpURI._decodedPath;
        this._violations.addAll(httpURI._violations);
        this._emptySegment = false;
    }

    public HttpURI(HttpURI httpURI, HttpURI httpURI2) {
        this._scheme = httpURI._scheme;
        this._user = httpURI._user;
        this._host = httpURI._host;
        this._port = httpURI._port;
        this._path = httpURI2._path;
        this._param = httpURI2._param;
        this._query = httpURI2._query;
        this._fragment = httpURI2._fragment;
        this._uri = httpURI2._uri;
        this._decodedPath = httpURI2._decodedPath;
        this._violations.addAll(httpURI2._violations);
        this._emptySegment = false;
    }

    public HttpURI(String string) {
        this._port = -1;
        this.parse(State.START, string, 0, string.length());
    }

    public HttpURI(URI uRI) {
        this._uri = null;
        this._scheme = uRI.getScheme();
        this._host = uRI.getHost();
        if (this._host == null && uRI.getRawSchemeSpecificPart().startsWith("//")) {
            this._host = "";
        }
        this._port = uRI.getPort();
        this._user = uRI.getUserInfo();
        String string = uRI.getRawPath();
        if (string != null) {
            this.parse(State.PATH, string, 0, string.length());
        }
        this._query = uRI.getRawQuery();
        this._fragment = uRI.getFragment();
    }

    public HttpURI(String string, String string2, int n, String string3) {
        this._uri = null;
        this._scheme = string;
        this._host = string2;
        this._port = n;
        if (string3 != null) {
            this.parse(State.PATH, string3, 0, string3.length());
        }
    }

    public void clear() {
        this._uri = null;
        this._scheme = null;
        this._user = null;
        this._host = null;
        this._port = -1;
        this._path = null;
        this._param = null;
        this._query = null;
        this._fragment = null;
        this._decodedPath = null;
        this._emptySegment = false;
        this._violations.clear();
    }

    public void parse(String string) {
        this.clear();
        this._uri = string;
        this.parse(State.START, string, 0, string.length());
    }

    public void parseRequestTarget(String string, String string2) {
        this.clear();
        this._uri = string2;
        if (HttpMethod.CONNECT.is(string)) {
            this.parse(State.HOST, string2, 0, string2.length());
        } else {
            this.parse(string2.startsWith("/") ? State.PATH : State.START, string2, 0, string2.length());
        }
    }

    @Deprecated
    public void parseConnect(String string) {
        this.clear();
        this._uri = string;
        this._path = string;
    }

    public void parse(String string, int n, int n2) {
        this.clear();
        int n3 = n + n2;
        this._uri = string.substring(n, n3);
        this.parse(State.START, string, n, n3);
    }

    private void parse(State state, String string, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = 0;
        boolean bl3 = false;
        block75: for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            switch (state) {
                case START: {
                    switch (c) {
                        case '/': {
                            n3 = i;
                            state = State.HOST_OR_PATH;
                            continue block75;
                        }
                        case ';': {
                            this.checkSegment(string, n5, i, true);
                            n3 = i + 1;
                            state = State.PARAM;
                            continue block75;
                        }
                        case '?': {
                            this.checkSegment(string, n5, i, false);
                            this._path = "";
                            n3 = i + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '#': {
                            this.checkSegment(string, n5, i, false);
                            this._path = "";
                            n3 = i + 1;
                            state = State.FRAGMENT;
                            continue block75;
                        }
                        case '*': {
                            this._path = "*";
                            state = State.ASTERISK;
                            continue block75;
                        }
                        case '%': {
                            bl = true;
                            n6 = 2;
                            n7 = 0;
                            n4 = n5 = i;
                            n3 = n5;
                            state = State.PATH;
                            continue block75;
                        }
                        case '.': {
                            bl3 = true;
                            n4 = n5 = i;
                            state = State.PATH;
                            continue block75;
                        }
                    }
                    n3 = i;
                    if (this._scheme == null) {
                        state = State.SCHEME_OR_PATH;
                        continue block75;
                    }
                    n4 = n5 = i;
                    state = State.PATH;
                    continue block75;
                }
                case SCHEME_OR_PATH: {
                    switch (c) {
                        case ':': {
                            this._scheme = string.substring(n3, i);
                            state = State.START;
                            continue block75;
                        }
                        case '/': {
                            n5 = i + 1;
                            state = State.PATH;
                            continue block75;
                        }
                        case ';': {
                            n3 = i + 1;
                            state = State.PARAM;
                            continue block75;
                        }
                        case '?': {
                            this._path = string.substring(n3, i);
                            n3 = i + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '%': {
                            bl = true;
                            n6 = 2;
                            n7 = 0;
                            state = State.PATH;
                            continue block75;
                        }
                        case '#': {
                            this._path = string.substring(n3, i);
                            state = State.FRAGMENT;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case HOST_OR_PATH: {
                    switch (c) {
                        case '/': {
                            this._host = "";
                            n3 = i + 1;
                            state = State.HOST;
                            continue block75;
                        }
                        case '#': 
                        case '%': 
                        case '.': 
                        case ';': 
                        case '?': 
                        case '@': {
                            --i;
                            n4 = n3;
                            n5 = n3 + 1;
                            state = State.PATH;
                            continue block75;
                        }
                    }
                    n4 = n3;
                    n5 = n3 + 1;
                    state = State.PATH;
                    continue block75;
                }
                case HOST: {
                    switch (c) {
                        case '/': {
                            this._host = string.substring(n3, i);
                            n4 = n3 = i;
                            n5 = n3 + 1;
                            state = State.PATH;
                            continue block75;
                        }
                        case ':': {
                            if (i > n3) {
                                this._host = string.substring(n3, i);
                            }
                            n3 = i + 1;
                            state = State.PORT;
                            continue block75;
                        }
                        case '@': {
                            if (this._user != null) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            this._user = string.substring(n3, i);
                            n3 = i + 1;
                            continue block75;
                        }
                        case '[': {
                            state = State.IPV6;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case IPV6: {
                    switch (c) {
                        case '/': {
                            throw new IllegalArgumentException("No closing ']' for ipv6 in " + string);
                        }
                        case ']': {
                            c = string.charAt(++i);
                            this._host = string.substring(n3, i);
                            if (c == ':') {
                                n3 = i + 1;
                                state = State.PORT;
                                continue block75;
                            }
                            n4 = n3 = i;
                            state = State.PATH;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case PORT: {
                    if (c == '@') {
                        if (this._user != null) {
                            throw new IllegalArgumentException("Bad authority");
                        }
                        this._user = this._host + ":" + string.substring(n3, i);
                        n3 = i + 1;
                        state = State.HOST;
                        continue block75;
                    }
                    if (c != '/') continue block75;
                    this._port = TypeUtil.parseInt(string, n3, i - n3, 10);
                    n4 = n3 = i;
                    n5 = i + 1;
                    state = State.PATH;
                    continue block75;
                }
                case PATH: {
                    if (n6 > 0) {
                        if (n6 == 2 && c == 'u' && !bl2) {
                            this._violations.add(Violation.UTF16);
                            bl2 = true;
                            n6 = 4;
                            continue block75;
                        }
                        n7 = (n7 << 4) + TypeUtil.convertHexDigit(c);
                        if (--n6 != 0) continue block75;
                        switch (n7) {
                            case 0: {
                                throw new IllegalArgumentException("Illegal character in path");
                            }
                            case 47: {
                                this._violations.add(Violation.SEPARATOR);
                                continue block75;
                            }
                            case 37: {
                                this._violations.add(Violation.ENCODING);
                                continue block75;
                            }
                        }
                        continue block75;
                    }
                    switch (c) {
                        case ';': {
                            this.checkSegment(string, n5, i, true);
                            n3 = i + 1;
                            state = State.PARAM;
                            continue block75;
                        }
                        case '?': {
                            this.checkSegment(string, n5, i, false);
                            this._path = string.substring(n4, i);
                            n3 = i + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '#': {
                            this.checkSegment(string, n5, i, false);
                            this._path = string.substring(n4, i);
                            n3 = i + 1;
                            state = State.FRAGMENT;
                            continue block75;
                        }
                        case '/': {
                            if (i != 0) {
                                this.checkSegment(string, n5, i, false);
                            }
                            n5 = i + 1;
                            continue block75;
                        }
                        case '.': {
                            bl3 |= n5 == i;
                            continue block75;
                        }
                        case '%': {
                            bl = true;
                            bl2 = false;
                            n6 = 2;
                            n7 = 0;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case PARAM: {
                    switch (c) {
                        case '?': {
                            this._path = string.substring(n4, i);
                            this._param = string.substring(n3, i);
                            n3 = i + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '#': {
                            this._path = string.substring(n4, i);
                            this._param = string.substring(n3, i);
                            n3 = i + 1;
                            state = State.FRAGMENT;
                            continue block75;
                        }
                        case '/': {
                            bl = true;
                            n5 = i + 1;
                            state = State.PATH;
                            continue block75;
                        }
                        case ';': {
                            n3 = i + 1;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case QUERY: {
                    if (c != '#') continue block75;
                    this._query = string.substring(n3, i);
                    n3 = i + 1;
                    state = State.FRAGMENT;
                    continue block75;
                }
                case ASTERISK: {
                    throw new IllegalArgumentException("Bad character '*'");
                }
                case FRAGMENT: {
                    this._fragment = string.substring(n3, n2);
                    i = n2;
                    continue block75;
                }
                default: {
                    throw new IllegalStateException(state.toString());
                }
            }
        }
        switch (state) {
            case START: {
                this._path = "";
                this.checkSegment(string, n5, n2, false);
                break;
            }
            case ASTERISK: {
                break;
            }
            case SCHEME_OR_PATH: 
            case HOST_OR_PATH: {
                this._path = string.substring(n3, n2);
                break;
            }
            case HOST: {
                if (n2 <= n3) break;
                this._host = string.substring(n3, n2);
                break;
            }
            case IPV6: {
                throw new IllegalArgumentException("No closing ']' for ipv6 in " + string);
            }
            case PORT: {
                this._port = TypeUtil.parseInt(string, n3, n2 - n3, 10);
                break;
            }
            case PARAM: {
                this._path = string.substring(n4, n2);
                this._param = string.substring(n3, n2);
                break;
            }
            case PATH: {
                this.checkSegment(string, n5, n2, false);
                this._path = string.substring(n4, n2);
                break;
            }
            case QUERY: {
                this._query = string.substring(n3, n2);
                break;
            }
            case FRAGMENT: {
                this._fragment = string.substring(n3, n2);
                break;
            }
            default: {
                throw new IllegalStateException(state.toString());
            }
        }
        if (!bl && !bl3) {
            this._decodedPath = this._param == null ? this._path : this._path.substring(0, this._path.length() - this._param.length() - 1);
        } else if (this._path != null) {
            String string2 = URIUtil.decodePath(this._path);
            this._decodedPath = URIUtil.canonicalPath(string2);
            if (this._decodedPath == null) {
                throw new IllegalArgumentException("Bad URI");
            }
        }
    }

    private void checkSegment(String string, int n, int n2, boolean bl) {
        Boolean bl2;
        if (this._emptySegment) {
            this._violations.add(Violation.EMPTY);
        }
        if (n2 == n) {
            if (n2 >= string.length() || "#?".indexOf(string.charAt(n2)) >= 0) {
                return;
            }
            if (n == 0) {
                this._violations.add(Violation.EMPTY);
                return;
            }
            if (!this._emptySegment) {
                this._emptySegment = true;
                return;
            }
        }
        if ((bl2 = __ambiguousSegments.get(string, n, n2 - n)) != null) {
            if (Boolean.TRUE.equals(bl2)) {
                this._violations.add(Violation.SEGMENT);
            }
            if (bl) {
                this._violations.add(Violation.PARAM);
            }
        }
    }

    public boolean hasAmbiguousSegment() {
        return this._violations.contains((Object)Violation.SEGMENT);
    }

    public boolean hasAmbiguousEmptySegment() {
        return this._violations.contains((Object)Violation.EMPTY);
    }

    public boolean hasAmbiguousSeparator() {
        return this._violations.contains((Object)Violation.SEPARATOR);
    }

    public boolean hasAmbiguousParameter() {
        return this._violations.contains((Object)Violation.PARAM);
    }

    public boolean hasAmbiguousEncoding() {
        return this._violations.contains((Object)Violation.ENCODING);
    }

    public boolean isAmbiguous() {
        return !this._violations.isEmpty() && (this._violations.size() != 1 || !this._violations.contains((Object)Violation.UTF16));
    }

    public boolean hasViolations() {
        return !this._violations.isEmpty();
    }

    boolean hasViolation(Violation violation) {
        return this._violations.contains((Object)violation);
    }

    public boolean hasUtf16Encoding() {
        return this._violations.contains((Object)Violation.UTF16);
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getHost() {
        if (this._host != null && this._host.isEmpty()) {
            return null;
        }
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getPath() {
        return this._path;
    }

    public String getDecodedPath() {
        return this._decodedPath;
    }

    public String getParam() {
        return this._param;
    }

    public void setParam(String string) {
        if (!Objects.equals(this._param, string)) {
            if (this._param != null && this._path.endsWith(";" + this._param)) {
                this._path = this._path.substring(0, this._path.length() - 1 - this._param.length());
            }
            this._param = string;
            if (this._param != null) {
                this._path = (this._path == null ? "" : this._path) + ";" + this._param;
            }
            this._uri = null;
        }
    }

    public String getQuery() {
        return this._query;
    }

    public boolean hasQuery() {
        return this._query != null && !this._query.isEmpty();
    }

    public String getFragment() {
        return this._fragment;
    }

    public void decodeQueryTo(MultiMap<String> multiMap) {
        if (this._query == null) {
            return;
        }
        UrlEncoded.decodeUtf8To(this._query, multiMap);
    }

    public void decodeQueryTo(MultiMap<String> multiMap, String string) throws UnsupportedEncodingException {
        this.decodeQueryTo(multiMap, Charset.forName(string));
    }

    public void decodeQueryTo(MultiMap<String> multiMap, Charset charset) throws UnsupportedEncodingException {
        if (this._query == null) {
            return;
        }
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(this._query, multiMap);
        } else {
            UrlEncoded.decodeTo(this._query, multiMap, charset);
        }
    }

    public boolean isAbsolute() {
        return this._scheme != null && !this._scheme.isEmpty();
    }

    public String toString() {
        if (this._uri == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this._scheme != null) {
                stringBuilder.append(this._scheme).append(':');
            }
            if (this._host != null) {
                stringBuilder.append("//");
                if (this._user != null) {
                    stringBuilder.append(this._user).append('@');
                }
                stringBuilder.append(this._host);
            }
            if (this._port > 0) {
                stringBuilder.append(':').append(this._port);
            }
            if (this._path != null) {
                stringBuilder.append(this._path);
            }
            if (this._query != null) {
                stringBuilder.append('?').append(this._query);
            }
            if (this._fragment != null) {
                stringBuilder.append('#').append(this._fragment);
            }
            this._uri = stringBuilder.length() > 0 ? stringBuilder.toString() : "";
        }
        return this._uri;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpURI)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setScheme(String string) {
        this._scheme = string;
        this._uri = null;
    }

    public void setAuthority(String string, int n) {
        if (string != null && !this.isPathValidForAuthority(this._path)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._host = string;
        this._port = n;
        this._uri = null;
    }

    private boolean isPathValidForAuthority(String string) {
        if (string == null) {
            return true;
        }
        if (string.isEmpty() || "*".equals(string)) {
            return true;
        }
        return string.startsWith("/");
    }

    public void setPath(String string) {
        if (this.hasAuthority() && !this.isPathValidForAuthority(string)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._uri = null;
        this._path = null;
        if (string != null) {
            this.parse(State.PATH, string, 0, string.length());
        }
    }

    public void setPathQuery(String string) {
        if (this.hasAuthority() && !this.isPathValidForAuthority(string)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._uri = null;
        this._path = null;
        this._decodedPath = null;
        this._param = null;
        this._fragment = null;
        if (string != null) {
            this.parse(State.PATH, string, 0, string.length());
        }
    }

    private boolean hasAuthority() {
        return this._host != null;
    }

    public void setQuery(String string) {
        this._query = string;
        this._uri = null;
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this._scheme, null, this._host, this._port, this._path, this._query == null ? null : UrlEncoded.decodeString(this._query), this._fragment);
    }

    public String getPathQuery() {
        if (this._query == null) {
            return this._path;
        }
        return this._path + "?" + this._query;
    }

    public String getAuthority() {
        if (this._port > 0) {
            return this._host + ":" + this._port;
        }
        return this._host;
    }

    public String getUser() {
        return this._user;
    }

    static {
        __ambiguousSegments.put(".", Boolean.FALSE);
        __ambiguousSegments.put("%2e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e", Boolean.TRUE);
        __ambiguousSegments.put("..", Boolean.FALSE);
        __ambiguousSegments.put(".%2e", Boolean.TRUE);
        __ambiguousSegments.put(".%u002e", Boolean.TRUE);
        __ambiguousSegments.put("%2e.", Boolean.TRUE);
        __ambiguousSegments.put("%2e%2e", Boolean.TRUE);
        __ambiguousSegments.put("%2e%u002e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e.", Boolean.TRUE);
        __ambiguousSegments.put("%u002e%2e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e%u002e", Boolean.TRUE);
    }

    static enum Violation {
        SEGMENT("Ambiguous path segments"),
        SEPARATOR("Ambiguous path separator"),
        PARAM("Ambiguous path parameters"),
        ENCODING("Ambiguous double encoding"),
        EMPTY("Ambiguous empty segments"),
        UTF16("Non standard UTF-16 encoding");

        private final String _message;

        private Violation(String string2) {
            this._message = string2;
        }

        String getMessage() {
            return this._message;
        }
    }

    private static enum State {
        START,
        HOST_OR_PATH,
        SCHEME_OR_PATH,
        HOST,
        IPV6,
        PORT,
        PATH,
        PARAM,
        QUERY,
        FRAGMENT,
        ASTERISK;

    }
}

