/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.Objects;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.URIUtil;

public class Origin {
    private final String scheme;
    private final Address address;
    private final Object tag;

    public Origin(String string, String string2, int n) {
        this(string, string2, n, null);
    }

    public Origin(String string, String string2, int n, Object object) {
        this(string, new Address(string2, n), object);
    }

    public Origin(String string, Address address) {
        this(string, address, null);
    }

    public Origin(String string, Address address, Object object) {
        this.scheme = Objects.requireNonNull(string);
        this.address = address;
        this.tag = object;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Address getAddress() {
        return this.address;
    }

    public Object getTag() {
        return this.tag;
    }

    public String asString() {
        StringBuilder stringBuilder = new StringBuilder();
        URIUtil.appendSchemeHostPort(stringBuilder, this.scheme, this.address.host, this.address.port);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Origin origin = (Origin)object;
        return this.scheme.equals(origin.scheme) && this.address.equals(origin.address) && Objects.equals(this.tag, origin.tag);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.address, this.tag);
    }

    public String toString() {
        String string = this.asString();
        if (this.tag != null) {
            string = string + "[tag=" + this.tag + "]";
        }
        return string;
    }

    public static class Address {
        private final String host;
        private final int port;

        public Address(String string, int n) {
            this.host = HostPort.normalizeHost(Objects.requireNonNull(string));
            this.port = n;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Address address = (Address)object;
            return this.host.equals(address.host) && this.port == address.port;
        }

        public int hashCode() {
            int n = this.host.hashCode();
            n = 31 * n + this.port;
            return n;
        }

        public String asString() {
            return String.format("%s:%d", this.host, this.port);
        }

        public String toString() {
            return this.asString();
        }
    }
}

