/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class QNameCache {
    protected Map noNamespaceCache = Collections.synchronizedMap(new WeakHashMap());
    protected Map namespaceCache = Collections.synchronizedMap(new WeakHashMap());
    private DocumentFactory documentFactory;

    public QNameCache() {
    }

    public QNameCache(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public List getQNames() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.noNamespaceCache.values());
        Iterator iterator = this.namespaceCache.values().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public QName get(String string) {
        QName qName = null;
        if (string != null) {
            qName = (QName)this.noNamespaceCache.get(string);
        } else {
            string = "";
        }
        if (qName == null) {
            qName = this.createQName(string);
            qName.setDocumentFactory(this.documentFactory);
            this.noNamespaceCache.put(string, qName);
        }
        return qName;
    }

    public QName get(String string, Namespace namespace) {
        Map map = this.getNamespaceCache(namespace);
        QName qName = null;
        if (string != null) {
            qName = (QName)map.get(string);
        } else {
            string = "";
        }
        if (qName == null) {
            qName = this.createQName(string, namespace);
            qName.setDocumentFactory(this.documentFactory);
            map.put(string, qName);
        }
        return qName;
    }

    public QName get(String string, Namespace namespace, String string2) {
        Map map = this.getNamespaceCache(namespace);
        QName qName = null;
        if (string != null) {
            qName = (QName)map.get(string);
        } else {
            string = "";
        }
        if (qName == null) {
            qName = this.createQName(string, namespace, string2);
            qName.setDocumentFactory(this.documentFactory);
            map.put(string, qName);
        }
        return qName;
    }

    public QName get(String string, String string2) {
        int n = string.indexOf(58);
        if (n < 0) {
            return this.get(string, Namespace.get(string2));
        }
        String string3 = string.substring(n + 1);
        String string4 = string.substring(0, n);
        return this.get(string3, Namespace.get(string4, string2));
    }

    public QName intern(QName qName) {
        return this.get(qName.getName(), qName.getNamespace(), qName.getQualifiedName());
    }

    protected Map getNamespaceCache(Namespace namespace) {
        if (namespace == Namespace.NO_NAMESPACE) {
            return this.noNamespaceCache;
        }
        Map map = null;
        if (namespace != null) {
            map = (Map)this.namespaceCache.get(namespace);
        }
        if (map == null) {
            map = this.createMap();
            this.namespaceCache.put(namespace, map);
        }
        return map;
    }

    protected Map createMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    protected QName createQName(String string) {
        return new QName(string);
    }

    protected QName createQName(String string, Namespace namespace) {
        return new QName(string, namespace);
    }

    protected QName createQName(String string, Namespace namespace, String string2) {
        return new QName(string, namespace, string2);
    }
}

