/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.cryptomator.cryptofs.PerOpenFile;

@PerOpenFile
class OpenCounter {
    private final AtomicLong count = new AtomicLong(0L);

    @Inject
    public OpenCounter() {
    }

    public OpenState countOpen() {
        long l = this.count.getAndIncrement();
        if (l > 0L) {
            return OpenState.WAS_OPEN;
        }
        if (l == 0L) {
            return OpenState.JUST_OPENED;
        }
        return OpenState.ALREADY_CLOSED;
    }

    public boolean countClose() {
        return this.count.updateAndGet(this::countClose) <= 0L;
    }

    private long countClose(long l) {
        if (l < 1L) {
            throw new IllegalStateException("Close without corresponding open");
        }
        long l2 = l - 1L;
        if (l2 == 0L) {
            return Long.MIN_VALUE;
        }
        return l2;
    }

    public static enum OpenState {
        JUST_OPENED,
        WAS_OPEN,
        ALREADY_CLOSED;

    }
}

