/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.PatternSyntaxException;

class GlobToRegex {
    private static final CharMatcher REGEX_RESERVED = CharMatcher.anyOf("^$.?+*\\[]{}()");
    private final String glob;
    private final char separator;
    private final CharMatcher separatorMatcher;
    private final StringBuilder builder = new StringBuilder();
    private final Deque<State> states = new ArrayDeque<State>();
    private int index;
    private static final State NORMAL = new State(){

        @Override
        void process(GlobToRegex globToRegex, char c) {
            switch (c) {
                case '?': {
                    globToRegex.appendQuestionMark();
                    return;
                }
                case '[': {
                    globToRegex.appendBracketStart();
                    globToRegex.pushState(BRACKET_FIRST_CHAR);
                    return;
                }
                case '{': {
                    globToRegex.appendCurlyBraceStart();
                    globToRegex.pushState(CURLY_BRACE);
                    return;
                }
                case '*': {
                    globToRegex.pushState(STAR);
                    return;
                }
                case '\\': {
                    globToRegex.pushState(ESCAPE);
                    return;
                }
            }
            globToRegex.append(c);
        }
    };
    private static final State ESCAPE = new State(){

        @Override
        void process(GlobToRegex globToRegex, char c) {
            globToRegex.append(c);
            globToRegex.popState();
        }

        @Override
        void finish(GlobToRegex globToRegex) {
            throw globToRegex.syntaxError("Hanging escape (\\) at end of pattern");
        }
    };
    private static final State STAR = new State(){

        @Override
        void process(GlobToRegex globToRegex, char c) {
            if (c == '*') {
                globToRegex.appendStarStar();
                globToRegex.popState();
            } else {
                globToRegex.appendStar();
                globToRegex.popState();
                globToRegex.currentState().process(globToRegex, c);
            }
        }

        @Override
        void finish(GlobToRegex globToRegex) {
            globToRegex.appendStar();
        }
    };
    private static final State BRACKET_FIRST_CHAR = new State(){

        @Override
        void process(GlobToRegex globToRegex, char c) {
            if (c == ']') {
                throw globToRegex.syntaxError("Empty []");
            }
            if (c == '!') {
                globToRegex.appendExact('^');
            } else if (c == '-') {
                globToRegex.appendExact(c);
            } else {
                globToRegex.appendInBracket(c);
            }
            globToRegex.popState();
            globToRegex.pushState(BRACKET);
        }

        @Override
        void finish(GlobToRegex globToRegex) {
            throw globToRegex.syntaxError("Unclosed [");
        }
    };
    private static final State BRACKET = new State(){

        @Override
        void process(GlobToRegex globToRegex, char c) {
            if (c == ']') {
                globToRegex.appendBracketEnd();
                globToRegex.popState();
            } else {
                globToRegex.appendInBracket(c);
            }
        }

        @Override
        void finish(GlobToRegex globToRegex) {
            throw globToRegex.syntaxError("Unclosed [");
        }
    };
    private static final State CURLY_BRACE = new State(){

        @Override
        void process(GlobToRegex globToRegex, char c) {
            switch (c) {
                case '?': {
                    globToRegex.appendQuestionMark();
                    break;
                }
                case '[': {
                    globToRegex.appendBracketStart();
                    globToRegex.pushState(BRACKET_FIRST_CHAR);
                    break;
                }
                case '{': {
                    throw globToRegex.syntaxError("{ not allowed in subpattern group");
                }
                case '*': {
                    globToRegex.pushState(STAR);
                    break;
                }
                case '\\': {
                    globToRegex.pushState(ESCAPE);
                    break;
                }
                case '}': {
                    globToRegex.appendCurlyBraceEnd();
                    globToRegex.popState();
                    break;
                }
                case ',': {
                    globToRegex.appendSubpatternSeparator();
                    break;
                }
                default: {
                    globToRegex.append(c);
                }
            }
        }

        @Override
        void finish(GlobToRegex globToRegex) {
            throw globToRegex.syntaxError("Unclosed {");
        }
    };

    public static String toRegex(String string, char c) {
        return new GlobToRegex(string, c).convert();
    }

    private GlobToRegex(String string, char c) {
        this.glob = Preconditions.checkNotNull(string);
        this.separator = c;
        this.separatorMatcher = CharMatcher.anyOf(String.valueOf(c));
    }

    private String convert() {
        this.pushState(NORMAL);
        this.index = 0;
        while (this.index < this.glob.length()) {
            this.currentState().process(this, this.glob.charAt(this.index));
            ++this.index;
        }
        this.currentState().finish(this);
        return this.builder.toString();
    }

    private void pushState(State state) {
        this.states.push(state);
    }

    private void popState() {
        this.states.pop();
    }

    private State currentState() {
        return this.states.peek();
    }

    private PatternSyntaxException syntaxError(String string) {
        throw new PatternSyntaxException(string, this.glob, this.index);
    }

    private void appendExact(char c) {
        this.builder.append(c);
    }

    private void append(char c) {
        if (this.separatorMatcher.matches(c)) {
            this.appendSeparator();
        } else {
            this.appendNormal(c);
        }
    }

    private void appendNormal(char c) {
        if (REGEX_RESERVED.matches(c)) {
            this.builder.append('\\');
        }
        this.builder.append(c);
    }

    private void appendSeparator() {
        this.appendNormal(this.separator);
    }

    private void appendNonSeparator() {
        this.builder.append("[^");
        this.appendInBracket(this.separator);
        this.builder.append(']');
    }

    private void appendQuestionMark() {
        this.appendNonSeparator();
    }

    private void appendStar() {
        this.appendNonSeparator();
        this.builder.append('*');
    }

    private void appendStarStar() {
        this.builder.append(".*");
    }

    private void appendBracketStart() {
        this.builder.append('[');
        this.appendNonSeparator();
        this.builder.append("&&[");
    }

    private void appendBracketEnd() {
        this.builder.append("]]");
    }

    private void appendInBracket(char c) {
        if (c == '\\') {
            this.builder.append('\\');
        }
        this.builder.append(c);
    }

    private void appendCurlyBraceStart() {
        this.builder.append('(');
    }

    private void appendSubpatternSeparator() {
        this.builder.append('|');
    }

    private void appendCurlyBraceEnd() {
        this.builder.append(')');
    }

    private static abstract class State {
        private State() {
        }

        abstract void process(GlobToRegex var1, char var2);

        void finish(GlobToRegex globToRegex) {
        }
    }
}

