/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.DirectoryIdProvider;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.PathToVault;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptolib.api.Cryptor;

@PerFileSystem
class CryptoPathMapper {
    private static final int MAX_CACHED_DIR_PATHS = 1000;
    private final Cryptor cryptor;
    private final Path dataRoot;
    private final DirectoryIdProvider dirIdProvider;
    private final LongFileNameProvider longFileNameProvider;
    private final LoadingCache<String, Path> directoryPathCache;

    @Inject
    public CryptoPathMapper(@PathToVault Path path, Cryptor cryptor, DirectoryIdProvider directoryIdProvider, LongFileNameProvider longFileNameProvider) {
        this.dataRoot = path.resolve("d");
        this.cryptor = cryptor;
        this.dirIdProvider = directoryIdProvider;
        this.longFileNameProvider = longFileNameProvider;
        this.directoryPathCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(this::resolveDirectory));
    }

    public Path getCiphertextFilePath(CryptoPath cryptoPath, CiphertextFileType ciphertextFileType) throws IOException {
        if (cryptoPath.getNameCount() == 0) {
            throw new IllegalArgumentException("Invalid file path " + cryptoPath);
        }
        CryptoPath cryptoPath2 = cryptoPath.getParent();
        assert (cryptoPath2 != null) : "namecount > 0";
        Directory directory = this.getCiphertextDir(cryptoPath2);
        String string = cryptoPath.getFileName().toString();
        String string2 = this.getCiphertextFileName(directory.dirId, string, ciphertextFileType);
        return directory.path.resolve(string2);
    }

    private String getCiphertextFileName(String string, String string2, CiphertextFileType ciphertextFileType) throws IOException {
        String string3 = ciphertextFileType == CiphertextFileType.DIRECTORY ? "0" : "";
        String string4 = string3 + this.cryptor.fileNameCryptor().encryptFilename(string2, new byte[][]{string.getBytes(StandardCharsets.UTF_8)});
        if (string4.length() >= 129) {
            return this.longFileNameProvider.deflate(string4);
        }
        return string4;
    }

    public Path getCiphertextDirPath(CryptoPath cryptoPath) throws IOException {
        return this.getCiphertextDir((CryptoPath)cryptoPath).path;
    }

    public Directory getCiphertextDir(CryptoPath cryptoPath) throws IOException {
        assert (cryptoPath.isAbsolute());
        if (cryptoPath.getNameCount() == 0) {
            return new Directory("", this.directoryPathCache.getUnchecked(""));
        }
        CryptoPath cryptoPath2 = cryptoPath.getParent();
        assert (cryptoPath2 != null) : "namecount > 0";
        Directory directory = this.getCiphertextDir(cryptoPath2);
        String string = cryptoPath.getFileName().toString();
        String string2 = this.getCiphertextFileName(directory.dirId, string, CiphertextFileType.DIRECTORY);
        Path path = directory.path.resolve(string2);
        return this.resolveDirectory(path);
    }

    public Directory resolveDirectory(Path path) throws IOException {
        String string = this.dirIdProvider.load(path);
        Path path2 = this.directoryPathCache.getUnchecked(string);
        return new Directory(string, path2);
    }

    private Path resolveDirectory(String string) {
        String string2 = this.cryptor.fileNameCryptor().hashDirectoryId(string);
        return this.dataRoot.resolve(string2.substring(0, 2)).resolve(string2.substring(2));
    }

    public static class Directory {
        public final String dirId;
        public final Path path;

        public Directory(String string, Path path) {
            this.dirId = string;
            this.path = path;
        }
    }

    public static enum CiphertextFileType {
        FILE,
        DIRECTORY;

    }
}

