/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.cryptomator.cryptofs.ArrayUtils;
import org.cryptomator.cryptofs.CryptoFileAttributeByNameProvider;
import org.cryptomator.cryptofs.CryptoFileAttributeProvider;
import org.cryptomator.cryptofs.CryptoFileAttributeViewProvider;
import org.cryptomator.cryptofs.CryptoFileStore;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.CryptoFileSystems;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathFactory;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.DirectoryIdProvider;
import org.cryptomator.cryptofs.DirectoryStreamFactory;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.FinallyUtil;
import org.cryptomator.cryptofs.OpenCryptoFiles;
import org.cryptomator.cryptofs.PathMatcherFactory;
import org.cryptomator.cryptofs.PathToVault;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptofs.RootDirectoryInitializer;
import org.cryptomator.cryptolib.api.Cryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PerFileSystem
class CryptoFileSystemImpl
extends CryptoFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoFileSystemImpl.class);
    private final CryptoPath rootPath;
    private final CryptoPath emptyPath;
    private final CryptoFileSystemProvider provider;
    private final CryptoFileSystems cryptoFileSystems;
    private final Path pathToVault;
    private final Cryptor cryptor;
    private final CryptoPathMapper cryptoPathMapper;
    private final DirectoryIdProvider dirIdProvider;
    private final CryptoFileAttributeProvider fileAttributeProvider;
    private final CryptoFileAttributeByNameProvider fileAttributeByNameProvider;
    private final CryptoFileAttributeViewProvider fileAttributeViewProvider;
    private final DirectoryStreamFactory directoryStreamFactory;
    private final OpenCryptoFiles openCryptoFiles;
    private final CryptoFileStore fileStore;
    private final PathMatcherFactory pathMatcherFactory;
    private final CryptoPathFactory cryptoPathFactory;
    private final CryptoFileSystemStats stats;
    private final FinallyUtil finallyUtil;
    private volatile boolean open = true;

    @Inject
    public CryptoFileSystemImpl(@PathToVault Path path, CryptoFileSystemProperties cryptoFileSystemProperties, Cryptor cryptor, CryptoFileSystemProvider cryptoFileSystemProvider, CryptoFileSystems cryptoFileSystems, CryptoFileStore cryptoFileStore, OpenCryptoFiles openCryptoFiles, CryptoPathMapper cryptoPathMapper, DirectoryIdProvider directoryIdProvider, CryptoFileAttributeProvider cryptoFileAttributeProvider, CryptoFileAttributeViewProvider cryptoFileAttributeViewProvider, PathMatcherFactory pathMatcherFactory, CryptoPathFactory cryptoPathFactory, CryptoFileSystemStats cryptoFileSystemStats, RootDirectoryInitializer rootDirectoryInitializer, CryptoFileAttributeByNameProvider cryptoFileAttributeByNameProvider, DirectoryStreamFactory directoryStreamFactory, FinallyUtil finallyUtil) {
        this.cryptor = cryptor;
        this.provider = cryptoFileSystemProvider;
        this.cryptoFileSystems = cryptoFileSystems;
        this.pathToVault = path;
        this.cryptoPathMapper = cryptoPathMapper;
        this.dirIdProvider = directoryIdProvider;
        this.fileAttributeProvider = cryptoFileAttributeProvider;
        this.fileAttributeByNameProvider = cryptoFileAttributeByNameProvider;
        this.fileAttributeViewProvider = cryptoFileAttributeViewProvider;
        this.openCryptoFiles = openCryptoFiles;
        this.fileStore = cryptoFileStore;
        this.pathMatcherFactory = pathMatcherFactory;
        this.cryptoPathFactory = cryptoPathFactory;
        this.stats = cryptoFileSystemStats;
        this.directoryStreamFactory = directoryStreamFactory;
        this.rootPath = cryptoPathFactory.rootFor(this);
        this.emptyPath = cryptoPathFactory.emptyFor(this);
        this.finallyUtil = finallyUtil;
        rootDirectoryInitializer.initialize(this.rootPath);
    }

    @Override
    public Path getPathToVault() {
        return this.pathToVault;
    }

    @Override
    public CryptoFileSystemStats getStats() {
        return this.stats;
    }

    @Override
    public FileSystemProvider provider() {
        this.assertOpen();
        return this.provider;
    }

    @Override
    public boolean isReadOnly() {
        this.assertOpen();
        return false;
    }

    @Override
    public String getSeparator() {
        this.assertOpen();
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        this.assertOpen();
        return Collections.singleton(this.getRootPath());
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        this.assertOpen();
        return Collections.singleton(this.fileStore);
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            this.finallyUtil.guaranteeInvocationOf(() -> this.cryptoFileSystems.remove(this), () -> this.openCryptoFiles.close(), () -> this.directoryStreamFactory.close(), () -> this.cryptor.destroy());
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        this.assertOpen();
        return this.fileStore.supportedFileAttributeViewNames();
    }

    @Override
    public CryptoPath getPath(String string, String ... stringArray) {
        this.assertOpen();
        return this.cryptoPathFactory.getPath(this, string, stringArray);
    }

    @Override
    public PathMatcher getPathMatcher(String string) {
        this.assertOpen();
        return this.pathMatcherFactory.pathMatcherFrom(string);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    void setAttribute(CryptoPath cryptoPath, String string, Object object, LinkOption ... linkOptionArray) throws IOException {
        Path path = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath);
        if (Files.notExists(path, new LinkOption[0]) && cryptoPath.getNameCount() > 0) {
            Path path2 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.FILE);
            this.fileAttributeByNameProvider.setAttribute(path2, string, object);
        } else {
            this.fileAttributeByNameProvider.setAttribute(path, string, object);
        }
    }

    Map<String, Object> readAttributes(CryptoPath cryptoPath, String string, LinkOption ... linkOptionArray) throws IOException {
        Path path = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath);
        if (Files.notExists(path, new LinkOption[0]) && cryptoPath.getNameCount() > 0) {
            Path path2 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.FILE);
            return this.fileAttributeByNameProvider.readAttributes(path2, string);
        }
        return this.fileAttributeByNameProvider.readAttributes(path, string);
    }

    <A extends BasicFileAttributes> A readAttributes(CryptoPath cryptoPath, Class<A> clazz, LinkOption ... linkOptionArray) throws IOException {
        Path path = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath);
        if (Files.notExists(path, new LinkOption[0]) && cryptoPath.getNameCount() > 0) {
            Path path2 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.FILE);
            return this.fileAttributeProvider.readAttributes(path2, clazz);
        }
        return this.fileAttributeProvider.readAttributes(path, clazz);
    }

    <V extends FileAttributeView> V getFileAttributeView(CryptoPath cryptoPath, Class<V> clazz, LinkOption ... linkOptionArray) {
        try {
            Path path = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath);
            if (Files.notExists(path, new LinkOption[0]) && cryptoPath.getNameCount() > 0) {
                Path path2 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.FILE);
                return this.fileAttributeViewProvider.getAttributeView(path2, clazz);
            }
            return this.fileAttributeViewProvider.getAttributeView(path, clazz);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    void checkAccess(CryptoPath cryptoPath, AccessMode ... accessModeArray) throws IOException {
        if (this.fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
            Set<PosixFilePermission> set = this.readAttributes(cryptoPath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            boolean bl = Arrays.stream(accessModeArray).anyMatch(accessMode -> !this.hasAccess(set, (AccessMode)((Object)accessMode)));
            if (bl) {
                throw new AccessDeniedException(cryptoPath.toString());
            }
        } else if (this.fileStore.supportsFileAttributeView(DosFileAttributeView.class)) {
            DosFileAttributes dosFileAttributes = this.readAttributes(cryptoPath, DosFileAttributes.class, new LinkOption[0]);
            if (ArrayUtils.contains((Object[])accessModeArray, (Object)AccessMode.WRITE) && dosFileAttributes.isReadOnly()) {
                throw new AccessDeniedException(cryptoPath.toString(), null, "read only file");
            }
        } else {
            this.readAttributes(cryptoPath, BasicFileAttributes.class, new LinkOption[0]);
        }
    }

    private boolean hasAccess(Set<PosixFilePermission> set, AccessMode accessMode) {
        switch (accessMode) {
            case READ: {
                return set.contains((Object)PosixFilePermission.OWNER_READ);
            }
            case WRITE: {
                return set.contains((Object)PosixFilePermission.OWNER_WRITE);
            }
            case EXECUTE: {
                return set.contains((Object)PosixFilePermission.OWNER_EXECUTE);
            }
        }
        throw new UnsupportedOperationException("AccessMode " + (Object)((Object)accessMode) + " not supported.");
    }

    boolean isHidden(CryptoPath cryptoPath) throws IOException {
        DosFileAttributeView dosFileAttributeView = this.getFileAttributeView(cryptoPath, DosFileAttributeView.class, new LinkOption[0]);
        if (dosFileAttributeView != null) {
            return dosFileAttributeView.readAttributes().isHidden();
        }
        return false;
    }

    void createDirectory(CryptoPath cryptoPath, FileAttribute<?> ... fileAttributeArray) throws IOException {
        CryptoPath cryptoPath2 = cryptoPath.getParent();
        if (cryptoPath2 == null) {
            return;
        }
        Path path = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath2);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NoSuchFileException(cryptoPath2.toString());
        }
        Path path2 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.FILE);
        if (Files.exists(path2, new LinkOption[0])) {
            throw new FileAlreadyExistsException(cryptoPath.toString());
        }
        Path path3 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.DIRECTORY);
        CryptoPathMapper.Directory directory = this.cryptoPathMapper.getCiphertextDir(cryptoPath);
        try (FileChannel fileChannel = FileChannel.open(path3, EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), fileAttributeArray);){
            fileChannel.write(ByteBuffer.wrap(directory.dirId.getBytes(StandardCharsets.UTF_8)));
        }
        try {
            Files.createDirectories(directory.path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            Files.delete(path3);
            this.dirIdProvider.delete(path3);
            throw iOException;
        }
    }

    DirectoryStream<Path> newDirectoryStream(CryptoPath cryptoPath, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.directoryStreamFactory.newDirectoryStream(cryptoPath, filter);
    }

    FileChannel newFileChannel(CryptoPath cryptoPath, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        EffectiveOpenOptions effectiveOpenOptions = EffectiveOpenOptions.from(set);
        Path path = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.FILE);
        return this.openCryptoFiles.get(path, effectiveOpenOptions).newFileChannel(effectiveOpenOptions);
    }

    void delete(CryptoPath cryptoPath) throws IOException {
        Path path = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.FILE);
        if (!Files.deleteIfExists(path)) {
            Path path2 = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath);
            Path path3 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.DIRECTORY);
            try {
                Files.delete(path2);
                if (!Files.deleteIfExists(path3)) {
                    LOG.warn("Successfully deleted dir {}, but didn't find corresponding dir file {}", (Object)path2, (Object)path3);
                }
                this.dirIdProvider.delete(path3);
            }
            catch (NoSuchFileException noSuchFileException) {
                throw new NoSuchFileException(cryptoPath.toString());
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                throw new DirectoryNotEmptyException(cryptoPath.toString());
            }
        }
    }

    void copy(CryptoPath cryptoPath, CryptoPath cryptoPath2, CopyOption ... copyOptionArray) throws IOException {
        if (cryptoPath.equals(cryptoPath2)) {
            return;
        }
        Path path = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.FILE);
        Path path2 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.DIRECTORY);
        if (Files.exists(path, new LinkOption[0])) {
            Path path3 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath2, CryptoPathMapper.CiphertextFileType.FILE);
            Files.copy(path, path3, copyOptionArray);
        } else if (Files.exists(path2, new LinkOption[0])) {
            Iterable<Path> iterable;
            Path path4;
            block22: {
                Path path5 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath2, CryptoPathMapper.CiphertextFileType.DIRECTORY);
                if (!Files.exists(path5, new LinkOption[0])) {
                    this.createDirectory(cryptoPath2, new FileAttribute[0]);
                } else {
                    if (ArrayUtils.contains(copyOptionArray, StandardCopyOption.REPLACE_EXISTING)) {
                        path4 = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath2);
                        iterable = Files.newDirectoryStream(path4);
                        Throwable throwable = null;
                        try {
                            if (iterable.iterator().hasNext()) {
                                throw new DirectoryNotEmptyException(cryptoPath2.toString());
                            }
                            break block22;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (iterable != null) {
                                if (throwable != null) {
                                    try {
                                        iterable.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    iterable.close();
                                }
                            }
                        }
                    }
                    throw new FileAlreadyExistsException(cryptoPath2.toString());
                }
            }
            if (ArrayUtils.contains(copyOptionArray, StandardCopyOption.COPY_ATTRIBUTES)) {
                path4 = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath);
                iterable = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath2);
                this.copyAttributes(path4, (Path)iterable);
            }
        } else {
            throw new NoSuchFileException(cryptoPath.toString());
        }
    }

    private void copyAttributes(Path path, Path path2) throws IOException {
        FileAttributeView fileAttributeView;
        Object object;
        Set<Class<? extends FileAttributeView>> set = this.fileStore.supportedFileAttributeViewTypes();
        if (set.contains(BasicFileAttributeView.class)) {
            object = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            fileAttributeView = Files.getFileAttributeView(path2, BasicFileAttributeView.class, new LinkOption[0]);
            fileAttributeView.setTimes(object.lastModifiedTime(), object.lastAccessTime(), object.creationTime());
        }
        if (set.contains(FileOwnerAttributeView.class)) {
            object = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
            fileAttributeView = Files.getFileAttributeView(path2, FileOwnerAttributeView.class, new LinkOption[0]);
            fileAttributeView.setOwner(object.getOwner());
        }
        if (set.contains(PosixFileAttributeView.class)) {
            object = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
            fileAttributeView = Files.getFileAttributeView(path2, PosixFileAttributeView.class, new LinkOption[0]);
            fileAttributeView.setGroup(object.group());
            fileAttributeView.setPermissions(object.permissions());
        }
        if (set.contains(DosFileAttributeView.class)) {
            object = Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]);
            fileAttributeView = Files.getFileAttributeView(path2, DosFileAttributeView.class, new LinkOption[0]);
            fileAttributeView.setArchive(object.isArchive());
            fileAttributeView.setHidden(object.isHidden());
            fileAttributeView.setReadOnly(object.isReadOnly());
            fileAttributeView.setSystem(object.isSystem());
        }
    }

    void move(CryptoPath cryptoPath, CryptoPath cryptoPath2, CopyOption ... copyOptionArray) throws IOException {
        if (cryptoPath.equals(cryptoPath2)) {
            return;
        }
        Path path = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.FILE);
        Path path2 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath, CryptoPathMapper.CiphertextFileType.DIRECTORY);
        if (Files.exists(path, new LinkOption[0])) {
            Path path3 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath2, CryptoPathMapper.CiphertextFileType.FILE);
            Files.move(path, path3, copyOptionArray);
        } else if (Files.exists(path2, new LinkOption[0])) {
            Path path4 = this.cryptoPathMapper.getCiphertextFilePath(cryptoPath2, CryptoPathMapper.CiphertextFileType.DIRECTORY);
            if (!ArrayUtils.contains(copyOptionArray, StandardCopyOption.REPLACE_EXISTING)) {
                Files.move(path2, path4, copyOptionArray);
            } else {
                if (ArrayUtils.contains(copyOptionArray, StandardCopyOption.ATOMIC_MOVE)) {
                    assert (ArrayUtils.contains(copyOptionArray, StandardCopyOption.REPLACE_EXISTING));
                    throw new AtomicMoveNotSupportedException(cryptoPath.toString(), cryptoPath2.toString(), "Replacing directories during move requires non-atomic status checks.");
                }
                assert (ArrayUtils.contains(copyOptionArray, StandardCopyOption.REPLACE_EXISTING));
                assert (!ArrayUtils.contains(copyOptionArray, StandardCopyOption.ATOMIC_MOVE));
                if (Files.exists(path4, new LinkOption[0])) {
                    Path path5 = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath2);
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path5);){
                        if (directoryStream.iterator().hasNext()) {
                            throw new DirectoryNotEmptyException(cryptoPath2.toString());
                        }
                    }
                    Files.delete(path5);
                }
                Files.move(path2, path4, copyOptionArray);
            }
            this.dirIdProvider.move(path2, path4);
        } else {
            throw new NoSuchFileException(cryptoPath.toString());
        }
    }

    CryptoFileStore getFileStore() {
        return this.fileStore;
    }

    CryptoPath getRootPath() {
        return this.rootPath;
    }

    CryptoPath getEmptyPath() {
        return this.emptyPath;
    }

    void assertOpen() {
        if (!this.open) {
            throw new ClosedFileSystemException();
        }
    }

    public String toString() {
        return String.format("%sCryptoFileSystem(%s)", this.open ? "" : "closed ", this.pathToVault);
    }
}

