/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.cryptomator.cryptofs.ChunkData;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.ExceptionsDuringWrite;
import org.cryptomator.cryptofs.OpenFileSize;
import org.cryptomator.cryptofs.PerOpenFile;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

@PerOpenFile
class ChunkSaver {
    private final Cryptor cryptor;
    private final FileChannel channel;
    private final FileHeader header;
    private final ExceptionsDuringWrite exceptionsDuringWrite;
    private final AtomicLong size;
    private final CryptoFileSystemStats stats;

    @Inject
    public ChunkSaver(Cryptor cryptor, FileChannel fileChannel, FileHeader fileHeader, ExceptionsDuringWrite exceptionsDuringWrite, @OpenFileSize AtomicLong atomicLong, CryptoFileSystemStats cryptoFileSystemStats) {
        this.cryptor = cryptor;
        this.channel = fileChannel;
        this.header = fileHeader;
        this.exceptionsDuringWrite = exceptionsDuringWrite;
        this.size = atomicLong;
        this.stats = cryptoFileSystemStats;
    }

    public void save(long l, ChunkData chunkData) {
        if (this.chunkLiesInFile(l) && chunkData.wasWritten()) {
            long l2 = l * (long)this.cryptor.fileContentCryptor().ciphertextChunkSize() + (long)this.cryptor.fileHeaderCryptor().headerSize();
            ByteBuffer byteBuffer = chunkData.asReadOnlyBuffer();
            this.stats.addBytesEncrypted(byteBuffer.remaining());
            ByteBuffer byteBuffer2 = this.cryptor.fileContentCryptor().encryptChunk(byteBuffer, l, this.header);
            try {
                this.channel.write(byteBuffer2, l2);
            }
            catch (IOException iOException) {
                this.exceptionsDuringWrite.add(iOException);
            }
        }
    }

    private boolean chunkLiesInFile(long l) {
        return l * (long)this.cryptor.fileContentCryptor().cleartextChunkSize() < this.size.get();
    }
}

