/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.cryptomator.cryptofs.ChunkData;
import org.cryptomator.cryptofs.ChunkLoader;
import org.cryptomator.cryptofs.ChunkSaver;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.PerOpenFile;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;

@PerOpenFile
class ChunkCache {
    public static final int MAX_CACHED_CLEARTEXT_CHUNKS = 5;
    private final CryptoFileSystemStats stats;
    private final LoadingCache<Long, ChunkData> chunks;

    @Inject
    public ChunkCache(final ChunkLoader chunkLoader, ChunkSaver chunkSaver, CryptoFileSystemStats cryptoFileSystemStats) {
        this.stats = cryptoFileSystemStats;
        this.chunks = CacheBuilder.newBuilder().maximumSize(5L).removalListener(removalNotification -> chunkSaver.save((Long)removalNotification.getKey(), (ChunkData)removalNotification.getValue())).build(new CacheLoader<Long, ChunkData>(){

            @Override
            public ChunkData load(Long l) throws IOException {
                return chunkLoader.load(l);
            }
        });
    }

    public ChunkData get(long l) throws IOException {
        try {
            this.stats.addChunkCacheAccess();
            return this.chunks.get(l);
        }
        catch (ExecutionException executionException) {
            assert (executionException.getCause() != null);
            throw (IOException)executionException.getCause();
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            if (uncheckedExecutionException.getCause() instanceof AuthenticationFailedException) {
                throw new IOException(uncheckedExecutionException.getCause());
            }
            throw uncheckedExecutionException;
        }
    }

    public void set(long l, ChunkData chunkData) {
        this.chunks.put(l, chunkData);
    }

    public void invalidateAll() {
        this.chunks.invalidateAll();
    }
}

