/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.TokenIterator;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.message.BasicTokenIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpResponse httpResponse, HttpContext httpContext) {
        int n;
        Object object;
        Object object2;
        Object object3;
        block19: {
            Object object4;
            Args.notNull(httpResponse, "HTTP response");
            Args.notNull(httpContext, "HTTP context");
            HttpRequest httpRequest = (HttpRequest)httpContext.getAttribute("http.request");
            if (httpRequest != null) {
                try {
                    object3 = new BasicTokenIterator(httpRequest.headerIterator("Connection"));
                    while (object3.hasNext()) {
                        object4 = object3.nextToken();
                        if (!"Close".equalsIgnoreCase((String)object4)) continue;
                        return false;
                    }
                }
                catch (ParseException parseException) {
                    return false;
                }
            }
            object3 = httpResponse.getStatusLine().getProtocolVersion();
            object4 = httpResponse.getFirstHeader("Transfer-Encoding");
            if (object4 != null) {
                if (!"chunked".equalsIgnoreCase(object4.getValue())) {
                    return false;
                }
            } else if (this.canResponseHaveBody(httpRequest, httpResponse)) {
                object2 = httpResponse.getHeaders("Content-Length");
                if (((Header[])object2).length == 1) {
                    object = object2[0];
                    try {
                        n = Integer.parseInt(object.getValue());
                        if (n < 0) {
                            return false;
                        }
                        break block19;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                }
                return false;
            }
        }
        if (!(object2 = httpResponse.headerIterator("Connection")).hasNext()) {
            object2 = httpResponse.headerIterator("Proxy-Connection");
        }
        if (object2.hasNext()) {
            try {
                object = new BasicTokenIterator((HeaderIterator)object2);
                n = 0;
                while (object.hasNext()) {
                    String string = object.nextToken();
                    if ("Close".equalsIgnoreCase(string)) {
                        return false;
                    }
                    if (!"Keep-Alive".equalsIgnoreCase(string)) continue;
                    n = 1;
                }
                if (n != 0) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return !((ProtocolVersion)object3).lessEquals(HttpVersion.HTTP_1_0);
    }

    protected TokenIterator createTokenIterator(HeaderIterator headerIterator) {
        return new BasicTokenIterator(headerIterator);
    }

    private boolean canResponseHaveBody(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpRequest != null && httpRequest.getRequestLine().getMethod().equalsIgnoreCase("HEAD")) {
            return false;
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        return n >= 200 && n != 204 && n != 304 && n != 205;
    }
}

