/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.Resource;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.message.HeaderGroup;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpCacheEntry
implements Serializable {
    private static final long serialVersionUID = -6300496422359477413L;
    private static final String REQUEST_METHOD_HEADER_NAME = "Hc-Request-Method";
    private final Date requestDate;
    private final Date responseDate;
    private final StatusLine statusLine;
    private final HeaderGroup responseHeaders;
    private final Resource resource;
    private final Map<String, String> variantMap;
    private final Date date;

    public HttpCacheEntry(Date date, Date date2, StatusLine statusLine, Header[] headerArray, Resource resource, Map<String, String> map, String string) {
        Args.notNull(date, "Request date");
        Args.notNull(date2, "Response date");
        Args.notNull(statusLine, "Status line");
        Args.notNull(headerArray, "Response headers");
        this.requestDate = date;
        this.responseDate = date2;
        this.statusLine = statusLine;
        this.responseHeaders = new HeaderGroup();
        this.responseHeaders.setHeaders(headerArray);
        this.resource = resource;
        this.variantMap = map != null ? new HashMap<String, String>(map) : null;
        this.date = this.parseDate();
    }

    public HttpCacheEntry(Date date, Date date2, StatusLine statusLine, Header[] headerArray, Resource resource, Map<String, String> map) {
        this(date, date2, statusLine, headerArray, resource, map, null);
    }

    public HttpCacheEntry(Date date, Date date2, StatusLine statusLine, Header[] headerArray, Resource resource) {
        this(date, date2, statusLine, headerArray, resource, new HashMap<String, String>());
    }

    public HttpCacheEntry(Date date, Date date2, StatusLine statusLine, Header[] headerArray, Resource resource, String string) {
        this(date, date2, statusLine, headerArray, resource, new HashMap<String, String>(), string);
    }

    private Date parseDate() {
        Header header = this.getFirstHeader("Date");
        if (header == null) {
            return null;
        }
        return DateUtils.parseDate(header.getValue());
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.statusLine.getProtocolVersion();
    }

    public String getReasonPhrase() {
        return this.statusLine.getReasonPhrase();
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public Date getResponseDate() {
        return this.responseDate;
    }

    public Header[] getAllHeaders() {
        HeaderGroup headerGroup = new HeaderGroup();
        HeaderIterator headerIterator = this.responseHeaders.iterator();
        while (headerIterator.hasNext()) {
            Header header = (Header)headerIterator.next();
            if (REQUEST_METHOD_HEADER_NAME.equals(header.getName())) continue;
            headerGroup.addHeader(header);
        }
        return headerGroup.getAllHeaders();
    }

    public Header getFirstHeader(String string) {
        if (REQUEST_METHOD_HEADER_NAME.equalsIgnoreCase(string)) {
            return null;
        }
        return this.responseHeaders.getFirstHeader(string);
    }

    public Header[] getHeaders(String string) {
        if (REQUEST_METHOD_HEADER_NAME.equalsIgnoreCase(string)) {
            return new Header[0];
        }
        return this.responseHeaders.getHeaders(string);
    }

    public Date getDate() {
        return this.date;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean hasVariants() {
        return this.getFirstHeader("Vary") != null;
    }

    public Map<String, String> getVariantMap() {
        return Collections.unmodifiableMap(this.variantMap);
    }

    public String getRequestMethod() {
        Header header = this.responseHeaders.getFirstHeader(REQUEST_METHOD_HEADER_NAME);
        if (header != null) {
            return header.getValue();
        }
        return "GET";
    }

    public String toString() {
        return "[request date=" + this.requestDate + "; response date=" + this.responseDate + "; statusLine=" + this.statusLine + "]";
    }
}

