/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    private final Writer out;
    private final File lockFile;
    static /* synthetic */ Class class$org$apache$commons$io$output$LockableFileWriter;

    public LockableFileWriter(String string) throws IOException {
        this(string, false, null);
    }

    public LockableFileWriter(String string, boolean bl) throws IOException {
        this(string, bl, null);
    }

    public LockableFileWriter(String string, boolean bl, String string2) throws IOException {
        this(new File(string), bl, string2);
    }

    public LockableFileWriter(File file) throws IOException {
        this(file, false, null);
    }

    public LockableFileWriter(File file, boolean bl) throws IOException {
        this(file, bl, null);
    }

    public LockableFileWriter(File file, boolean bl, String string) throws IOException {
        this(file, null, bl, string);
    }

    public LockableFileWriter(File file, String string) throws IOException {
        this(file, string, false, null);
    }

    public LockableFileWriter(File file, String string, boolean bl, String string2) throws IOException {
        file = file.getAbsoluteFile();
        if (file.getParentFile() != null) {
            FileUtils.forceMkdir(file.getParentFile());
        }
        if (file.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        if (string2 == null) {
            string2 = System.getProperty("java.io.tmpdir");
        }
        File file2 = new File(string2);
        FileUtils.forceMkdir(file2);
        this.testLockDir(file2);
        this.lockFile = new File(file2, file.getName() + LCK);
        this.createLock();
        this.out = this.initWriter(file, string, bl);
    }

    private void testLockDir(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("Could not find lockDir: " + file.getAbsolutePath());
        }
        if (!file.canWrite()) {
            throw new IOException("Could not write to lockDir: " + file.getAbsolutePath());
        }
    }

    private void createLock() throws IOException {
        Class clazz = class$org$apache$commons$io$output$LockableFileWriter == null ? (class$org$apache$commons$io$output$LockableFileWriter = LockableFileWriter.class$("org.apache.commons.io.output.LockableFileWriter")) : class$org$apache$commons$io$output$LockableFileWriter;
        synchronized (clazz) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
        }
    }

    private Writer initWriter(File file, String string, boolean bl) throws IOException {
        boolean bl2 = file.exists();
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            if (string == null) {
                outputStreamWriter = new FileWriter(file.getAbsolutePath(), bl);
            } else {
                fileOutputStream = new FileOutputStream(file.getAbsolutePath(), bl);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string);
            }
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(outputStreamWriter);
            IOUtils.closeQuietly(fileOutputStream);
            this.lockFile.delete();
            if (!bl2) {
                file.delete();
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly(outputStreamWriter);
            IOUtils.closeQuietly(fileOutputStream);
            this.lockFile.delete();
            if (!bl2) {
                file.delete();
            }
            throw runtimeException;
        }
        return outputStreamWriter;
    }

    public void close() throws IOException {
        try {
            this.out.close();
            Object var2_1 = null;
            this.lockFile.delete();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lockFile.delete();
            throw throwable;
        }
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void write(char[] cArray) throws IOException {
        this.out.write(cArray);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.out.write(cArray, n, n2);
    }

    public void write(String string) throws IOException {
        this.out.write(string);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.out.write(string, n, n2);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

