/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;

public final class IOCase
implements Serializable {
    public static final IOCase SENSITIVE = new IOCase("Sensitive", true);
    public static final IOCase INSENSITIVE = new IOCase("Insensitive", false);
    public static final IOCase SYSTEM = new IOCase("System", !FilenameUtils.isSystemWindows());
    private static final long serialVersionUID = -6343169151696340687L;
    private final String name;
    private final transient boolean sensitive;

    public static IOCase forName(String string) {
        if (IOCase.SENSITIVE.name.equals(string)) {
            return SENSITIVE;
        }
        if (IOCase.INSENSITIVE.name.equals(string)) {
            return INSENSITIVE;
        }
        if (IOCase.SYSTEM.name.equals(string)) {
            return SYSTEM;
        }
        throw new IllegalArgumentException("Invalid IOCase name: " + string);
    }

    private IOCase(String string, boolean bl) {
        this.name = string;
        this.sensitive = bl;
    }

    private Object readResolve() {
        return IOCase.forName(this.name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCaseSensitive() {
        return this.sensitive;
    }

    public boolean checkEquals(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        return this.sensitive ? string.equals(string2) : string.equalsIgnoreCase(string2);
    }

    public boolean checkStartsWith(String string, String string2) {
        return string.regionMatches(!this.sensitive, 0, string2, 0, string2.length());
    }

    public boolean checkEndsWith(String string, String string2) {
        int n = string2.length();
        return string.regionMatches(!this.sensitive, string.length() - n, string2, 0, n);
    }

    public boolean checkRegionMatches(String string, int n, String string2) {
        return string.regionMatches(!this.sensitive, n, string2, 0, string2.length());
    }

    String convertCase(String string) {
        if (string == null) {
            return null;
        }
        return this.sensitive ? string : string.toLowerCase();
    }

    public String toString() {
        return this.name;
    }
}

