/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.OutputStream;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final StringBuffer _lbuffer = new StringBuffer(8);
    private static final StringBuffer _cbuffer = new StringBuffer(2);
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    public static void dump(byte[] byArray, long l, OutputStream outputStream, int n) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + n + " into array of length " + byArray.length);
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long l2 = l + (long)n;
        StringBuffer stringBuffer = new StringBuffer(74);
        int n2 = n;
        while (n2 < byArray.length) {
            int n3 = byArray.length - n2;
            if (n3 > 16) {
                n3 = 16;
            }
            stringBuffer.append((Object)HexDump.dump(l2)).append(' ');
            int n4 = 0;
            while (n4 < 16) {
                if (n4 < n3) {
                    stringBuffer.append((Object)HexDump.dump(byArray[n4 + n2]));
                } else {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(' ');
                ++n4;
            }
            int n5 = 0;
            while (n5 < n3) {
                if (byArray[n5 + n2] >= 32 && byArray[n5 + n2] < 127) {
                    stringBuffer.append((char)byArray[n5 + n2]);
                } else {
                    stringBuffer.append('.');
                }
                ++n5;
            }
            stringBuffer.append(EOL);
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.flush();
            stringBuffer.setLength(0);
            l2 += (long)n3;
            n2 += 16;
        }
    }

    private static StringBuffer dump(long l) {
        _lbuffer.setLength(0);
        int n = 0;
        while (n < 8) {
            _lbuffer.append(_hexcodes[(int)(l >> _shifts[n]) & 0xF]);
            ++n;
        }
        return _lbuffer;
    }

    private static StringBuffer dump(byte by) {
        _cbuffer.setLength(0);
        int n = 0;
        while (n < 2) {
            _cbuffer.append(_hexcodes[by >> _shifts[n + 6] & 0xF]);
            ++n;
        }
        return _cbuffer;
    }
}

