/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;

public final class HmacUtils {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    public static Mac getHmacMd5(byte[] byArray) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_MD5, byArray);
    }

    public static Mac getHmacSha1(byte[] byArray) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_SHA_1, byArray);
    }

    public static Mac getHmacSha256(byte[] byArray) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_SHA_256, byArray);
    }

    public static Mac getHmacSha384(byte[] byArray) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_SHA_384, byArray);
    }

    public static Mac getHmacSha512(byte[] byArray) {
        return HmacUtils.getInitializedMac(HmacAlgorithms.HMAC_SHA_512, byArray);
    }

    public static Mac getInitializedMac(HmacAlgorithms hmacAlgorithms, byte[] byArray) {
        return HmacUtils.getInitializedMac(hmacAlgorithms.toString(), byArray);
    }

    public static Mac getInitializedMac(String string, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Null key");
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
            Mac mac = Mac.getInstance(string);
            mac.init(secretKeySpec);
            return mac;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    public static byte[] hmacMd5(byte[] byArray, byte[] byArray2) {
        try {
            return HmacUtils.getHmacMd5(byArray).doFinal(byArray2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static byte[] hmacMd5(byte[] byArray, InputStream inputStream) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacMd5(byArray), inputStream).doFinal();
    }

    public static byte[] hmacMd5(String string, String string2) {
        return HmacUtils.hmacMd5(StringUtils.getBytesUtf8(string), StringUtils.getBytesUtf8(string2));
    }

    public static String hmacMd5Hex(byte[] byArray, byte[] byArray2) {
        return Hex.encodeHexString(HmacUtils.hmacMd5(byArray, byArray2));
    }

    public static String hmacMd5Hex(byte[] byArray, InputStream inputStream) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacMd5(byArray, inputStream));
    }

    public static String hmacMd5Hex(String string, String string2) {
        return Hex.encodeHexString(HmacUtils.hmacMd5(string, string2));
    }

    public static byte[] hmacSha1(byte[] byArray, byte[] byArray2) {
        try {
            return HmacUtils.getHmacSha1(byArray).doFinal(byArray2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static byte[] hmacSha1(byte[] byArray, InputStream inputStream) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacSha1(byArray), inputStream).doFinal();
    }

    public static byte[] hmacSha1(String string, String string2) {
        return HmacUtils.hmacSha1(StringUtils.getBytesUtf8(string), StringUtils.getBytesUtf8(string2));
    }

    public static String hmacSha1Hex(byte[] byArray, byte[] byArray2) {
        return Hex.encodeHexString(HmacUtils.hmacSha1(byArray, byArray2));
    }

    public static String hmacSha1Hex(byte[] byArray, InputStream inputStream) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacSha1(byArray, inputStream));
    }

    public static String hmacSha1Hex(String string, String string2) {
        return Hex.encodeHexString(HmacUtils.hmacSha1(string, string2));
    }

    public static byte[] hmacSha256(byte[] byArray, byte[] byArray2) {
        try {
            return HmacUtils.getHmacSha256(byArray).doFinal(byArray2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static byte[] hmacSha256(byte[] byArray, InputStream inputStream) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacSha256(byArray), inputStream).doFinal();
    }

    public static byte[] hmacSha256(String string, String string2) {
        return HmacUtils.hmacSha256(StringUtils.getBytesUtf8(string), StringUtils.getBytesUtf8(string2));
    }

    public static String hmacSha256Hex(byte[] byArray, byte[] byArray2) {
        return Hex.encodeHexString(HmacUtils.hmacSha256(byArray, byArray2));
    }

    public static String hmacSha256Hex(byte[] byArray, InputStream inputStream) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacSha256(byArray, inputStream));
    }

    public static String hmacSha256Hex(String string, String string2) {
        return Hex.encodeHexString(HmacUtils.hmacSha256(string, string2));
    }

    public static byte[] hmacSha384(byte[] byArray, byte[] byArray2) {
        try {
            return HmacUtils.getHmacSha384(byArray).doFinal(byArray2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static byte[] hmacSha384(byte[] byArray, InputStream inputStream) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacSha384(byArray), inputStream).doFinal();
    }

    public static byte[] hmacSha384(String string, String string2) {
        return HmacUtils.hmacSha384(StringUtils.getBytesUtf8(string), StringUtils.getBytesUtf8(string2));
    }

    public static String hmacSha384Hex(byte[] byArray, byte[] byArray2) {
        return Hex.encodeHexString(HmacUtils.hmacSha384(byArray, byArray2));
    }

    public static String hmacSha384Hex(byte[] byArray, InputStream inputStream) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacSha384(byArray, inputStream));
    }

    public static String hmacSha384Hex(String string, String string2) {
        return Hex.encodeHexString(HmacUtils.hmacSha384(string, string2));
    }

    public static byte[] hmacSha512(byte[] byArray, byte[] byArray2) {
        try {
            return HmacUtils.getHmacSha512(byArray).doFinal(byArray2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static byte[] hmacSha512(byte[] byArray, InputStream inputStream) throws IOException {
        return HmacUtils.updateHmac(HmacUtils.getHmacSha512(byArray), inputStream).doFinal();
    }

    public static byte[] hmacSha512(String string, String string2) {
        return HmacUtils.hmacSha512(StringUtils.getBytesUtf8(string), StringUtils.getBytesUtf8(string2));
    }

    public static String hmacSha512Hex(byte[] byArray, byte[] byArray2) {
        return Hex.encodeHexString(HmacUtils.hmacSha512(byArray, byArray2));
    }

    public static String hmacSha512Hex(byte[] byArray, InputStream inputStream) throws IOException {
        return Hex.encodeHexString(HmacUtils.hmacSha512(byArray, inputStream));
    }

    public static String hmacSha512Hex(String string, String string2) {
        return Hex.encodeHexString(HmacUtils.hmacSha512(string, string2));
    }

    public static Mac updateHmac(Mac mac, byte[] byArray) {
        mac.reset();
        mac.update(byArray);
        return mac;
    }

    public static Mac updateHmac(Mac mac, InputStream inputStream) throws IOException {
        mac.reset();
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray, 0, 1024);
        while (n > -1) {
            mac.update(byArray, 0, n);
            n = inputStream.read(byArray, 0, 1024);
        }
        return mac;
    }

    public static Mac updateHmac(Mac mac, String string) {
        mac.reset();
        mac.update(StringUtils.getBytesUtf8(string));
        return mac;
    }
}

