/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.linux;

import de.dal33t.powerfolder.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import net.contentobjects.jnotify.IJNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import net.contentobjects.jnotify.Util;
import net.contentobjects.jnotify.linux.INotifyListener;
import net.contentobjects.jnotify.linux.JNotify_linux;

public class JNotifyAdapterLinux
implements IJNotify {
    private Hashtable<Integer, Integer> _linuxWd2Wd;
    private Hashtable<Integer, WatchData> _id2Data;
    private Hashtable<String, String> _autoWatchesPaths;
    private static int _watchIDCounter = 0;

    public JNotifyAdapterLinux() {
        JNotify_linux.setNotifyListener(new INotifyListener(){

            @Override
            public void notify(String string, int n, int n2, int n3) {
                try {
                    JNotifyAdapterLinux.this.notifyChangeEvent(string, n, n2, n3);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace(System.out);
                }
            }
        });
        this._id2Data = new Hashtable();
        this._linuxWd2Wd = new Hashtable();
        this._autoWatchesPaths = new Hashtable();
    }

    @Override
    public int addWatch(String string, int n, boolean bl, JNotifyListener jNotifyListener) throws JNotifyException {
        JNotify_linux.debug("JNotifyAdapterLinux.addWatch(path=" + string + ",mask=" + Util.getMaskDesc(n) + ", watchSubtree=" + bl + ")");
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 0x100;
        }
        if ((n & 2) != 0) {
            n2 |= 0x200;
            n2 |= 0x400;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
            n2 |= 2;
        }
        if ((n & 8) != 0) {
            n2 |= 0x40;
            n2 |= 0x80;
        }
        if (bl) {
            n2 |= 0x100;
        }
        WatchData watchData = this.createWatch(null, true, new File(string), n, n2, bl, jNotifyListener);
        if (bl) {
            try {
                File file = new File(string);
                this.registerToSubTree(true, watchData, file, false);
            }
            catch (JNotifyException jNotifyException) {
                this.removeWatch(watchData._wd);
                throw jNotifyException;
            }
        }
        return watchData._wd;
    }

    private WatchData createWatch(WatchData watchData, boolean bl, File file, int n, int n2, boolean bl2, JNotifyListener jNotifyListener) throws JNotifyException {
        String string = file.getPath();
        int n3 = _watchIDCounter++;
        int n4 = JNotify_linux.addWatch(string, n2);
        WatchData watchData2 = new WatchData(watchData, bl, string, n3, n4, n, n2, bl2, jNotifyListener);
        this._linuxWd2Wd.put(n4, n3);
        this._id2Data.put(n3, watchData2);
        if (!bl) {
            this._autoWatchesPaths.put(string, string);
        }
        return watchData2;
    }

    private void registerToSubTree(boolean bl, WatchData watchData, File file, boolean bl2) throws JNotifyException {
        Object object;
        if (!watchData._user) {
            throw new RuntimeException("!parentWatch._user");
        }
        if (bl2 && (watchData._mask & 1) != 0) {
            object = file.toString().substring(watchData._path.length() + 1);
            watchData.notifyFileCreated((String)object);
        }
        if (file.isDirectory()) {
            if (!bl) {
                try {
                    this.createWatch(watchData, false, file, watchData._mask, watchData._linuxMask, watchData._watchSubtree, watchData._listener);
                }
                catch (JNotifyException jNotifyException) {
                    if (jNotifyException.getErrorCode() == 2) {
                        JNotify_linux.warn("JNotifyAdapterLinux.registerToSubTree : warning, failed to register " + file + " :" + jNotifyException.getMessage());
                    }
                    throw jNotifyException;
                }
            }
            if ((object = file.list()) != null) {
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String string = object[i];
                    this.registerToSubTree(false, watchData, new File(file, string), bl2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWatch(int n) throws JNotifyException {
        JNotify_linux.debug("JNotifyAdapterLinux.removeWatch(" + n + ")");
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            if (this._id2Data.containsKey(n)) {
                WatchData watchData = this._id2Data.get(n);
                this.unwatch(watchData);
                return true;
            }
            return false;
        }
    }

    private void unwatch(WatchData watchData) throws JNotifyException {
        JNotifyException jNotifyException = null;
        boolean bl = true;
        try {
            JNotify_linux.removeWatch(watchData._linuxWd);
        }
        catch (JNotifyException jNotifyException2) {
            jNotifyException2.printStackTrace();
            jNotifyException = jNotifyException2;
            bl = false;
        }
        if (watchData._user) {
            for (int i = 0; i < watchData._subWd.size(); ++i) {
                int n = (Integer)watchData._subWd.get(i);
                try {
                    JNotify_linux.removeWatch(n);
                    continue;
                }
                catch (JNotifyException jNotifyException3) {
                    jNotifyException3.printStackTrace();
                    jNotifyException = jNotifyException3;
                    bl = false;
                }
            }
        }
        if (!bl) {
            throw jNotifyException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChangeEvent(String string, int n, int n2, int n3) {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            Integer n4 = this._linuxWd2Wd.get(n);
            if (n4 == null) {
                System.out.println("JNotifyAdapterLinux: warning, recieved event for an unregisted LinuxWD " + n + " ignoring...");
                return;
            }
            WatchData watchData = this._id2Data.get(n4);
            if (watchData != null) {
                if ((n2 & 0x100) != 0) {
                    File file;
                    block26: {
                        file = new File(watchData._path, string);
                        if (watchData._watchSubtree) {
                            try {
                                this.createWatch(watchData.getParentWatch(), false, file, watchData._mask, watchData._linuxMask, watchData._watchSubtree, watchData._listener);
                                WatchData watchData2 = watchData.getParentWatch();
                                this.registerToSubTree(true, watchData2, file, true);
                            }
                            catch (JNotifyException jNotifyException) {
                                if (jNotifyException.getErrorCode() == 4) break block26;
                                JNotify_linux.warn("registerToSubTree : warning, failed to register " + file + " :" + jNotifyException.getMessage() + " code = " + jNotifyException.getErrorCode());
                            }
                        }
                    }
                    if ((watchData._mask & 1) != 0) {
                        if (!this._autoWatchesPaths.contains(file.getPath())) {
                            watchData.notifyFileCreated(string);
                        } else {
                            JNotify_linux.debug("Assuming already sent event for " + file.getPath());
                        }
                    }
                } else if ((n2 & 0x400) != 0) {
                    watchData.notifyFileDeleted(string);
                } else if ((n2 & 0x200) != 0) {
                    watchData.notifyFileDeleted(string);
                } else if ((n2 & 4) != 0 || (n2 & 2) != 0) {
                    watchData.notifyFileModified(string);
                } else if ((n2 & 0x40) != 0) {
                    watchData.renaming(n3, string);
                } else if ((n2 & 0x80) != 0) {
                    watchData.notifyFileRenamed(string, n3);
                } else if ((n2 & 0x8000) != 0) {
                    this._linuxWd2Wd.remove(watchData._linuxWd);
                    this._id2Data.remove(watchData._wd);
                    if (!watchData._user) {
                        this._autoWatchesPaths.remove(watchData._path);
                        watchData.removeFromParent();
                    }
                }
            } else {
                System.out.println("JNotifyAdapterLinux: warning, recieved event for an unregisted WD " + n4 + ". ignoring...");
            }
        }
    }

    private void debugLinux(String string, int n, int n2, int n3) {
        Object object;
        int n4;
        WatchData watchData;
        boolean bl = (n2 & 1) != 0;
        boolean bl2 = (n2 & 2) != 0;
        boolean bl3 = (n2 & 4) != 0;
        boolean bl4 = (n2 & 8) != 0;
        boolean bl5 = (n2 & 0x10) != 0;
        boolean bl6 = (n2 & 0x20) != 0;
        boolean bl7 = (n2 & 0x40) != 0;
        boolean bl8 = (n2 & 0x80) != 0;
        boolean bl9 = (n2 & 0x100) != 0;
        boolean bl10 = (n2 & 0x200) != 0;
        boolean bl11 = (n2 & 0x400) != 0;
        boolean bl12 = (n2 & 0x800) != 0;
        boolean bl13 = (n2 & 0x2000) != 0;
        boolean bl14 = (n2 & 0x4000) != 0;
        boolean bl15 = (n2 & 0x8000) != 0;
        Object object2 = "";
        if (bl) {
            object2 = (String)object2 + "IN_ACCESS, ";
        }
        if (bl2) {
            object2 = (String)object2 + "IN_MODIFY, ";
        }
        if (bl3) {
            object2 = (String)object2 + "IN_ATTRIB, ";
        }
        if (bl4) {
            object2 = (String)object2 + "IN_CLOSE_WRITE, ";
        }
        if (bl5) {
            object2 = (String)object2 + "IN_CLOSE_NOWRITE, ";
        }
        if (bl6) {
            object2 = (String)object2 + "IN_OPEN, ";
        }
        if (bl7) {
            object2 = (String)object2 + "IN_MOVED_FROM, ";
        }
        if (bl8) {
            object2 = (String)object2 + "IN_MOVED_TO, ";
        }
        if (bl9) {
            object2 = (String)object2 + "IN_CREATE, ";
        }
        if (bl10) {
            object2 = (String)object2 + "IN_DELETE, ";
        }
        if (bl11) {
            object2 = (String)object2 + "IN_DELETE_SELF, ";
        }
        if (bl12) {
            object2 = (String)object2 + "IN_MOVE_SELF, ";
        }
        if (bl13) {
            object2 = (String)object2 + "IN_UNMOUNT, ";
        }
        if (bl14) {
            object2 = (String)object2 + "IN_Q_OVERFLOW, ";
        }
        if (bl15) {
            object2 = (String)object2 + "IN_IGNORED, ";
        }
        if ((watchData = this._id2Data.get(n4 = this._linuxWd2Wd.get(n).intValue())) != null) {
            object = watchData._path;
            if (object != null && string != "") {
                object = (String)object + File.separator + string;
            }
        } else {
            object = string;
        }
        JNotify_linux.debug("Linux event : wd=" + n + " | " + (String)object2 + " path: " + (String)object + (String)(n3 != 0 ? ", cookie=" + n3 : ""));
    }

    public int unitTest_getNumWatches() {
        return this._id2Data.size();
    }

    private static class WatchData {
        boolean _user;
        int _wd;
        private int _linuxWd;
        private ArrayList<Integer> _subWd;
        int _mask;
        int _linuxMask;
        boolean _watchSubtree;
        JNotifyListener _listener;
        static Hashtable<Integer, String> _cookieToOldName = new Hashtable();
        String _path;
        WatchData _parentWatchData;

        WatchData(WatchData watchData, boolean bl, String string, int n, int n2, int n3, int n4, boolean bl2, JNotifyListener jNotifyListener) {
            if (jNotifyListener == null) {
                throw new IllegalArgumentException("Null listener");
            }
            this._parentWatchData = watchData;
            this._user = bl;
            this._subWd = new ArrayList();
            this._path = string;
            this._wd = n;
            this._linuxMask = n4;
            this._linuxWd = n2;
            this._mask = n3;
            this._watchSubtree = bl2;
            this._listener = jNotifyListener;
            if (watchData != null) {
                watchData.addSubwatch(this._linuxWd);
            }
        }

        public WatchData getParentWatch() {
            return this._user ? this : this._parentWatchData;
        }

        public void removeFromParent() {
            if (this._parentWatchData == null) {
                throw new RuntimeException("no parent");
            }
            this._parentWatchData.remveSubwatch(this._linuxWd);
        }

        public void renaming(int n, String string) {
            _cookieToOldName.put(n, this.getOutName(string));
        }

        public void notifyFileRenamed(String string, int n) {
            String string2 = _cookieToOldName.remove(n);
            String string3 = this.getOutRoot();
            String string4 = this.getOutName(string);
            if (StringUtils.isNotBlank(string2) && StringUtils.isNotBlank(string3) && StringUtils.isNotBlank(string4)) {
                this._listener.fileRenamed(this.getParentWatchID(), string3, string2, string4);
            }
        }

        public void notifyFileModified(String string) {
            String string2 = this.getOutRoot();
            String string3 = this.getOutName(string);
            this._listener.fileModified(this.getParentWatchID(), string2, string3);
        }

        public void notifyFileDeleted(String string) {
            String string2 = this.getOutRoot();
            String string3 = this.getOutName(string);
            this._listener.fileDeleted(this.getParentWatchID(), string2, string3);
        }

        public void notifyFileCreated(String string) {
            String string2 = this.getOutRoot();
            String string3 = this.getOutName(string);
            this._listener.fileCreated(this.getParentWatchID(), string2, string3);
        }

        void remveSubwatch(int n) {
            if (!this._subWd.remove((Object)n)) {
                throw new RuntimeException("Error removing " + n + " from list");
            }
        }

        void addSubwatch(int n) {
            this._subWd.add(n);
        }

        public String toString() {
            return "WatchData " + this._path + ", wd=" + this._wd + ", linuxWd=" + this._linuxWd + (this._watchSubtree ? ", recursive" : "") + (this._user ? ", user" : ", auto");
        }

        private String getOutRoot() {
            String string = this._user ? this._path : this.getParentWatch()._path;
            return string;
        }

        private String getOutName(String string) {
            Object object;
            if (this._user) {
                object = string;
            } else {
                object = this._path.substring(this.getParentWatch()._path.length() + 1);
                if (string != "") {
                    object = (String)object + File.separatorChar + string;
                }
            }
            return object;
        }

        public int getParentWatchID() {
            return this._parentWatchData == null ? this._wd : this._parentWatchData._wd;
        }
    }
}

