/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.BaseLinkedQueue;
import io.netty.util.internal.shaded.org.jctools.queues.LinkedQueueNode;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;

public class SpscLinkedQueue<E>
extends BaseLinkedQueue<E> {
    public SpscLinkedQueue() {
        this.spProducerNode(new LinkedQueueNode());
        this.spConsumerNode(this.producerNode);
        this.consumerNode.soNext(null);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        LinkedQueueNode<E> linkedQueueNode = new LinkedQueueNode<E>(e);
        LinkedQueueNode<E> linkedQueueNode2 = this.lpProducerNode();
        linkedQueueNode2.soNext(linkedQueueNode);
        this.spProducerNode(linkedQueueNode);
        return true;
    }

    @Override
    public E poll() {
        return (E)this.relaxedPoll();
    }

    @Override
    public E peek() {
        return (E)this.relaxedPeek();
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        long l = 0L;
        do {
            this.fill(supplier, 4096);
        } while ((l += 4096L) <= 0x7FFFEFFFL);
        return (int)l;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        LinkedQueueNode<E> linkedQueueNode;
        if (n == 0) {
            return 0;
        }
        LinkedQueueNode<E> linkedQueueNode2 = linkedQueueNode = new LinkedQueueNode<E>(supplier.get());
        for (int i = 1; i < n; ++i) {
            LinkedQueueNode<E> linkedQueueNode3 = new LinkedQueueNode<E>(supplier.get());
            linkedQueueNode.soNext(linkedQueueNode3);
            linkedQueueNode = linkedQueueNode3;
        }
        LinkedQueueNode<E> linkedQueueNode4 = this.lpProducerNode();
        linkedQueueNode4.soNext(linkedQueueNode2);
        this.spProducerNode(linkedQueueNode);
        return n;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        LinkedQueueNode<E> linkedQueueNode = this.producerNode;
        while (exitCondition.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                LinkedQueueNode<E> linkedQueueNode2 = new LinkedQueueNode<E>(supplier.get());
                linkedQueueNode.soNext(linkedQueueNode2);
                this.producerNode = linkedQueueNode = linkedQueueNode2;
            }
        }
    }
}

