/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueueConsumerField;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.util.JvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class MpmcArrayQueue<E>
extends MpmcArrayQueueConsumerField<E>
implements QueueProgressIndicators {
    long p01;
    long p02;
    long p03;
    long p04;
    long p05;
    long p06;
    long p07;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;
    static final int RECOMENDED_POLL_BATCH = JvmInfo.CPUs * 4;
    static final int RECOMENDED_OFFER_BATCH = JvmInfo.CPUs * 4;

    public MpmcArrayQueue(int n) {
        super(MpmcArrayQueue.validateCapacity(n));
    }

    private static int validateCapacity(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("Minimum size is 2");
        }
        return n;
    }

    @Override
    public boolean offer(E e) {
        long l;
        long l2;
        long l3;
        if (null == e) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long l5 = l4 + 1L;
        long[] lArray = this.sequenceBuffer;
        long l6 = Long.MAX_VALUE;
        do {
            if ((l3 = this.lvSequence(lArray, l = MpmcArrayQueue.calcSequenceOffset(l2 = this.lvProducerIndex(), l4))) >= l2) continue;
            if (l2 - l5 <= l6 && l2 - l5 <= (l6 = this.lvConsumerIndex())) {
                return false;
            }
            l3 = l2 + 1L;
        } while (l3 > l2 || !this.casProducerIndex(l2, l2 + 1L));
        assert (null == UnsafeRefArrayAccess.lpElement(this.buffer, MpmcArrayQueue.calcElementOffset(l2, l4)));
        UnsafeRefArrayAccess.soElement(this.buffer, MpmcArrayQueue.calcElementOffset(l2, l4), e);
        this.soSequence(lArray, l, l2 + 1L);
        return true;
    }

    @Override
    public E poll() {
        long l;
        long l2;
        long l3;
        long l4;
        long[] lArray = this.sequenceBuffer;
        long l5 = this.mask;
        long l6 = -1L;
        do {
            if ((l4 = this.lvSequence(lArray, l = MpmcArrayQueue.calcSequenceOffset(l2 = this.lvConsumerIndex(), l5))) >= (l3 = l2 + 1L)) continue;
            if (l2 >= l6 && l2 == (l6 = this.lvProducerIndex())) {
                return null;
            }
            l4 = l3 + 1L;
        } while (l4 > l3 || !this.casConsumerIndex(l2, l2 + 1L));
        long l7 = MpmcArrayQueue.calcElementOffset(l2, l5);
        Object object = UnsafeRefArrayAccess.lpElement(this.buffer, l7);
        assert (object != null);
        UnsafeRefArrayAccess.soElement(this.buffer, l7, null);
        this.soSequence(lArray, l, l2 + l5 + 1L);
        return (E)object;
    }

    @Override
    public E peek() {
        long l;
        Object object;
        while ((object = UnsafeRefArrayAccess.lpElement(this.buffer, this.calcElementOffset(l = this.lvConsumerIndex()))) == null && l != this.lvProducerIndex()) {
        }
        return (E)object;
    }

    @Override
    public int size() {
        long l;
        long l2;
        long l3 = this.lvConsumerIndex();
        do {
            l2 = l3;
            l = this.lvProducerIndex();
        } while (l2 != (l3 = this.lvConsumerIndex()));
        return (int)(l - l3);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    @Override
    public boolean relaxedOffer(E e) {
        long l;
        long l2;
        long l3;
        if (null == e) {
            throw new NullPointerException();
        }
        long l4 = this.mask;
        long[] lArray = this.sequenceBuffer;
        do {
            if ((l3 = this.lvSequence(lArray, l = MpmcArrayQueue.calcSequenceOffset(l2 = this.lvProducerIndex(), l4))) >= l2) continue;
            return false;
        } while (l3 > l2 || !this.casProducerIndex(l2, l2 + 1L));
        UnsafeRefArrayAccess.soElement(this.buffer, MpmcArrayQueue.calcElementOffset(l2, l4), e);
        this.soSequence(lArray, l, l2 + 1L);
        return true;
    }

    @Override
    public E relaxedPoll() {
        long l;
        long l2;
        long l3;
        long l4;
        long[] lArray = this.sequenceBuffer;
        long l5 = this.mask;
        do {
            if ((l4 = this.lvSequence(lArray, l = MpmcArrayQueue.calcSequenceOffset(l2 = this.lvConsumerIndex(), l5))) >= (l3 = l2 + 1L)) continue;
            return null;
        } while (l4 > l3 || !this.casConsumerIndex(l2, l2 + 1L));
        long l6 = MpmcArrayQueue.calcElementOffset(l2, l5);
        Object object = UnsafeRefArrayAccess.lpElement(this.buffer, l6);
        UnsafeRefArrayAccess.soElement(this.buffer, l6, null);
        this.soSequence(lArray, l, l2 + l5 + 1L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        long l = this.lvConsumerIndex();
        return (E)UnsafeRefArrayAccess.lpElement(this.buffer, this.calcElementOffset(l));
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        int n;
        int n2;
        int n3 = this.capacity();
        for (n = 0; n < n3; n += n2) {
            n2 = 0;
            n2 = this.drain(consumer, RECOMENDED_POLL_BATCH);
            if (n2 == 0) break;
        }
        return n;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        int n;
        long l = 0L;
        int n2 = this.capacity();
        do {
            if ((n = this.fill(supplier, RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l;
        } while ((l += (long)n) <= (long)n2);
        return (int)l;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        Object[] objectArray = this.buffer;
        for (int i = 0; i < n; ++i) {
            long l2;
            long l3;
            long l4;
            long l5;
            do {
                if ((l5 = this.lvSequence(lArray, l2 = MpmcArrayQueue.calcSequenceOffset(l3 = this.lvConsumerIndex(), l))) >= (l4 = l3 + 1L)) continue;
                return i;
            } while (l5 > l4 || !this.casConsumerIndex(l3, l3 + 1L));
            long l6 = MpmcArrayQueue.calcElementOffset(l3, l);
            Object object = UnsafeRefArrayAccess.lpElement(objectArray, l6);
            UnsafeRefArrayAccess.soElement(objectArray, l6, null);
            this.soSequence(lArray, l2, l3 + l + 1L);
            consumer.accept(object);
        }
        return n;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        Object[] objectArray = this.buffer;
        for (int i = 0; i < n; ++i) {
            long l2;
            long l3;
            long l4;
            do {
                if ((l4 = this.lvSequence(lArray, l2 = MpmcArrayQueue.calcSequenceOffset(l3 = this.lvProducerIndex(), l))) >= l3) continue;
                return i;
            } while (l4 > l3 || !this.casProducerIndex(l3, l3 + 1L));
            UnsafeRefArrayAccess.soElement(objectArray, MpmcArrayQueue.calcElementOffset(l3, l), supplier.get());
            this.soSequence(lArray, l2, l3 + 1L);
        }
        return n;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        int n = 0;
        while (exitCondition.keepRunning()) {
            if (this.drain(consumer, RECOMENDED_POLL_BATCH) == 0) {
                n = waitStrategy.idle(n);
                continue;
            }
            n = 0;
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        int n = 0;
        while (exitCondition.keepRunning()) {
            if (this.fill(supplier, RECOMENDED_OFFER_BATCH) == 0) {
                n = waitStrategy.idle(n);
                continue;
            }
            n = 0;
        }
    }
}

