/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.ConstantTimeUtils;
import io.netty.util.internal.JavassistTypeParameterMatcherGenerator;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.OutOfDirectMemoryError;
import io.netty.util.internal.PlatformDependent0;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.chmv8.ConcurrentHashMapV8;
import io.netty.util.internal.chmv8.LongAdderV8;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.SpscLinkedQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscLinkedAtomicQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.SpscLinkedAtomicQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PlatformDependent {
    private static final InternalLogger logger;
    private static final Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN;
    private static final boolean IS_ANDROID;
    private static final boolean IS_WINDOWS;
    private static volatile Boolean IS_ROOT;
    private static final int JAVA_VERSION;
    private static final boolean CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    private static final boolean HAS_UNSAFE;
    private static final boolean CAN_USE_CHM_V8;
    private static final boolean DIRECT_BUFFER_PREFERRED;
    private static final long MAX_DIRECT_MEMORY;
    private static final int MPSC_CHUNK_SIZE = 1024;
    private static final int MIN_MAX_MPSC_CAPACITY = 2048;
    private static final int DEFAULT_MAX_MPSC_CAPACITY = 0x100000;
    private static final int MAX_ALLOWED_MPSC_CAPACITY = 0x40000000;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final boolean HAS_JAVASSIST;
    private static final File TMPDIR;
    private static final int BIT_MODE;
    private static final int ADDRESS_SIZE;
    private static final boolean USE_DIRECT_BUFFER_NO_CLEANER;
    private static final AtomicLong DIRECT_MEMORY_COUNTER;
    private static final long DIRECT_MEMORY_LIMIT;
    public static final boolean BIG_ENDIAN_NATIVE_ORDER;

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isRoot() {
        if (IS_ROOT != null) return IS_ROOT;
        Class<PlatformDependent> clazz = PlatformDependent.class;
        synchronized (PlatformDependent.class) {
            if (IS_ROOT != null) return IS_ROOT;
            IS_ROOT = PlatformDependent.isRoot0();
            // ** MonitorExit[var0] (shouldn't be in output)
            return IS_ROOT;
        }
    }

    public static int javaVersion() {
        return JAVA_VERSION;
    }

    public static boolean canEnableTcpNoDelayByDefault() {
        return CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    }

    public static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    public static boolean isUnaligned() {
        return PlatformDependent0.isUnaligned();
    }

    public static boolean directBufferPreferred() {
        return DIRECT_BUFFER_PREFERRED;
    }

    public static long maxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }

    public static boolean hasJavassist() {
        return HAS_JAVASSIST;
    }

    public static File tmpdir() {
        return TMPDIR;
    }

    public static int bitMode() {
        return BIT_MODE;
    }

    public static int addressSize() {
        return ADDRESS_SIZE;
    }

    public static long allocateMemory(long l) {
        return PlatformDependent0.allocateMemory(l);
    }

    public static void freeMemory(long l) {
        PlatformDependent0.freeMemory(l);
    }

    public static void throwException(Throwable throwable) {
        if (PlatformDependent.hasUnsafe()) {
            PlatformDependent0.throwException(throwable);
        } else {
            PlatformDependent.throwException0(throwable);
        }
    }

    private static <E extends Throwable> void throwException0(Throwable throwable) throws E {
        throw throwable;
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap() {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8();
        }
        return new ConcurrentHashMap();
    }

    public static LongCounter newLongCounter() {
        if (HAS_UNSAFE) {
            return new LongAdderV8();
        }
        return new AtomicLongCounter();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n) {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8(n);
        }
        return new ConcurrentHashMap(n);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n, float f) {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8(n, f);
        }
        return new ConcurrentHashMap(n, f);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n, float f, int n2) {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8(n, f, n2);
        }
        return new ConcurrentHashMap(n, f, n2);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> map) {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8<K, V>(map);
        }
        return new ConcurrentHashMap<K, V>(map);
    }

    public static void freeDirectBuffer(ByteBuffer byteBuffer) {
        if (PlatformDependent.hasUnsafe() && !PlatformDependent.isAndroid()) {
            PlatformDependent0.freeDirectBuffer(byteBuffer);
        }
    }

    public static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.directBufferAddress(byteBuffer);
    }

    public static Object getObject(Object object, long l) {
        return PlatformDependent0.getObject(object, l);
    }

    public static Object getObjectVolatile(Object object, long l) {
        return PlatformDependent0.getObjectVolatile(object, l);
    }

    public static int getInt(Object object, long l) {
        return PlatformDependent0.getInt(object, l);
    }

    public static long objectFieldOffset(Field field) {
        return PlatformDependent0.objectFieldOffset(field);
    }

    public static byte getByte(long l) {
        return PlatformDependent0.getByte(l);
    }

    public static short getShort(long l) {
        return PlatformDependent0.getShort(l);
    }

    public static int getInt(long l) {
        return PlatformDependent0.getInt(l);
    }

    public static long getLong(long l) {
        return PlatformDependent0.getLong(l);
    }

    public static byte getByte(byte[] byArray, int n) {
        return PlatformDependent0.getByte(byArray, n);
    }

    public static short getShort(byte[] byArray, int n) {
        return PlatformDependent0.getShort(byArray, n);
    }

    public static int getInt(byte[] byArray, int n) {
        return PlatformDependent0.getInt(byArray, n);
    }

    public static long getLong(byte[] byArray, int n) {
        return PlatformDependent0.getLong(byArray, n);
    }

    private static long getLongSafe(byte[] byArray, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (long)byArray[n] << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
        }
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    private static int getIntSafe(byte[] byArray, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    private static short getShortSafe(byte[] byArray, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (short)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
        }
        return (short)(byArray[n] & 0xFF | byArray[n + 1] << 8);
    }

    private static int hashCodeAsciiCompute(CharSequence charSequence, int n, int n2) {
        return n2 * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n + 4);
    }

    private static int hashCodeAsciiSanitizeInt(CharSequence charSequence, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return charSequence.charAt(n) & 0x1F | (charSequence.charAt(n + 2) & 0x1F) << 8 | (charSequence.charAt(n + 1) & 0x1F) << 16 | (charSequence.charAt(n) & 0x1F) << 24;
        }
        return (charSequence.charAt(n + 3) & 0x1F) << 24 | (charSequence.charAt(n + 2) & 0x1F) << 16 | (charSequence.charAt(n + 1) & 0x1F) << 8 | charSequence.charAt(n) & 0x1F;
    }

    private static int hashCodeAsciiSanitizeShort(CharSequence charSequence, int n) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return charSequence.charAt(n + 1) & 0x1F | (charSequence.charAt(n) & 0x1F) << 8;
        }
        return (charSequence.charAt(n + 1) & 0x1F) << 8 | charSequence.charAt(n) & 0x1F;
    }

    private static int hashCodeAsciiSanitizsByte(char c) {
        return c & 0x1F;
    }

    public static void putOrderedObject(Object object, long l, Object object2) {
        PlatformDependent0.putOrderedObject(object, l, object2);
    }

    public static void putByte(long l, byte by) {
        PlatformDependent0.putByte(l, by);
    }

    public static void putShort(long l, short s) {
        PlatformDependent0.putShort(l, s);
    }

    public static void putInt(long l, int n) {
        PlatformDependent0.putInt(l, n);
    }

    public static void putLong(long l, long l2) {
        PlatformDependent0.putLong(l, l2);
    }

    public static void putByte(byte[] byArray, int n, byte by) {
        PlatformDependent0.putByte(byArray, n, by);
    }

    public static void putShort(byte[] byArray, int n, short s) {
        PlatformDependent0.putShort(byArray, n, s);
    }

    public static void putInt(byte[] byArray, int n, int n2) {
        PlatformDependent0.putInt(byArray, n, n2);
    }

    public static void putLong(byte[] byArray, int n, long l) {
        PlatformDependent0.putLong(byArray, n, l);
    }

    public static void copyMemory(long l, long l2, long l3) {
        PlatformDependent0.copyMemory(l, l2, l3);
    }

    public static void copyMemory(byte[] byArray, int n, long l, long l2) {
        PlatformDependent0.copyMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, null, l, l2);
    }

    public static void copyMemory(long l, byte[] byArray, int n, long l2) {
        PlatformDependent0.copyMemory(null, l, byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, l2);
    }

    public static void setMemory(byte[] byArray, int n, long l, byte by) {
        PlatformDependent0.setMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n, l, by);
    }

    public static void setMemory(long l, long l2, byte by) {
        PlatformDependent0.setMemory(l, l2, by);
    }

    public static ByteBuffer allocateDirectNoCleaner(int n) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        PlatformDependent.incrementMemoryCounter(n);
        try {
            return PlatformDependent0.allocateDirectNoCleaner(n);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n2 = n - byteBuffer.capacity();
        PlatformDependent.incrementMemoryCounter(n2);
        try {
            return PlatformDependent0.reallocateDirectNoCleaner(byteBuffer, n);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n2);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static void freeDirectNoCleaner(ByteBuffer byteBuffer) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n = byteBuffer.capacity();
        PlatformDependent0.freeMemory(PlatformDependent0.directBufferAddress(byteBuffer));
        PlatformDependent.decrementMemoryCounter(n);
    }

    private static void incrementMemoryCounter(int n) {
        block1: {
            long l;
            long l2;
            if (DIRECT_MEMORY_COUNTER == null) break block1;
            do {
                if ((l = (l2 = DIRECT_MEMORY_COUNTER.get()) + (long)n) <= DIRECT_MEMORY_LIMIT) continue;
                throw new OutOfDirectMemoryError("failed to allocate " + n + " byte(s) of direct memory (used: " + l2 + ", max: " + DIRECT_MEMORY_LIMIT + ')');
            } while (!DIRECT_MEMORY_COUNTER.compareAndSet(l2, l));
        }
    }

    private static void decrementMemoryCounter(int n) {
        if (DIRECT_MEMORY_COUNTER != null) {
            long l = DIRECT_MEMORY_COUNTER.addAndGet(-n);
            assert (l >= 0L);
        }
    }

    public static boolean useDirectBufferNoCleaner() {
        return USE_DIRECT_BUFFER_NO_CLEANER;
    }

    public static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.equalsSafe(byArray, n, byArray2, n2, n3) : PlatformDependent0.equals(byArray, n, byArray2, n2, n3);
    }

    public static int equalsConstantTime(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? ConstantTimeUtils.equalsConstantTime(byArray, n, byArray2, n2, n3) : PlatformDependent0.equalsConstantTime(byArray, n, byArray2, n2, n3);
    }

    public static int hashCodeAscii(byte[] byArray, int n, int n2) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.hashCodeAsciiSafe(byArray, n, n2) : PlatformDependent0.hashCodeAscii(byArray, n, n2);
    }

    public static int hashCodeAscii(CharSequence charSequence) {
        int n = -1028477387;
        int n2 = charSequence.length() & 7;
        switch (charSequence.length()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n = PlatformDependent.hashCodeAsciiCompute(charSequence, charSequence.length() - 24, PlatformDependent.hashCodeAsciiCompute(charSequence, charSequence.length() - 16, PlatformDependent.hashCodeAsciiCompute(charSequence, charSequence.length() - 8, n)));
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n = PlatformDependent.hashCodeAsciiCompute(charSequence, charSequence.length() - 16, PlatformDependent.hashCodeAsciiCompute(charSequence, charSequence.length() - 8, n));
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n = PlatformDependent.hashCodeAsciiCompute(charSequence, charSequence.length() - 8, n);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                for (int i = charSequence.length() - 8; i >= n2; i -= 8) {
                    n = PlatformDependent.hashCodeAsciiCompute(charSequence, i, n);
                }
            }
        }
        switch (n2) {
            case 7: {
                return ((n * 461845907 + PlatformDependent.hashCodeAsciiSanitizsByte(charSequence.charAt(0))) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeShort(charSequence, 1)) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, 3);
            }
            case 6: {
                return (n * 461845907 + PlatformDependent.hashCodeAsciiSanitizeShort(charSequence, 0)) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, 2);
            }
            case 5: {
                return (n * 461845907 + PlatformDependent.hashCodeAsciiSanitizsByte(charSequence.charAt(0))) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, 1);
            }
            case 4: {
                return n * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, 0);
            }
            case 3: {
                return (n * 461845907 + PlatformDependent.hashCodeAsciiSanitizsByte(charSequence.charAt(0))) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeShort(charSequence, 1);
            }
            case 2: {
                return n * 461845907 + PlatformDependent.hashCodeAsciiSanitizeShort(charSequence, 0);
            }
            case 1: {
                return n * 461845907 + PlatformDependent.hashCodeAsciiSanitizsByte(charSequence.charAt(0));
            }
        }
        return n;
    }

    public static <U, W> AtomicReferenceFieldUpdater<U, W> newAtomicReferenceFieldUpdater(Class<? super U> clazz, String string) {
        if (PlatformDependent.hasUnsafe()) {
            try {
                return PlatformDependent0.newAtomicReferenceFieldUpdater(clazz, string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> AtomicIntegerFieldUpdater<T> newAtomicIntegerFieldUpdater(Class<? super T> clazz, String string) {
        if (PlatformDependent.hasUnsafe()) {
            try {
                return PlatformDependent0.newAtomicIntegerFieldUpdater(clazz, string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> AtomicLongFieldUpdater<T> newAtomicLongFieldUpdater(Class<? super T> clazz, String string) {
        if (PlatformDependent.hasUnsafe()) {
            try {
                return PlatformDependent0.newAtomicLongFieldUpdater(clazz, string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> Queue<T> newMpscQueue() {
        return PlatformDependent.newMpscQueue(0x100000);
    }

    public static <T> Queue<T> newMpscQueue(int n) {
        return PlatformDependent.hasUnsafe() ? new MpscChunkedArrayQueue(1024, Math.max(Math.min(n, 0x40000000), 2048), true) : new MpscLinkedAtomicQueue();
    }

    public static <T> Queue<T> newSpscQueue() {
        return PlatformDependent.hasUnsafe() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue();
    }

    public static <T> Queue<T> newFixedMpscQueue(int n) {
        return PlatformDependent.hasUnsafe() ? new MpscArrayQueue(n) : new MpscAtomicArrayQueue(n);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        return PlatformDependent0.getClassLoader(clazz);
    }

    public static ClassLoader getContextClassLoader() {
        return PlatformDependent0.getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return PlatformDependent0.getSystemClassLoader();
    }

    public static <C> Deque<C> newConcurrentDeque() {
        if (PlatformDependent.javaVersion() < 7) {
            return new LinkedBlockingDeque();
        }
        return new ConcurrentLinkedDeque();
    }

    private static boolean isAndroid0() {
        boolean bl;
        try {
            Class.forName("android.app.Application", false, PlatformDependent.getSystemClassLoader());
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (bl) {
            logger.debug("Platform: Android");
        }
        return bl;
    }

    private static boolean isWindows0() {
        boolean bl = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("win");
        if (bl) {
            logger.debug("Platform: Windows");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRoot0() {
        Object object;
        if (PlatformDependent.isWindows()) {
            return false;
        }
        String[] stringArray = new String[]{"/usr/bin/id", "/bin/id", "/usr/xpg4/bin/id", "id"};
        Pattern pattern = Pattern.compile("^(?:0|[1-9][0-9]*)$");
        for (String string : stringArray) {
            object = null;
            BufferedReader bufferedReader = null;
            String string2 = null;
            try {
                object = Runtime.getRuntime().exec(new String[]{string, "-u"});
                bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream(), CharsetUtil.US_ASCII));
                string2 = bufferedReader.readLine();
                bufferedReader.close();
                while (true) {
                    try {
                        int n = ((Process)object).waitFor();
                        if (n != 0) {
                            string2 = null;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                string2 = null;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (object != null) {
                    try {
                        ((Process)object).destroy();
                    }
                    catch (Exception exception) {}
                }
            }
            if (string2 == null || !pattern.matcher(string2).matches()) continue;
            logger.debug("UID: {}", (Object)string2);
            return "0".equals(string2);
        }
        logger.debug("Could not determine the current UID using /usr/bin/id; attempting to bind at privileged ports.");
        Pattern pattern2 = Pattern.compile(".*(?:denied|not.*permitted).*");
        for (int i = 1023; i > 0; --i) {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket();
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress(i));
                if (logger.isDebugEnabled()) {
                    logger.debug("UID: 0 (succeded to bind at port {})", (Object)i);
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                object = exception.getMessage();
                if (object == null) {
                    object = "";
                }
                if (!pattern2.matcher((CharSequence)(object = ((String)object).toLowerCase())).matches()) continue;
                break;
            }
            finally {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        logger.debug("UID: non-root (failed to bind at any privileged ports)");
        return false;
    }

    private static int javaVersion0() {
        int n = PlatformDependent.isAndroid() ? 6 : PlatformDependent.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)n);
        return n;
    }

    static int majorVersionFromJavaSpecificationVersion() {
        try {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.specification.version");
                }
            });
            return PlatformDependent.majorVersion(string);
        }
        catch (SecurityException securityException) {
            logger.debug("security exception while reading java.specification.version", securityException);
            return 6;
        }
    }

    static int majorVersion(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        if (nArray[0] == 1) {
            assert (nArray[1] >= 6);
            return nArray[1];
        }
        return nArray[0];
    }

    private static boolean hasUnsafe0() {
        boolean bl = SystemPropertyUtil.getBoolean("io.netty.noUnsafe", false);
        logger.debug("-Dio.netty.noUnsafe: {}", (Object)bl);
        if (PlatformDependent.isAndroid()) {
            logger.debug("sun.misc.Unsafe: unavailable (Android)");
            return false;
        }
        if (bl) {
            logger.debug("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
            return false;
        }
        boolean bl2 = SystemPropertyUtil.contains("io.netty.tryUnsafe") ? SystemPropertyUtil.getBoolean("io.netty.tryUnsafe", true) : SystemPropertyUtil.getBoolean("org.jboss.netty.tryUnsafe", true);
        if (!bl2) {
            logger.debug("sun.misc.Unsafe: unavailable (io.netty.tryUnsafe/org.jboss.netty.tryUnsafe)");
            return false;
        }
        try {
            boolean bl3 = PlatformDependent0.hasUnsafe();
            logger.debug("sun.misc.Unsafe: {}", (Object)(bl3 ? "available" : "unavailable"));
            return bl3;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static long maxDirectMemory0() {
        GenericDeclaration genericDeclaration;
        Class<?> clazz;
        long l = 0L;
        try {
            clazz = Class.forName("sun.misc.VM", true, PlatformDependent.getSystemClassLoader());
            genericDeclaration = clazz.getDeclaredMethod("maxDirectMemory", new Class[0]);
            l = ((Number)((Method)genericDeclaration).invoke(null, new Object[0])).longValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (l > 0L) {
            return l;
        }
        try {
            clazz = Class.forName("java.lang.management.ManagementFactory", true, PlatformDependent.getSystemClassLoader());
            genericDeclaration = Class.forName("java.lang.management.RuntimeMXBean", true, PlatformDependent.getSystemClassLoader());
            Object object = clazz.getDeclaredMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
            List list = (List)((Class)genericDeclaration).getDeclaredMethod("getInputArguments", new Class[0]).invoke(object, new Object[0]);
            for (int i = list.size() - 1; i >= 0; --i) {
                Matcher matcher = MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN.matcher((CharSequence)list.get(i));
                if (!matcher.matches()) continue;
                l = Long.parseLong(matcher.group(1));
                switch (matcher.group(2).charAt(0)) {
                    case 'K': 
                    case 'k': {
                        l *= 1024L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        l *= 0x100000L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        l *= 0x40000000L;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (l <= 0L) {
            l = Runtime.getRuntime().maxMemory();
            logger.debug("maxDirectMemory: {} bytes (maybe)", (Object)l);
        } else {
            logger.debug("maxDirectMemory: {} bytes", (Object)l);
        }
        return l;
    }

    private static boolean hasJavassist0() {
        if (PlatformDependent.isAndroid()) {
            return false;
        }
        boolean bl = SystemPropertyUtil.getBoolean("io.netty.noJavassist", false);
        logger.debug("-Dio.netty.noJavassist: {}", (Object)bl);
        if (bl) {
            logger.debug("Javassist: unavailable (io.netty.noJavassist)");
            return false;
        }
        try {
            JavassistTypeParameterMatcherGenerator.generate(Object.class, PlatformDependent.getClassLoader(PlatformDependent.class));
            logger.debug("Javassist: available");
            return true;
        }
        catch (Throwable throwable) {
            logger.debug("Javassist: unavailable");
            logger.debug("You don't have Javassist in your class path or you don't have enough permission to load dynamically generated classes.  Please check the configuration for better performance.");
            return false;
        }
    }

    private static File tmpdir0() {
        File file;
        try {
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("io.netty.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {}", (Object)file);
                return file;
            }
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("java.io.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {} (java.io.tmpdir)", (Object)file);
                return file;
            }
            if (PlatformDependent.isWindows()) {
                file = PlatformDependent.toDirectory(System.getenv("TEMP"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} (%TEMP%)", (Object)file);
                    return file;
                }
                String string = System.getenv("USERPROFILE");
                if (string != null) {
                    file = PlatformDependent.toDirectory(string + "\\AppData\\Local\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\AppData\\Local\\Temp)", (Object)file);
                        return file;
                    }
                    file = PlatformDependent.toDirectory(string + "\\Local Settings\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\Local Settings\\Temp)", (Object)file);
                        return file;
                    }
                }
            } else {
                file = PlatformDependent.toDirectory(System.getenv("TMPDIR"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} ($TMPDIR)", (Object)file);
                    return file;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        file = PlatformDependent.isWindows() ? new File("C:\\Windows\\Temp") : new File("/tmp");
        logger.warn("Failed to get the temporary directory; falling back to: {}", (Object)file);
        return file;
    }

    private static File toDirectory(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        file.mkdirs();
        if (!file.isDirectory()) {
            return null;
        }
        try {
            return file.getAbsoluteFile();
        }
        catch (Exception exception) {
            return file;
        }
    }

    private static int bitMode0() {
        int n = SystemPropertyUtil.getInt("io.netty.bitMode", 0);
        if (n > 0) {
            logger.debug("-Dio.netty.bitMode: {}", (Object)n);
            return n;
        }
        n = SystemPropertyUtil.getInt("sun.arch.data.model", 0);
        if (n > 0) {
            logger.debug("-Dio.netty.bitMode: {} (sun.arch.data.model)", (Object)n);
            return n;
        }
        n = SystemPropertyUtil.getInt("com.ibm.vm.bitmode", 0);
        if (n > 0) {
            logger.debug("-Dio.netty.bitMode: {} (com.ibm.vm.bitmode)", (Object)n);
            return n;
        }
        String string = SystemPropertyUtil.get("os.arch", "").toLowerCase(Locale.US).trim();
        if ("amd64".equals(string) || "x86_64".equals(string)) {
            n = 64;
        } else if ("i386".equals(string) || "i486".equals(string) || "i586".equals(string) || "i686".equals(string)) {
            n = 32;
        }
        if (n > 0) {
            logger.debug("-Dio.netty.bitMode: {} (os.arch: {})", (Object)n, (Object)string);
        }
        String string2 = SystemPropertyUtil.get("java.vm.name", "").toLowerCase(Locale.US);
        Pattern pattern = Pattern.compile("([1-9][0-9]+)-?bit");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 64;
    }

    private static int addressSize0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1;
        }
        return PlatformDependent0.addressSize();
    }

    private static boolean equalsSafe(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n;
        int n6 = n2;
        while (n5 < n4) {
            if (byArray[n5] != byArray2[n6]) {
                return false;
            }
            ++n5;
            ++n6;
        }
        return true;
    }

    static int hashCodeAsciiSafe(byte[] byArray, int n, int n2) {
        int n3 = -1028477387;
        int n4 = n2 & 7;
        int n5 = n + n4;
        for (int i = n - 8 + n2; i >= n5; i -= 8) {
            n3 = PlatformDependent0.hashCodeAsciiCompute(PlatformDependent.getLongSafe(byArray, i), n3);
        }
        switch (n4) {
            case 7: {
                return ((n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n + 1))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n + 3));
            }
            case 6: {
                return (n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n + 2));
            }
            case 5: {
                return (n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n + 1));
            }
            case 4: {
                return n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n));
            }
            case 3: {
                return (n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n + 1));
            }
            case 2: {
                return n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n));
            }
            case 1: {
                return n3 * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n]);
            }
        }
        return n3;
    }

    private PlatformDependent() {
    }

    static {
        long l;
        logger = InternalLoggerFactory.getInstance(PlatformDependent.class);
        MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = Pattern.compile("\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");
        IS_ANDROID = PlatformDependent.isAndroid0();
        IS_WINDOWS = PlatformDependent.isWindows0();
        JAVA_VERSION = PlatformDependent.javaVersion0();
        CAN_ENABLE_TCP_NODELAY_BY_DEFAULT = !PlatformDependent.isAndroid();
        HAS_UNSAFE = PlatformDependent.hasUnsafe0();
        CAN_USE_CHM_V8 = HAS_UNSAFE && JAVA_VERSION < 8;
        DIRECT_BUFFER_PREFERRED = HAS_UNSAFE && !SystemPropertyUtil.getBoolean("io.netty.noPreferDirect", false);
        MAX_DIRECT_MEMORY = PlatformDependent.maxDirectMemory0();
        BYTE_ARRAY_BASE_OFFSET = PlatformDependent0.byteArrayBaseOffset();
        HAS_JAVASSIST = PlatformDependent.hasJavassist0();
        TMPDIR = PlatformDependent.tmpdir0();
        BIT_MODE = PlatformDependent.bitMode0();
        ADDRESS_SIZE = PlatformDependent.addressSize0();
        boolean bl = BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noPreferDirect: {}", (Object)(!DIRECT_BUFFER_PREFERRED ? 1 : 0));
        }
        if (!PlatformDependent.hasUnsafe() && !PlatformDependent.isAndroid()) {
            logger.info("Your platform does not provide complete low-level API for accessing direct buffers reliably. Unless explicitly requested, heap buffer will always be preferred to avoid potential system unstability.");
        }
        if ((l = SystemPropertyUtil.getLong("io.netty.maxDirectMemory", -1L)) == 0L || !PlatformDependent.hasUnsafe() || !PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            USE_DIRECT_BUFFER_NO_CLEANER = false;
            DIRECT_MEMORY_COUNTER = null;
        } else {
            USE_DIRECT_BUFFER_NO_CLEANER = true;
            DIRECT_MEMORY_COUNTER = l < 0L ? ((l = PlatformDependent.maxDirectMemory0()) <= 0L ? null : new AtomicLong()) : new AtomicLong();
        }
        DIRECT_MEMORY_LIMIT = l;
        logger.debug("io.netty.maxDirectMemory: {} bytes", (Object)l);
    }

    private static final class AtomicLongCounter
    extends AtomicLong
    implements LongCounter {
        private static final long serialVersionUID = 4074772784610639305L;

        private AtomicLongCounter() {
        }

        @Override
        public void add(long l) {
            this.addAndGet(l);
        }

        @Override
        public void increment() {
            this.incrementAndGet();
        }

        @Override
        public void decrement() {
            this.decrementAndGet();
        }

        @Override
        public long value() {
            return this.get();
        }
    }
}

