/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Constant;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThreadLocalRandom;
import java.nio.ByteBuffer;

public abstract class AbstractConstant<T extends AbstractConstant<T>>
implements Constant<T> {
    private final int id;
    private final String name;
    private volatile long uniquifier;
    private ByteBuffer directBuffer;

    protected AbstractConstant(int n, String string) {
        this.id = n;
        this.name = string;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final int id() {
        return this.id;
    }

    public final String toString() {
        return this.name();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public final int compareTo(T t) {
        long l;
        if (this == t) {
            return 0;
        }
        T t2 = t;
        int n = this.hashCode() - ((AbstractConstant)t2).hashCode();
        if (n != 0) {
            return n;
        }
        long l2 = this.uniquifier();
        if (l2 < (l = super.uniquifier())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        throw new Error("failed to compare two different constants");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long uniquifier() {
        long l = this.uniquifier;
        if (l == 0L) {
            AbstractConstant abstractConstant = this;
            synchronized (abstractConstant) {
                while ((l = this.uniquifier) == 0L) {
                    if (PlatformDependent.hasUnsafe()) {
                        this.directBuffer = ByteBuffer.allocateDirect(1);
                        this.uniquifier = PlatformDependent.directBufferAddress(this.directBuffer);
                        continue;
                    }
                    this.directBuffer = null;
                    this.uniquifier = ThreadLocalRandom.current().nextLong();
                }
            }
        }
        return l;
    }
}

