/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.InetNameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public class DefaultNameResolver
extends InetNameResolver {
    public DefaultNameResolver(EventExecutor eventExecutor) {
        super(eventExecutor);
    }

    @Override
    protected void doResolve(String string, Promise<InetAddress> promise) throws Exception {
        try {
            promise.setSuccess(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            promise.setFailure(unknownHostException);
        }
    }

    @Override
    protected void doResolveAll(String string, Promise<List<InetAddress>> promise) throws Exception {
        try {
            promise.setSuccess(Arrays.asList(InetAddress.getAllByName(string)));
        }
        catch (UnknownHostException unknownHostException) {
            promise.setFailure(unknownHostException);
        }
    }
}

