/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.ApplicationProtocolAccessor;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslJavaxX509Certificate;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslX509Certificate;
import io.netty.handler.ssl.SslParametersUtils;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;
import org.apache.tomcat.jni.Buffer;
import org.apache.tomcat.jni.SSL;

public final class OpenSslEngine
extends SSLEngine {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSslEngine.class);
    private static final Certificate[] EMPTY_CERTIFICATES = EmptyArrays.EMPTY_CERTIFICATES;
    private static final X509Certificate[] EMPTY_X509_CERTIFICATES = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
    private static final SSLException BEGIN_HANDSHAKE_ENGINE_CLOSED = ThrowableUtil.unknownStackTrace(new SSLException("engine closed"), OpenSslEngine.class, "beginHandshake()");
    private static final SSLException HANDSHAKE_ENGINE_CLOSED = ThrowableUtil.unknownStackTrace(new SSLException("engine closed"), OpenSslEngine.class, "handshake()");
    private static final SSLException RENEGOTIATION_UNSUPPORTED = ThrowableUtil.unknownStackTrace(new SSLException("renegotiation unsupported"), OpenSslEngine.class, "beginHandshake()");
    private static final SSLException ENCRYPTED_PACKET_OVERSIZED = ThrowableUtil.unknownStackTrace(new SSLException("encrypted packet oversized"), OpenSslEngine.class, "unwrap(...)");
    private static final Class<?> SNI_HOSTNAME_CLASS;
    private static final Method GET_SERVER_NAMES_METHOD;
    private static final Method SET_SERVER_NAMES_METHOD;
    private static final Method GET_ASCII_NAME_METHOD;
    private static final Method GET_USE_CIPHER_SUITES_ORDER_METHOD;
    private static final Method SET_USE_CIPHER_SUITES_ORDER_METHOD;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int MAX_COMPRESSED_LENGTH = 17408;
    private static final int MAX_CIPHERTEXT_LENGTH = 18432;
    static final int MAX_ENCRYPTED_PACKET_LENGTH = 18713;
    static final int MAX_ENCRYPTION_OVERHEAD_LENGTH = 2329;
    private static final AtomicIntegerFieldUpdater<OpenSslEngine> DESTROYED_UPDATER;
    private static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    private static final long EMPTY_ADDR;
    private static final SSLEngineResult NEED_UNWRAP_OK;
    private static final SSLEngineResult NEED_UNWRAP_CLOSED;
    private static final SSLEngineResult NEED_WRAP_OK;
    private static final SSLEngineResult NEED_WRAP_CLOSED;
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING;
    private long ssl;
    private long networkBIO;
    private boolean certificateSet;
    private HandshakeState handshakeState = HandshakeState.NOT_STARTED;
    private boolean receivedShutdown;
    private volatile int destroyed;
    private volatile ClientAuth clientAuth = ClientAuth.NONE;
    private volatile long lastAccessed = -1L;
    private String endPointIdentificationAlgorithm;
    private Object algorithmConstraints;
    private List<?> sniHostNames;
    private boolean isInboundDone;
    private boolean isOutboundDone;
    private boolean engineClosed;
    private final boolean clientMode;
    private final ByteBufAllocator alloc;
    private final OpenSslEngineMap engineMap;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final boolean rejectRemoteInitiatedRenegation;
    private final OpenSslSession session;
    private final Certificate[] localCerts;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final OpenSslKeyMaterialManager keyMaterialManager;
    SSLHandshakeException handshakeException;

    OpenSslEngine(OpenSslContext openSslContext, ByteBufAllocator byteBufAllocator, String string, int n) {
        super(string, n);
        OpenSsl.ensureAvailability();
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)openSslContext.applicationProtocolNegotiator();
        this.ssl = SSL.newSSL((long)openSslContext.ctx, (!openSslContext.isClient() ? 1 : 0) != 0);
        this.session = new OpenSslSession(openSslContext.sessionContext());
        this.networkBIO = SSL.makeNetworkBIO((long)this.ssl);
        this.clientMode = openSslContext.isClient();
        this.engineMap = openSslContext.engineMap;
        this.rejectRemoteInitiatedRenegation = openSslContext.rejectRemoteInitiatedRenegotiation;
        this.localCerts = openSslContext.keyCertChain;
        this.setClientAuth(this.clientMode ? ClientAuth.NONE : openSslContext.clientAuth);
        if (this.clientMode && string != null) {
            SSL.setTlsExtHostName((long)this.ssl, (String)string);
        }
        this.keyMaterialManager = openSslContext.keyMaterialManager();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        switch (this.handshakeState) {
            case NOT_STARTED: 
            case FINISHED: {
                return null;
            }
        }
        return this.session;
    }

    public synchronized long sslPointer() {
        return this.ssl;
    }

    public synchronized void shutdown() {
        if (DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            this.engineMap.remove(this.ssl);
            SSL.freeSSL((long)this.ssl);
            SSL.freeBIO((long)this.networkBIO);
            this.networkBIO = 0L;
            this.ssl = 0L;
            this.engineClosed = true;
            this.isOutboundDone = true;
            this.isInboundDone = true;
        }
        SSL.clearError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        int n4 = Math.min(n3 - n2, 16384);
        if (byteBuffer.isDirect()) {
            long l = Buffer.address((ByteBuffer)byteBuffer) + (long)n2;
            n = SSL.writeToSSL((long)this.ssl, (long)l, (int)n4);
            if (n > 0) {
                byteBuffer.position(n2 + n);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n4);
            try {
                long l = OpenSsl.memoryAddress(byteBuf);
                byteBuffer.limit(n2 + n4);
                byteBuf.setBytes(0, byteBuffer);
                byteBuffer.limit(n3);
                n = SSL.writeToSSL((long)this.ssl, (long)l, (int)n4);
                if (n > 0) {
                    byteBuffer.position(n2 + n);
                } else {
                    byteBuffer.position(n2);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeEncryptedData(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.remaining();
        if (byteBuffer.isDirect()) {
            long l = Buffer.address((ByteBuffer)byteBuffer) + (long)n2;
            n = SSL.writeToBIO((long)this.networkBIO, (long)l, (int)n3);
            if (n >= 0) {
                byteBuffer.position(n2 + n);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n3);
            try {
                long l = OpenSsl.memoryAddress(byteBuf);
                byteBuf.setBytes(0, byteBuffer);
                n = SSL.writeToBIO((long)this.networkBIO, (long)l, (int)n3);
                if (n >= 0) {
                    byteBuffer.position(n2 + n);
                } else {
                    byteBuffer.position(n2);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(ByteBuffer byteBuffer) {
        int n;
        if (byteBuffer.isDirect()) {
            int n2;
            int n3 = byteBuffer.position();
            long l = Buffer.address((ByteBuffer)byteBuffer) + (long)n3;
            n = SSL.readFromSSL((long)this.ssl, (long)l, (int)(n2 = byteBuffer.limit() - n3));
            if (n > 0) {
                byteBuffer.position(n3 + n);
            }
        } else {
            int n4 = byteBuffer.position();
            int n5 = byteBuffer.limit();
            int n6 = Math.min(18713, n5 - n4);
            ByteBuf byteBuf = this.alloc.directBuffer(n6);
            try {
                long l = OpenSsl.memoryAddress(byteBuf);
                n = SSL.readFromSSL((long)this.ssl, (long)l, (int)n6);
                if (n > 0) {
                    byteBuffer.limit(n4 + n);
                    byteBuf.getBytes(0, byteBuffer);
                    byteBuffer.limit(n5);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readEncryptedData(ByteBuffer byteBuffer, int n) {
        int n2;
        if (byteBuffer.isDirect() && byteBuffer.remaining() >= n) {
            int n3 = byteBuffer.position();
            long l = Buffer.address((ByteBuffer)byteBuffer) + (long)n3;
            n2 = SSL.readFromBIO((long)this.networkBIO, (long)l, (int)n);
            if (n2 > 0) {
                byteBuffer.position(n3 + n2);
                return n2;
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n);
            try {
                long l = OpenSsl.memoryAddress(byteBuf);
                n2 = SSL.readFromBIO((long)this.networkBIO, (long)l, (int)n);
                if (n2 > 0) {
                    int n4 = byteBuffer.limit();
                    byteBuffer.limit(byteBuffer.position() + n2);
                    byteBuf.getBytes(0, byteBuffer);
                    byteBuffer.limit(n4);
                    int n5 = n2;
                    return n5;
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n2;
    }

    private SSLEngineResult readPendingBytesFromBIO(ByteBuffer byteBuffer, int n, int n2, SSLEngineResult.HandshakeStatus handshakeStatus) throws SSLException {
        int n3 = SSL.pendingWrittenBytesInBIO((long)this.networkBIO);
        if (n3 > 0) {
            int n4 = byteBuffer.remaining();
            if (n4 < n3) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus(n3) : handshakeStatus), n, n2);
            }
            int n5 = this.readEncryptedData(byteBuffer, n3);
            if (n5 <= 0) {
                SSL.clearError();
            } else {
                n2 += n5;
                n3 -= n5;
            }
            if (this.isOutboundDone) {
                this.shutdown();
            }
            return new SSLEngineResult(this.getEngineStatus(), this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus(n3) : handshakeStatus), n, n2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("srcs is null");
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException("dst is null");
        }
        if (n >= byteBufferArray.length || n + n2 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n + ", length: " + n2 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            SSLEngineResult sSLEngineResult;
            if (this.isDestroyed()) {
                return CLOSED_NOT_HANDSHAKING;
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            if (this.handshakeState != HandshakeState.FINISHED) {
                if (this.handshakeState != HandshakeState.STARTED_EXPLICITLY) {
                    this.handshakeState = HandshakeState.STARTED_IMPLICITLY;
                }
                if ((handshakeStatus = this.handshake()) == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    return NEED_UNWRAP_OK;
                }
                if (this.engineClosed) {
                    return NEED_UNWRAP_CLOSED;
                }
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = n + n2;
            for (int i = n; i < n5; ++i) {
                ByteBuffer byteBuffer2 = byteBufferArray[i];
                if (byteBuffer2 == null) {
                    throw new IllegalArgumentException("srcs[" + i + "] is null");
                }
                while (byteBuffer2.hasRemaining()) {
                    SSLEngineResult sSLEngineResult2;
                    int n6 = this.writePlaintextData(byteBuffer2);
                    if (n6 > 0) {
                        sSLEngineResult2 = this.readPendingBytesFromBIO(byteBuffer, n4 += n6, n3, handshakeStatus);
                        if (sSLEngineResult2 == null) continue;
                        if (sSLEngineResult2.getStatus() != SSLEngineResult.Status.OK) {
                            return sSLEngineResult2;
                        }
                        n3 = sSLEngineResult2.bytesProduced();
                        continue;
                    }
                    int n7 = SSL.getError((long)this.ssl, (int)n6);
                    switch (n7) {
                        case 6: {
                            if (!this.receivedShutdown) {
                                this.closeAll();
                            }
                            SSLEngineResult sSLEngineResult3 = (sSLEngineResult2 = this.readPendingBytesFromBIO(byteBuffer, n4, n3, handshakeStatus)) != null ? sSLEngineResult2 : CLOSED_NOT_HANDSHAKING;
                            return sSLEngineResult3;
                        }
                        case 2: {
                            sSLEngineResult2 = this.readPendingBytesFromBIO(byteBuffer, n4, n3, handshakeStatus);
                            return sSLEngineResult2 != null ? sSLEngineResult2 : new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, n4, n3);
                        }
                        case 3: {
                            sSLEngineResult2 = this.readPendingBytesFromBIO(byteBuffer, n4, n3, handshakeStatus);
                            return sSLEngineResult2 != null ? sSLEngineResult2 : NEED_WRAP_CLOSED;
                        }
                    }
                    throw this.shutdownWithError("SSL_write");
                }
            }
            if (n4 == 0 && (sSLEngineResult = this.readPendingBytesFromBIO(byteBuffer, 0, n3, handshakeStatus)) != null) {
                return sSLEngineResult;
            }
            return this.newResult(n4, n3, handshakeStatus);
        }
    }

    private SSLException shutdownWithError(String string) {
        String string2 = SSL.getLastError();
        return this.shutdownWithError(string, string2);
    }

    private SSLException shutdownWithError(String string, String string2) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} failed: OpenSSL error: {}", (Object)string, (Object)string2);
        }
        this.shutdown();
        if (this.handshakeState == HandshakeState.FINISHED) {
            return new SSLException(string2);
        }
        return new SSLHandshakeException(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws SSLException {
        Object object;
        int n5;
        if (byteBufferArray == null) {
            throw new NullPointerException("srcs");
        }
        if (n >= byteBufferArray.length || n + n2 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n + ", length: " + n2 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBufferArray2 == null) {
            throw new IllegalArgumentException("dsts is null");
        }
        if (n3 >= byteBufferArray2.length || n3 + n4 > byteBufferArray2.length) {
            throw new IndexOutOfBoundsException("offset: " + n3 + ", length: " + n4 + " (expected: offset <= offset + length <= dsts.length (" + byteBufferArray2.length + "))");
        }
        long l = 0L;
        int n6 = n3 + n4;
        for (n5 = n3; n5 < n6; ++n5) {
            ByteBuffer byteBuffer = byteBufferArray2[n5];
            if (byteBuffer == null) {
                throw new IllegalArgumentException("dsts[" + n5 + "] is null");
            }
            if (byteBuffer.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            l += (long)byteBuffer.remaining();
        }
        n5 = n + n2;
        long l2 = 0L;
        for (int i = n; i < n5; ++i) {
            object = byteBufferArray[i];
            if (object == null) {
                throw new IllegalArgumentException("srcs[" + i + "] is null");
            }
            l2 += (long)object.remaining();
        }
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            int n7;
            if (this.isDestroyed()) {
                return CLOSED_NOT_HANDSHAKING;
            }
            if (l2 > 18713L) {
                this.isInboundDone = true;
                this.isOutboundDone = true;
                this.engineClosed = true;
                this.shutdown();
                throw ENCRYPTED_PACKET_OVERSIZED;
            }
            object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            if (this.handshakeState != HandshakeState.FINISHED) {
                if (this.handshakeState != HandshakeState.STARTED_EXPLICITLY) {
                    this.handshakeState = HandshakeState.STARTED_IMPLICITLY;
                }
                if ((object = this.handshake()) == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    return NEED_WRAP_OK;
                }
                if (this.engineClosed) {
                    return NEED_WRAP_CLOSED;
                }
            }
            int n8 = 0;
            if (n < n5) {
                do {
                    ByteBuffer byteBuffer;
                    if ((n7 = (byteBuffer = byteBufferArray[n]).remaining()) == 0) {
                        ++n;
                        continue;
                    }
                    int n9 = this.writeEncryptedData(byteBuffer);
                    if (n9 > 0) {
                        n8 += n9;
                        if (n9 != n7) break;
                        ++n;
                        continue;
                    }
                    SSL.clearError();
                    break;
                } while (n < n5);
            }
            int n10 = 0;
            if (l > 0L) {
                n7 = n3;
                while (n7 < n6) {
                    ByteBuffer byteBuffer = byteBufferArray2[n7];
                    if (!byteBuffer.hasRemaining()) {
                        ++n7;
                        continue;
                    }
                    int n11 = this.readPlaintextData(byteBuffer);
                    this.rejectRemoteInitiatedRenegation();
                    if (n11 > 0) {
                        n10 += n11;
                        if (!byteBuffer.hasRemaining()) {
                            ++n7;
                            continue;
                        }
                        return this.newResult(n8, n10, (SSLEngineResult.HandshakeStatus)((Object)object));
                    }
                    int n12 = SSL.getError((long)this.ssl, (int)n11);
                    switch (n12) {
                        case 6: {
                            if (!this.receivedShutdown) {
                                this.closeAll();
                            }
                        }
                        case 2: 
                        case 3: {
                            return this.newResult(n8, n10, (SSLEngineResult.HandshakeStatus)((Object)object));
                        }
                    }
                    return this.sslReadErrorResult(SSL.getLastErrorNumber(), n8, n10);
                }
            } else if (SSL.readFromSSL((long)this.ssl, (long)EMPTY_ADDR, (int)0) <= 0 && OpenSsl.isError(n7 = SSL.getLastErrorNumber())) {
                return this.sslReadErrorResult(n7, n8, n10);
            }
            if (this.pendingAppData() > 0) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.mayFinishHandshake((SSLEngineResult.HandshakeStatus)((Object)(object != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : object))), n8, n10);
            }
            if (!this.receivedShutdown && (SSL.getShutdown((long)this.ssl) & 2) == 2) {
                this.closeAll();
            }
            return this.newResult(n8, n10, (SSLEngineResult.HandshakeStatus)((Object)object));
        }
    }

    private SSLEngineResult sslReadErrorResult(int n, int n2, int n3) throws SSLException {
        String string = SSL.getErrorString((long)n);
        if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) > 0) {
            if (this.handshakeException == null && this.handshakeState != HandshakeState.FINISHED) {
                this.handshakeException = new SSLHandshakeException(string);
            }
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n2, n3);
        }
        throw this.shutdownWithError("SSL_read", string);
    }

    private int pendingAppData() {
        return this.handshakeState == HandshakeState.FINISHED ? SSL.pendingReadableBytesInSSL((long)this.ssl) : 0;
    }

    private SSLEngineResult newResult(int n, int n2, SSLEngineResult.HandshakeStatus handshakeStatus) throws SSLException {
        return new SSLEngineResult(this.getEngineStatus(), this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : handshakeStatus), n, n2);
    }

    private void closeAll() throws SSLException {
        this.receivedShutdown = true;
        this.closeOutbound();
        this.closeInbound();
    }

    private void rejectRemoteInitiatedRenegation() throws SSLHandshakeException {
        if (this.rejectRemoteInitiatedRenegation && SSL.getHandshakeCount((long)this.ssl) > 1) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotation not allowed");
        }
    }

    public SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) throws SSLException {
        return this.unwrap(byteBufferArray, 0, byteBufferArray.length, byteBufferArray2, 0, byteBufferArray2.length);
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer byteBuffer) {
        this.singleSrcBuffer[0] = byteBuffer;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer byteBuffer) {
        this.singleDstBuffer[0] = byteBuffer;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), 0, 1, byteBufferArray, n, n2);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.wrap(this.singleSrcBuffer(byteBuffer), byteBuffer2);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), this.singleDstBuffer(byteBuffer2));
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
            this.resetSingleDstBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), byteBufferArray);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        this.engineClosed = true;
        this.shutdown();
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.isInboundDone || this.engineClosed;
    }

    @Override
    public synchronized void closeOutbound() {
        if (this.isOutboundDone) {
            return;
        }
        this.isOutboundDone = true;
        this.engineClosed = true;
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.isDestroyed()) {
            int n;
            int n2 = SSL.getShutdown((long)this.ssl);
            if ((n2 & 1) != 1 && (n = SSL.shutdownSSL((long)this.ssl)) < 0) {
                int n3 = SSL.getError((long)this.ssl, (int)n);
                switch (n3) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 1: 
                    case 5: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("SSL_shutdown failed: OpenSSL error: {}", (Object)SSL.getLastError());
                        }
                        this.shutdown();
                        break;
                    }
                    default: {
                        SSL.clearError();
                    }
                }
            }
        } else {
            this.shutdown();
        }
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.isOutboundDone;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return OpenSsl.AVAILABLE_CIPHER_SUITES.toArray(new String[OpenSsl.AVAILABLE_CIPHER_SUITES.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getEnabledCipherSuites() {
        String[] stringArray;
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            if (this.isDestroyed()) {
                return EmptyArrays.EMPTY_STRINGS;
            }
            stringArray = SSL.getCiphers((long)this.ssl);
        }
        if (stringArray == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.toJavaCipherSuite(stringArray[i]);
            if (string == null) continue;
            stringArray[i] = string;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabledCipherSuites(String[] stringArray) {
        ObjectUtil.checkNotNull(stringArray, "cipherSuites");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null) break;
            String string2 = CipherSuiteConverter.toOpenSsl(string);
            if (string2 == null) {
                string2 = string;
            }
            if (!OpenSsl.isCipherSuiteAvailable(string2)) {
                throw new IllegalArgumentException("unsupported cipher suite: " + string + '(' + string2 + ')');
            }
            stringBuilder.append(string2);
            stringBuilder.append(':');
        }
        if (stringBuilder.length() == 0) {
            throw new IllegalArgumentException("empty cipher suites");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        String string = stringBuilder.toString();
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            if (!this.isDestroyed()) {
                try {
                    SSL.setCipherSuites((long)this.ssl, (String)string);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to enable cipher suites: " + string, exception);
                }
            } else {
                throw new IllegalStateException("failed to enable cipher suites: " + string);
            }
        }
    }

    @Override
    public String[] getSupportedProtocols() {
        return OpenSsl.SUPPORTED_PROTOCOLS_SET.toArray(new String[OpenSsl.SUPPORTED_PROTOCOLS_SET.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getEnabledProtocols() {
        int n;
        ArrayList<String> arrayList = InternalThreadLocalMap.get().arrayList();
        arrayList.add("SSLv2Hello");
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            if (this.isDestroyed()) {
                return arrayList.toArray(new String[1]);
            }
            n = SSL.getOptions((long)this.ssl);
        }
        if ((n & 0x4000000) == 0) {
            arrayList.add("TLSv1");
        }
        if ((n & 0x10000000) == 0) {
            arrayList.add("TLSv1.1");
        }
        if ((n & 0x8000000) == 0) {
            arrayList.add("TLSv1.2");
        }
        if ((n & 0x1000000) == 0) {
            arrayList.add("SSLv2");
        }
        if ((n & 0x2000000) == 0) {
            arrayList.add("SSLv3");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (String string : stringArray) {
            if (!OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string)) {
                throw new IllegalArgumentException("Protocol " + string + " is not supported.");
            }
            if (string.equals("SSLv2")) {
                bl = true;
                continue;
            }
            if (string.equals("SSLv3")) {
                bl2 = true;
                continue;
            }
            if (string.equals("TLSv1")) {
                bl3 = true;
                continue;
            }
            if (string.equals("TLSv1.1")) {
                bl4 = true;
                continue;
            }
            if (!string.equals("TLSv1.2")) continue;
            bl5 = true;
        }
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            int n;
            if (!this.isDestroyed()) {
                SSL.setOptions((long)this.ssl, (int)4095);
                SSL.clearOptions((long)this.ssl, (int)0x1F000000);
                n = 0;
                if (!bl) {
                    n |= 0x1000000;
                }
                if (!bl2) {
                    n |= 0x2000000;
                }
                if (!bl3) {
                    n |= 0x4000000;
                }
                if (!bl4) {
                    n |= 0x10000000;
                }
                if (!bl5) {
                    n |= 0x8000000;
                }
            } else {
                throw new IllegalStateException("failed to enable protocols: " + Arrays.asList(stringArray));
            }
            SSL.setOptions((long)this.ssl, (int)n);
        }
    }

    @Override
    public SSLSession getSession() {
        return this.session;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        switch (this.handshakeState) {
            case STARTED_IMPLICITLY: {
                this.checkEngineClosed(BEGIN_HANDSHAKE_ENGINE_CLOSED);
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                break;
            }
            case STARTED_EXPLICITLY: {
                break;
            }
            case FINISHED: {
                if (this.clientMode) {
                    throw RENEGOTIATION_UNSUPPORTED;
                }
                if (SSL.renegotiate((long)this.ssl) != 1 || SSL.doHandshake((long)this.ssl) != 1) {
                    throw this.shutdownWithError("renegotiation failed");
                }
                SSL.setState((long)this.ssl, (int)8192);
                this.lastAccessed = System.currentTimeMillis();
            }
            case NOT_STARTED: {
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                this.handshake();
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void checkEngineClosed(SSLException sSLException) throws SSLException {
        if (this.engineClosed || this.isDestroyed()) {
            throw sSLException;
        }
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int n) {
        return n > 0 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    private SSLEngineResult.HandshakeStatus handshake() throws SSLException {
        int n;
        if (this.handshakeState == HandshakeState.FINISHED) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        this.checkEngineClosed(HANDSHAKE_ENGINE_CLOSED);
        SSLHandshakeException sSLHandshakeException = this.handshakeException;
        if (sSLHandshakeException != null) {
            if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) > 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            this.handshakeException = null;
            this.shutdown();
            throw sSLHandshakeException;
        }
        this.engineMap.add(this);
        if (this.lastAccessed == -1L) {
            this.lastAccessed = System.currentTimeMillis();
        }
        if (!this.certificateSet && this.keyMaterialManager != null) {
            this.certificateSet = true;
            this.keyMaterialManager.setKeyMaterial(this);
        }
        if ((n = SSL.doHandshake((long)this.ssl)) <= 0) {
            if (this.handshakeException != null) {
                sSLHandshakeException = this.handshakeException;
                this.handshakeException = null;
                this.shutdown();
                throw sSLHandshakeException;
            }
            int n2 = SSL.getError((long)this.ssl, (int)n);
            switch (n2) {
                case 2: 
                case 3: {
                    return OpenSslEngine.pendingStatus(SSL.pendingWrittenBytesInBIO((long)this.networkBIO));
                }
            }
            throw this.shutdownWithError("SSL_do_handshake");
        }
        this.session.handshakeFinished();
        this.engineMap.remove(this.ssl);
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private SSLEngineResult.Status getEngineStatus() {
        return this.engineClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) throws SSLException {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.handshakeState != HandshakeState.FINISHED) {
            return this.handshake();
        }
        return handshakeStatus;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.needPendingStatus() ? OpenSslEngine.pendingStatus(SSL.pendingWrittenBytesInBIO((long)this.networkBIO)) : SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int n) {
        return this.needPendingStatus() ? OpenSslEngine.pendingStatus(n) : SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private boolean needPendingStatus() {
        return this.handshakeState != HandshakeState.NOT_STARTED && !this.isDestroyed() && (this.handshakeState != HandshakeState.FINISHED || this.engineClosed);
    }

    private String toJavaCipherSuite(String string) {
        if (string == null) {
            return null;
        }
        String string2 = OpenSslEngine.toJavaCipherSuitePrefix(SSL.getVersion((long)this.ssl));
        return CipherSuiteConverter.toJava(string, string2);
    }

    private static String toJavaCipherSuitePrefix(String string) {
        int n = string == null || string.length() == 0 ? 0 : (int)string.charAt(0);
        switch (n) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public void setUseClientMode(boolean bl) {
        if (bl != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public void setNeedClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuth.REQUIRE;
    }

    @Override
    public void setWantClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.OPTIONAL : ClientAuth.NONE);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.clientAuth == ClientAuth.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuth clientAuth) {
        if (this.clientMode) {
            return;
        }
        OpenSslEngine openSslEngine = this;
        synchronized (openSslEngine) {
            if (this.clientAuth == clientAuth) {
                return;
            }
            switch (clientAuth) {
                case NONE: {
                    SSL.setVerify((long)this.ssl, (int)0, (int)10);
                    break;
                }
                case REQUIRE: {
                    SSL.setVerify((long)this.ssl, (int)2, (int)10);
                    break;
                }
                case OPTIONAL: {
                    SSL.setVerify((long)this.ssl, (int)1, (int)10);
                }
            }
            this.clientAuth = clientAuth;
        }
    }

    @Override
    public void setEnableSessionCreation(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        return false;
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        int n = PlatformDependent.javaVersion();
        if (n >= 7) {
            sSLParameters.setEndpointIdentificationAlgorithm(this.endPointIdentificationAlgorithm);
            SslParametersUtils.setAlgorithmConstraints(sSLParameters, this.algorithmConstraints);
            if (n >= 8) {
                if (SET_SERVER_NAMES_METHOD != null && this.sniHostNames != null) {
                    try {
                        SET_SERVER_NAMES_METHOD.invoke((Object)sSLParameters, this.sniHostNames);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new Error(invocationTargetException);
                    }
                }
                if (SET_USE_CIPHER_SUITES_ORDER_METHOD != null && !this.isDestroyed()) {
                    try {
                        SET_USE_CIPHER_SUITES_ORDER_METHOD.invoke((Object)sSLParameters, (SSL.getOptions((long)this.ssl) & 0x400000) != 0);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new Error(invocationTargetException);
                    }
                }
            }
        }
        return sSLParameters;
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        super.setSSLParameters(sSLParameters);
        int n = PlatformDependent.javaVersion();
        if (n >= 7) {
            this.endPointIdentificationAlgorithm = sSLParameters.getEndpointIdentificationAlgorithm();
            this.algorithmConstraints = sSLParameters.getAlgorithmConstraints();
            if (n >= 8) {
                if (SNI_HOSTNAME_CLASS != null && this.clientMode && !this.isDestroyed()) {
                    assert (GET_SERVER_NAMES_METHOD != null);
                    assert (GET_ASCII_NAME_METHOD != null);
                    try {
                        List list = (List)GET_SERVER_NAMES_METHOD.invoke((Object)sSLParameters, new Object[0]);
                        if (list != null) {
                            for (Object e : list) {
                                if (SNI_HOSTNAME_CLASS.isInstance(e)) {
                                    SSL.setTlsExtHostName((long)this.ssl, (String)((String)GET_ASCII_NAME_METHOD.invoke(e, new Object[0])));
                                    continue;
                                }
                                throw new IllegalArgumentException("Only " + SNI_HOSTNAME_CLASS.getName() + " instances are supported, but found: " + e);
                            }
                        }
                        this.sniHostNames = list;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new Error(invocationTargetException);
                    }
                }
                if (GET_USE_CIPHER_SUITES_ORDER_METHOD != null && !this.isDestroyed()) {
                    try {
                        if (((Boolean)GET_USE_CIPHER_SUITES_ORDER_METHOD.invoke((Object)sSLParameters, new Object[0])).booleanValue()) {
                            SSL.setOptions((long)this.ssl, (int)0x400000);
                        } else {
                            SSL.clearOptions((long)this.ssl, (int)0x400000);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new Error(invocationTargetException);
                    }
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    private boolean isDestroyed() {
        return this.destroyed != 0;
    }

    static {
        AtomicIntegerFieldUpdater<OpenSslEngine> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(OpenSslEngine.class, "destroyed");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(OpenSslEngine.class, "destroyed");
        }
        DESTROYED_UPDATER = atomicIntegerFieldUpdater;
        Method method = null;
        Method method2 = null;
        Class<?> clazz = null;
        Method method3 = null;
        Method method4 = null;
        Method method5 = null;
        if (PlatformDependent.javaVersion() >= 8) {
            Object object;
            SSLParameters sSLParameters;
            try {
                method = SSLParameters.class.getDeclaredMethod("getUseCipherSuitesOrder", new Class[0]);
                sSLParameters = new SSLParameters();
                object = (Boolean)method.invoke((Object)sSLParameters, new Object[0]);
                method2 = SSLParameters.class.getDeclaredMethod("setUseCipherSuitesOrder", Boolean.TYPE);
                method2.invoke((Object)sSLParameters, true);
            }
            catch (Throwable throwable) {
                method = null;
                method2 = null;
            }
            try {
                clazz = Class.forName("javax.net.ssl.SNIHostName", false, PlatformDependent.getClassLoader(OpenSslEngine.class));
                sSLParameters = clazz.getConstructor(String.class).newInstance("netty.io");
                method3 = clazz.getDeclaredMethod("getAsciiName", new Class[0]);
                object = (String)method3.invoke((Object)sSLParameters, new Object[0]);
                method4 = SSLParameters.class.getDeclaredMethod("getServerNames", new Class[0]);
                method5 = SSLParameters.class.getDeclaredMethod("setServerNames", List.class);
                SSLParameters sSLParameters2 = new SSLParameters();
                List list = (List)method4.invoke((Object)sSLParameters2, new Object[0]);
                method5.invoke((Object)sSLParameters2, Collections.emptyList());
            }
            catch (Throwable throwable) {
                clazz = null;
                method3 = null;
                method4 = null;
                method5 = null;
            }
        }
        GET_USE_CIPHER_SUITES_ORDER_METHOD = method;
        SET_USE_CIPHER_SUITES_ORDER_METHOD = method2;
        SNI_HOSTNAME_CLASS = clazz;
        GET_ASCII_NAME_METHOD = method3;
        GET_SERVER_NAMES_METHOD = method4;
        SET_SERVER_NAMES_METHOD = method5;
        EMPTY_ADDR = Buffer.address((ByteBuffer)Unpooled.EMPTY_BUFFER.nioBuffer());
        NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    }

    private final class OpenSslSession
    implements SSLSession,
    ApplicationProtocolAccessor {
        private final OpenSslSessionContext sessionContext;
        private X509Certificate[] x509PeerCerts;
        private String protocol;
        private String applicationProtocol;
        private Certificate[] peerCerts;
        private String cipher;
        private byte[] id;
        private long creationTime;
        private Map<String, Object> values;

        OpenSslSession(OpenSslSessionContext openSslSessionContext) {
            this.sessionContext = openSslSessionContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getId() {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (this.id == null) {
                    return EmptyArrays.EMPTY_BYTES;
                }
                return (byte[])this.id.clone();
            }
        }

        @Override
        public SSLSessionContext getSessionContext() {
            return this.sessionContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCreationTime() {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (this.creationTime == 0L && !OpenSslEngine.this.isDestroyed()) {
                    this.creationTime = SSL.getTime((long)OpenSslEngine.this.ssl) * 1000L;
                }
            }
            return this.creationTime;
        }

        @Override
        public long getLastAccessedTime() {
            long l = OpenSslEngine.this.lastAccessed;
            return l == -1L ? this.getCreationTime() : l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (!OpenSslEngine.this.isDestroyed()) {
                    SSL.setTimeout((long)OpenSslEngine.this.ssl, (long)0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValid() {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (!OpenSslEngine.this.isDestroyed()) {
                    return System.currentTimeMillis() - SSL.getTimeout((long)OpenSslEngine.this.ssl) * 1000L < SSL.getTime((long)OpenSslEngine.this.ssl) * 1000L;
                }
            }
            return false;
        }

        @Override
        public void putValue(String string, Object object) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            if (object == null) {
                throw new NullPointerException("value");
            }
            Map<String, Object> map = this.values;
            if (map == null) {
                map = this.values = new HashMap<String, Object>(2);
            }
            Object object2 = map.put(string, object);
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
            }
            this.notifyUnbound(object2, string);
        }

        @Override
        public Object getValue(String string) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            if (this.values == null) {
                return null;
            }
            return this.values.get(string);
        }

        @Override
        public void removeValue(String string) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            Map<String, Object> map = this.values;
            if (map == null) {
                return;
            }
            Object object = map.remove(string);
            this.notifyUnbound(object, string);
        }

        @Override
        public String[] getValueNames() {
            Map<String, Object> map = this.values;
            if (map == null || map.isEmpty()) {
                return EmptyArrays.EMPTY_STRINGS;
            }
            return map.keySet().toArray(new String[map.size()]);
        }

        private void notifyUnbound(Object object, String string) {
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handshakeFinished() throws SSLException {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (OpenSslEngine.this.isDestroyed()) {
                    throw new SSLException("Already closed");
                }
                this.id = SSL.getSessionId((long)OpenSslEngine.this.ssl);
                this.cipher = OpenSslEngine.this.toJavaCipherSuite(SSL.getCipherForSSL((long)OpenSslEngine.this.ssl));
                this.protocol = SSL.getVersion((long)OpenSslEngine.this.ssl);
                this.initPeerCerts();
                this.selectApplicationProtocol();
                OpenSslEngine.this.handshakeState = HandshakeState.FINISHED;
            }
        }

        private void initPeerCerts() {
            byte[][] byArray = SSL.getPeerCertChain((long)OpenSslEngine.this.ssl);
            byte[] byArray2 = !OpenSslEngine.this.clientMode ? SSL.getPeerCertificate((long)OpenSslEngine.this.ssl) : null;
            if (byArray == null && byArray2 == null) {
                this.peerCerts = EMPTY_CERTIFICATES;
                this.x509PeerCerts = EMPTY_X509_CERTIFICATES;
            } else {
                Certificate[] certificateArray;
                int n = byArray != null ? byArray.length : 0;
                int n2 = 0;
                if (byArray2 != null) {
                    certificateArray = new Certificate[++n];
                    certificateArray[n2++] = new OpenSslX509Certificate(byArray2);
                } else {
                    certificateArray = new Certificate[n];
                }
                if (byArray != null) {
                    X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        byte[] byArray3 = byArray[i];
                        x509CertificateArray[i] = new OpenSslJavaxX509Certificate(byArray3);
                        certificateArray[n2] = new OpenSslX509Certificate(byArray3);
                        ++n2;
                    }
                    this.x509PeerCerts = x509CertificateArray;
                } else {
                    this.x509PeerCerts = EMPTY_X509_CERTIFICATES;
                }
                this.peerCerts = certificateArray;
            }
        }

        private void selectApplicationProtocol() throws SSLException {
            ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior = OpenSslEngine.this.apn.selectedListenerFailureBehavior();
            List<String> list = OpenSslEngine.this.apn.protocols();
            switch (OpenSslEngine.this.apn.protocol()) {
                case NONE: {
                    break;
                }
                case ALPN: {
                    String string = SSL.getAlpnSelected((long)OpenSslEngine.this.ssl);
                    if (string == null) break;
                    this.applicationProtocol = this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                    break;
                }
                case NPN: {
                    String string = SSL.getNextProtoNegotiated((long)OpenSslEngine.this.ssl);
                    if (string == null) break;
                    this.applicationProtocol = this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                    break;
                }
                case NPN_AND_ALPN: {
                    String string = SSL.getAlpnSelected((long)OpenSslEngine.this.ssl);
                    if (string == null) {
                        string = SSL.getNextProtoNegotiated((long)OpenSslEngine.this.ssl);
                    }
                    if (string == null) break;
                    this.applicationProtocol = this.selectApplicationProtocol(list, selectedListenerFailureBehavior, string);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        private String selectApplicationProtocol(List<String> list, ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior, String string) throws SSLException {
            if (selectedListenerFailureBehavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT) {
                return string;
            }
            int n = list.size();
            assert (n > 0);
            if (list.contains(string)) {
                return string;
            }
            if (selectedListenerFailureBehavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
                return list.get(n - 1);
            }
            throw new SSLException("unknown protocol " + string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (this.peerCerts == null || this.peerCerts.length == 0) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return this.peerCerts;
            }
        }

        @Override
        public Certificate[] getLocalCertificates() {
            if (OpenSslEngine.this.localCerts == null) {
                return null;
            }
            return (Certificate[])OpenSslEngine.this.localCerts.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (this.x509PeerCerts == null || this.x509PeerCerts.length == 0) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return this.x509PeerCerts;
            }
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            Certificate[] certificateArray = this.getPeerCertificates();
            return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }

        @Override
        public Principal getLocalPrincipal() {
            Certificate[] certificateArray = OpenSslEngine.this.localCerts;
            if (certificateArray == null || certificateArray.length == 0) {
                return null;
            }
            return ((java.security.cert.X509Certificate)certificateArray[0]).getIssuerX500Principal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getCipherSuite() {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                if (this.cipher == null) {
                    return OpenSslEngine.INVALID_CIPHER;
                }
                return this.cipher;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getProtocol() {
            String string = this.protocol;
            if (string == null) {
                OpenSslEngine openSslEngine = OpenSslEngine.this;
                synchronized (openSslEngine) {
                    string = !OpenSslEngine.this.isDestroyed() ? SSL.getVersion((long)OpenSslEngine.this.ssl) : "";
                }
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getApplicationProtocol() {
            OpenSslEngine openSslEngine = OpenSslEngine.this;
            synchronized (openSslEngine) {
                return this.applicationProtocol;
            }
        }

        @Override
        public String getPeerHost() {
            return OpenSslEngine.this.getPeerHost();
        }

        @Override
        public int getPeerPort() {
            return OpenSslEngine.this.getPeerPort();
        }

        @Override
        public int getPacketBufferSize() {
            return 18713;
        }

        @Override
        public int getApplicationBufferSize() {
            return 16384;
        }
    }

    private static enum HandshakeState {
        NOT_STARTED,
        STARTED_IMPLICITLY,
        STARTED_EXPLICITLY,
        FINISHED;

    }
}

