/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.tomcat.jni.Buffer;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;

public final class OpenSsl {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSsl.class);
    private static final String LINUX = "linux";
    private static final String UNKNOWN = "unknown";
    private static final Throwable UNAVAILABILITY_CAUSE;
    static final Set<String> AVAILABLE_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_OPENSSL_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_JAVA_CIPHER_SUITES;
    private static final boolean SUPPORTS_KEYMANAGER_FACTORY;
    static final String PROTOCOL_SSL_V2_HELLO = "SSLv2Hello";
    static final String PROTOCOL_SSL_V2 = "SSLv2";
    static final String PROTOCOL_SSL_V3 = "SSLv3";
    static final String PROTOCOL_TLS_V1 = "TLSv1";
    static final String PROTOCOL_TLS_V1_1 = "TLSv1.1";
    static final String PROTOCOL_TLS_V1_2 = "TLSv1.2";
    private static final String[] SUPPORTED_PROTOCOLS;
    static final Set<String> SUPPORTED_PROTOCOLS_SET;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static boolean isAlpnSupported() {
        return (long)OpenSsl.version() >= 0x10002000L;
    }

    public static int version() {
        if (OpenSsl.isAvailable()) {
            return SSL.version();
        }
        return -1;
    }

    public static String versionString() {
        if (OpenSsl.isAvailable()) {
            return SSL.versionString();
        }
        return null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    @Deprecated
    public static Set<String> availableCipherSuites() {
        return OpenSsl.availableOpenSslCipherSuites();
    }

    public static Set<String> availableOpenSslCipherSuites() {
        return AVAILABLE_OPENSSL_CIPHER_SUITES;
    }

    public static Set<String> availableJavaCipherSuites() {
        return AVAILABLE_JAVA_CIPHER_SUITES;
    }

    public static boolean isCipherSuiteAvailable(String string) {
        String string2 = CipherSuiteConverter.toOpenSsl(string);
        if (string2 != null) {
            string = string2;
        }
        return AVAILABLE_OPENSSL_CIPHER_SUITES.contains(string);
    }

    public static boolean supportsKeyManagerFactory() {
        return SUPPORTS_KEYMANAGER_FACTORY;
    }

    static boolean isError(long l) {
        return l != 0L;
    }

    static long memoryAddress(ByteBuf byteBuf) {
        assert (byteBuf.isDirect());
        return byteBuf.hasMemoryAddress() ? byteBuf.memoryAddress() : Buffer.address((ByteBuffer)byteBuf.nioBuffer());
    }

    private OpenSsl() {
    }

    private static void loadTcNative() throws Exception {
        String string = OpenSsl.normalizeOs(SystemPropertyUtil.get("os.name", ""));
        String string2 = OpenSsl.normalizeArch(SystemPropertyUtil.get("os.arch", ""));
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(3);
        linkedHashSet.add("netty-tcnative-" + string + '-' + string2);
        if (LINUX.equalsIgnoreCase(string)) {
            linkedHashSet.add("netty-tcnative-" + string + '-' + string2 + "-fedora");
        }
        linkedHashSet.add("netty-tcnative");
        NativeLibraryLoader.loadFirstAvailable(SSL.class.getClassLoader(), linkedHashSet.toArray(new String[linkedHashSet.size()]));
    }

    private static void initializeTcNative() throws Exception {
        Library.initialize((String)"provided");
        SSL.initialize(null);
    }

    private static String normalizeOs(String string) {
        if ((string = OpenSsl.normalize(string)).startsWith("aix")) {
            return "aix";
        }
        if (string.startsWith("hpux")) {
            return "hpux";
        }
        if (string.startsWith("os400") && (string.length() <= 5 || !Character.isDigit(string.charAt(5)))) {
            return "os400";
        }
        if (string.startsWith(LINUX)) {
            return LINUX;
        }
        if (string.startsWith("macosx") || string.startsWith("osx")) {
            return "osx";
        }
        if (string.startsWith("freebsd")) {
            return "freebsd";
        }
        if (string.startsWith("openbsd")) {
            return "openbsd";
        }
        if (string.startsWith("netbsd")) {
            return "netbsd";
        }
        if (string.startsWith("solaris") || string.startsWith("sunos")) {
            return "sunos";
        }
        if (string.startsWith("windows")) {
            return "windows";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String string) {
        if ((string = OpenSsl.normalize(string)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (string.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (string.matches("^(ia64|itanium64)$")) {
            return "itanium_64";
        }
        if (string.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (string.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (string.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(string)) {
            return "aarch_64";
        }
        if (string.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if ("ppc64".equals(string)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(string)) {
            return "ppcle_64";
        }
        if ("s390".equals(string)) {
            return "s390_32";
        }
        if ("s390x".equals(string)) {
            return "s390_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String string) {
        return string.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        SUPPORTED_PROTOCOLS = new String[]{PROTOCOL_SSL_V2_HELLO, PROTOCOL_SSL_V2, PROTOCOL_SSL_V3, PROTOCOL_TLS_V1, PROTOCOL_TLS_V1_1, PROTOCOL_TLS_V1_2};
        SUPPORTED_PROTOCOLS_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SUPPORTED_PROTOCOLS)));
        Throwable throwable = null;
        try {
            Class.forName("org.apache.tomcat.jni.SSL", false, OpenSsl.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
            logger.debug("netty-tcnative not in the classpath; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.");
        }
        if (throwable == null) {
            try {
                OpenSsl.loadTcNative();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                logger.debug("Failed to load netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable, unless the " + "application has already loaded the symbols by some other means. " + "See http://netty.io/wiki/forked-tomcat-native.html for more information.", throwable2);
            }
            try {
                OpenSsl.initializeTcNative();
                throwable = null;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                }
                logger.debug("Failed to initialize netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable. " + "See http://netty.io/wiki/forked-tomcat-native.html for more information.", throwable3);
            }
        }
        UNAVAILABILITY_CAUSE = throwable;
        if (throwable == null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(128);
            boolean bl = false;
            long l = Pool.create((long)0L);
            try {
                long l2 = SSLContext.make((long)l, (int)31, (int)1);
                long l3 = 0L;
                long l4 = 0L;
                try {
                    SSLContext.setOptions((long)l2, (int)4095);
                    SSLContext.setCipherSuite((long)l2, (String)"ALL");
                    long l5 = SSL.newSSL((long)l2, (boolean)true);
                    try {
                        for (String string : SSL.getCiphers((long)l5)) {
                            if (string == null || string.length() == 0 || linkedHashSet.contains(string)) continue;
                            linkedHashSet.add(string);
                        }
                        try {
                            SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
                            l4 = OpenSslContext.toBIO(selfSignedCertificate.cert());
                            SSL.setCertificateChainBio((long)l5, (long)l4, (boolean)false);
                            bl = true;
                        }
                        catch (Throwable throwable4) {
                            logger.debug("KeyManagerFactory not supported.");
                        }
                    }
                    finally {
                        SSL.freeSSL((long)l5);
                        if (l3 != 0L) {
                            SSL.freeBIO((long)l3);
                        }
                        if (l4 != 0L) {
                            SSL.freeBIO((long)l4);
                        }
                    }
                }
                finally {
                    SSLContext.free((long)l2);
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to get the list of available OpenSSL cipher suites.", exception);
            }
            finally {
                Pool.destroy((long)l);
            }
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.unmodifiableSet(linkedHashSet);
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(AVAILABLE_OPENSSL_CIPHER_SUITES.size() * 2);
            for (String string : AVAILABLE_OPENSSL_CIPHER_SUITES) {
                linkedHashSet2.add(CipherSuiteConverter.toJava(string, "TLS"));
                linkedHashSet2.add(CipherSuiteConverter.toJava(string, "SSL"));
            }
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.unmodifiableSet(linkedHashSet2);
            LinkedHashSet linkedHashSet3 = new LinkedHashSet(AVAILABLE_OPENSSL_CIPHER_SUITES.size() + AVAILABLE_JAVA_CIPHER_SUITES.size());
            for (String string : AVAILABLE_OPENSSL_CIPHER_SUITES) {
                linkedHashSet3.add(string);
            }
            for (String string : AVAILABLE_JAVA_CIPHER_SUITES) {
                linkedHashSet3.add(string);
            }
            AVAILABLE_CIPHER_SUITES = linkedHashSet3;
            SUPPORTS_KEYMANAGER_FACTORY = bl;
        } else {
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.emptySet();
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.emptySet();
            AVAILABLE_CIPHER_SUITES = Collections.emptySet();
            SUPPORTS_KEYMANAGER_FACTORY = false;
        }
    }
}

