/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.channel.AddressedEnvelope;
import io.netty.handler.codec.dns.DefaultDnsResponse;
import io.netty.handler.codec.dns.DnsOpCode;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import java.net.InetSocketAddress;

public class DatagramDnsResponse
extends DefaultDnsResponse
implements AddressedEnvelope<DatagramDnsResponse, InetSocketAddress> {
    private final InetSocketAddress sender;
    private final InetSocketAddress recipient;

    public DatagramDnsResponse(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n) {
        this(inetSocketAddress, inetSocketAddress2, n, DnsOpCode.QUERY, DnsResponseCode.NOERROR);
    }

    public DatagramDnsResponse(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n, DnsOpCode dnsOpCode) {
        this(inetSocketAddress, inetSocketAddress2, n, dnsOpCode, DnsResponseCode.NOERROR);
    }

    public DatagramDnsResponse(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n, DnsOpCode dnsOpCode, DnsResponseCode dnsResponseCode) {
        super(n, dnsOpCode, dnsResponseCode);
        if (inetSocketAddress2 == null && inetSocketAddress == null) {
            throw new NullPointerException("recipient and sender");
        }
        this.sender = inetSocketAddress;
        this.recipient = inetSocketAddress2;
    }

    @Override
    public DatagramDnsResponse content() {
        return this;
    }

    @Override
    public InetSocketAddress sender() {
        return this.sender;
    }

    @Override
    public InetSocketAddress recipient() {
        return this.recipient;
    }

    @Override
    public DatagramDnsResponse setAuthoritativeAnswer(boolean bl) {
        return (DatagramDnsResponse)super.setAuthoritativeAnswer(bl);
    }

    @Override
    public DatagramDnsResponse setTruncated(boolean bl) {
        return (DatagramDnsResponse)super.setTruncated(bl);
    }

    @Override
    public DatagramDnsResponse setRecursionAvailable(boolean bl) {
        return (DatagramDnsResponse)super.setRecursionAvailable(bl);
    }

    @Override
    public DatagramDnsResponse setCode(DnsResponseCode dnsResponseCode) {
        return (DatagramDnsResponse)super.setCode(dnsResponseCode);
    }

    @Override
    public DatagramDnsResponse setId(int n) {
        return (DatagramDnsResponse)super.setId(n);
    }

    @Override
    public DatagramDnsResponse setOpCode(DnsOpCode dnsOpCode) {
        return (DatagramDnsResponse)super.setOpCode(dnsOpCode);
    }

    @Override
    public DatagramDnsResponse setRecursionDesired(boolean bl) {
        return (DatagramDnsResponse)super.setRecursionDesired(bl);
    }

    @Override
    public DatagramDnsResponse setZ(int n) {
        return (DatagramDnsResponse)super.setZ(n);
    }

    @Override
    public DatagramDnsResponse setRecord(DnsSection dnsSection, DnsRecord dnsRecord) {
        return (DatagramDnsResponse)super.setRecord(dnsSection, dnsRecord);
    }

    @Override
    public DatagramDnsResponse addRecord(DnsSection dnsSection, DnsRecord dnsRecord) {
        return (DatagramDnsResponse)super.addRecord(dnsSection, dnsRecord);
    }

    @Override
    public DatagramDnsResponse addRecord(DnsSection dnsSection, int n, DnsRecord dnsRecord) {
        return (DatagramDnsResponse)super.addRecord(dnsSection, n, dnsRecord);
    }

    @Override
    public DatagramDnsResponse clear(DnsSection dnsSection) {
        return (DatagramDnsResponse)super.clear(dnsSection);
    }

    @Override
    public DatagramDnsResponse clear() {
        return (DatagramDnsResponse)super.clear();
    }

    @Override
    public DatagramDnsResponse touch() {
        return (DatagramDnsResponse)super.touch();
    }

    @Override
    public DatagramDnsResponse touch(Object object) {
        return (DatagramDnsResponse)super.touch(object);
    }

    @Override
    public DatagramDnsResponse retain() {
        return (DatagramDnsResponse)super.retain();
    }

    @Override
    public DatagramDnsResponse retain(int n) {
        return (DatagramDnsResponse)super.retain(n);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof AddressedEnvelope)) {
            return false;
        }
        AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
        if (this.sender() == null ? addressedEnvelope.sender() != null : !this.sender().equals(addressedEnvelope.sender())) {
            return false;
        }
        return !(this.recipient() == null ? addressedEnvelope.recipient() != null : !this.recipient().equals(addressedEnvelope.recipient()));
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        if (this.sender() != null) {
            n = n * 31 + this.sender().hashCode();
        }
        if (this.recipient() != null) {
            n = n * 31 + this.recipient().hashCode();
        }
        return n;
    }
}

