/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.util.Recycler;
import io.netty.util.internal.ObjectUtil;
import java.util.AbstractList;
import java.util.RandomAccess;

final class CodecOutputList
extends AbstractList<Object>
implements RandomAccess {
    private static final Recycler<CodecOutputList> RECYCLER = new Recycler<CodecOutputList>(){

        @Override
        protected CodecOutputList newObject(Recycler.Handle<CodecOutputList> handle) {
            return new CodecOutputList(handle);
        }
    };
    private final Recycler.Handle<CodecOutputList> handle;
    private int size;
    private Object[] array = new Object[16];
    private boolean insertSinceRecycled;

    static CodecOutputList newInstance() {
        return RECYCLER.get();
    }

    private CodecOutputList(Recycler.Handle<CodecOutputList> handle) {
        this.handle = handle;
    }

    @Override
    public Object get(int n) {
        this.checkIndex(n);
        return this.array[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(Object object) {
        ObjectUtil.checkNotNull(object, "element");
        try {
            this.insert(this.size, object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.expandArray();
            this.insert(this.size, object);
        }
        ++this.size;
        return true;
    }

    @Override
    public Object set(int n, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n);
        Object object2 = this.array[n];
        this.insert(n, object);
        return object2;
    }

    @Override
    public void add(int n, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n);
        if (this.size == this.array.length) {
            this.expandArray();
        }
        if (n != this.size - 1) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        }
        this.insert(n, object);
        ++this.size;
    }

    @Override
    public Object remove(int n) {
        this.checkIndex(n);
        Object object = this.array[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.array, n + 1, this.array, n, n2);
        }
        this.array[--this.size] = null;
        return object;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    void recycle() {
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = null;
        }
        this.clear();
        this.insertSinceRecycled = false;
        this.handle.recycle(this);
    }

    Object getUnsafe(int n) {
        return this.array[n];
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void insert(int n, Object object) {
        this.array[n] = object;
        this.insertSinceRecycled = true;
    }

    private void expandArray() {
        int n = this.array.length << 1;
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
        this.array = objectArray;
    }
}

