/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.unix.ErrorsStaticallyReferencedJniMethods;
import io.netty.util.internal.EmptyArrays;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;

public final class Errors {
    public static final int ERRNO_ENOTCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOTCONN();
    public static final int ERRNO_EBADF_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEBADF();
    public static final int ERRNO_EPIPE_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEPIPE();
    public static final int ERRNO_ECONNRESET_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoECONNRESET();
    public static final int ERRNO_EAGAIN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEAGAIN();
    public static final int ERRNO_EWOULDBLOCK_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEWOULDBLOCK();
    public static final int ERRNO_EINPROGRESS_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEINPROGRESS();
    public static final int ERROR_ECONNREFUSED_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorECONNREFUSED();
    private static final String[] ERRORS = new String[512];

    static void throwConnectException(String string, NativeConnectException nativeConnectException, int n) throws ConnectException {
        if (n == nativeConnectException.expectedErr()) {
            throw nativeConnectException;
        }
        throw new ConnectException(string + "() failed: " + ERRORS[-n]);
    }

    public static NativeIoException newConnectionResetException(String string, int n) {
        NativeIoException nativeIoException = Errors.newIOException(string, n);
        nativeIoException.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        return nativeIoException;
    }

    public static NativeIoException newIOException(String string, int n) {
        return new NativeIoException(string + "() failed: " + ERRORS[-n], n);
    }

    public static int ioResult(String string, int n, NativeIoException nativeIoException, ClosedChannelException closedChannelException) throws IOException {
        if (n == ERRNO_EAGAIN_NEGATIVE || n == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (n == nativeIoException.expectedErr()) {
            throw nativeIoException;
        }
        if (n == ERRNO_EBADF_NEGATIVE || n == ERRNO_ENOTCONN_NEGATIVE) {
            throw closedChannelException;
        }
        throw Errors.newIOException(string, n);
    }

    private Errors() {
    }

    static {
        for (int i = 0; i < ERRORS.length; ++i) {
            Errors.ERRORS[i] = ErrorsStaticallyReferencedJniMethods.strError(i);
        }
    }

    static final class NativeConnectException
    extends ConnectException {
        private static final long serialVersionUID = -5532328671712318161L;
        private final int expectedErr;

        NativeConnectException(String string, int n) {
            super(string);
            this.expectedErr = n;
        }

        int expectedErr() {
            return this.expectedErr;
        }
    }

    public static final class NativeIoException
    extends IOException {
        private static final long serialVersionUID = 8222160204268655526L;
        private final int expectedErr;

        public NativeIoException(String string, int n) {
            super(string);
            this.expectedErr = n;
        }

        public int expectedErr() {
            return this.expectedErr;
        }
    }
}

