/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.epoll.IovArray;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.util.concurrent.FastThreadLocal;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

final class NativeDatagramPacketArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final FastThreadLocal<NativeDatagramPacketArray> ARRAY = new FastThreadLocal<NativeDatagramPacketArray>(){

        @Override
        protected NativeDatagramPacketArray initialValue() throws Exception {
            return new NativeDatagramPacketArray();
        }

        @Override
        protected void onRemoval(NativeDatagramPacketArray nativeDatagramPacketArray) throws Exception {
            NativeDatagramPacket[] nativeDatagramPacketArray2 = nativeDatagramPacketArray.packets;
            for (int i = 0; i < nativeDatagramPacketArray2.length; ++i) {
                nativeDatagramPacketArray2[i].release();
            }
        }
    };
    private final NativeDatagramPacket[] packets = new NativeDatagramPacket[Native.UIO_MAX_IOV];
    private int count;

    private NativeDatagramPacketArray() {
        for (int i = 0; i < this.packets.length; ++i) {
            this.packets[i] = new NativeDatagramPacket();
        }
    }

    boolean add(DatagramPacket datagramPacket) {
        if (this.count == this.packets.length) {
            return false;
        }
        ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
        int n = byteBuf.readableBytes();
        if (n == 0) {
            return true;
        }
        NativeDatagramPacket nativeDatagramPacket = this.packets[this.count];
        InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.recipient();
        if (!nativeDatagramPacket.init(byteBuf, inetSocketAddress)) {
            return false;
        }
        ++this.count;
        return true;
    }

    @Override
    public boolean processMessage(Object object) throws Exception {
        return object instanceof DatagramPacket && this.add((DatagramPacket)object);
    }

    int count() {
        return this.count;
    }

    NativeDatagramPacket[] packets() {
        return this.packets;
    }

    static NativeDatagramPacketArray getInstance(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        NativeDatagramPacketArray nativeDatagramPacketArray = ARRAY.get();
        nativeDatagramPacketArray.count = 0;
        channelOutboundBuffer.forEachFlushedMessage(nativeDatagramPacketArray);
        return nativeDatagramPacketArray;
    }

    static final class NativeDatagramPacket {
        private final IovArray array = new IovArray();
        private long memoryAddress;
        private int count;
        private byte[] addr;
        private int scopeId;
        private int port;

        NativeDatagramPacket() {
        }

        private void release() {
            this.array.release();
        }

        private boolean init(ByteBuf byteBuf, InetSocketAddress inetSocketAddress) {
            this.array.clear();
            if (!this.array.add(byteBuf)) {
                return false;
            }
            this.memoryAddress = this.array.memoryAddress(0);
            this.count = this.array.count();
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress instanceof Inet6Address) {
                this.addr = inetAddress.getAddress();
                this.scopeId = ((Inet6Address)inetAddress).getScopeId();
            } else {
                this.addr = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
                this.scopeId = 0;
            }
            this.port = inetSocketAddress.getPort();
            return true;
        }
    }
}

