/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.EpollRecvByteAllocatorStreamingHandle;
import io.netty.channel.epoll.IovArray;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractEpollStreamChannel
extends AbstractEpollChannel
implements DuplexChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ')';
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractEpollStreamChannel.class);
    private static final ClosedChannelException DO_CLOSE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractEpollStreamChannel.class, "doClose()");
    private static final ClosedChannelException CLEAR_SPLICE_QUEUE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractEpollStreamChannel.class, "clearSpliceQueue()");
    private static final ClosedChannelException SPLICE_TO_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractEpollStreamChannel.class, "spliceTo(...)");
    private static final ClosedChannelException FAIL_SPLICE_IF_CLOSED_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractEpollStreamChannel.class, "failSpliceIfClosed(...)");
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private Queue<SpliceInTask> spliceQueue;
    private FileDescriptor pipeIn;
    private FileDescriptor pipeOut;

    @Deprecated
    protected AbstractEpollStreamChannel(Channel channel, int n) {
        this(channel, new Socket(n));
    }

    @Deprecated
    protected AbstractEpollStreamChannel(int n) {
        this(new Socket(n));
    }

    @Deprecated
    protected AbstractEpollStreamChannel(FileDescriptor fileDescriptor) {
        this(new Socket(fileDescriptor.intValue()));
    }

    @Deprecated
    protected AbstractEpollStreamChannel(Socket socket) {
        this(socket, AbstractEpollStreamChannel.isSoErrorZero(socket));
    }

    protected AbstractEpollStreamChannel(Channel channel, Socket socket) {
        super(channel, socket, Native.EPOLLIN, true);
        this.flags |= Native.EPOLLRDHUP;
    }

    protected AbstractEpollStreamChannel(Socket socket, boolean bl) {
        super(null, socket, Native.EPOLLIN, bl);
        this.flags |= Native.EPOLLRDHUP;
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollStreamUnsafe();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    public final ChannelFuture spliceTo(AbstractEpollStreamChannel abstractEpollStreamChannel, int n) {
        return this.spliceTo(abstractEpollStreamChannel, n, this.newPromise());
    }

    public final ChannelFuture spliceTo(AbstractEpollStreamChannel abstractEpollStreamChannel, int n, ChannelPromise channelPromise) {
        if (abstractEpollStreamChannel.eventLoop() != this.eventLoop()) {
            throw new IllegalArgumentException("EventLoops are not the same.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("len: " + n + " (expected: >= 0)");
        }
        if (abstractEpollStreamChannel.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED || this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (!this.isOpen()) {
            channelPromise.tryFailure(SPLICE_TO_CLOSED_CHANNEL_EXCEPTION);
        } else {
            this.addToSpliceQueue(new SpliceInChannelTask(abstractEpollStreamChannel, n, channelPromise));
            this.failSpliceIfClosed(channelPromise);
        }
        return channelPromise;
    }

    public final ChannelFuture spliceTo(FileDescriptor fileDescriptor, int n, int n2) {
        return this.spliceTo(fileDescriptor, n, n2, this.newPromise());
    }

    public final ChannelFuture spliceTo(FileDescriptor fileDescriptor, int n, int n2, ChannelPromise channelPromise) {
        if (n2 < 0) {
            throw new IllegalArgumentException("len: " + n2 + " (expected: >= 0)");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset must be >= 0 but was " + n);
        }
        if (this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (!this.isOpen()) {
            channelPromise.tryFailure(SPLICE_TO_CLOSED_CHANNEL_EXCEPTION);
        } else {
            this.addToSpliceQueue(new SpliceFdTask(fileDescriptor, n, n2, channelPromise));
            this.failSpliceIfClosed(channelPromise);
        }
        return channelPromise;
    }

    private void failSpliceIfClosed(ChannelPromise channelPromise) {
        if (!this.isOpen() && channelPromise.tryFailure(FAIL_SPLICE_IF_CLOSED_CLOSED_CHANNEL_EXCEPTION)) {
            this.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    AbstractEpollStreamChannel.this.clearSpliceQueue();
                }
            });
        }
    }

    private boolean writeBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf byteBuf, int n) throws Exception {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            channelOutboundBuffer.remove();
            return true;
        }
        if (byteBuf.hasMemoryAddress() || byteBuf.nioBufferCount() == 1) {
            int n3 = this.doWriteBytes(byteBuf, n);
            channelOutboundBuffer.removeBytes(n3);
            return n3 == n2;
        }
        ByteBuffer[] byteBufferArray = byteBuf.nioBuffers();
        return this.writeBytesMultiple(channelOutboundBuffer, byteBufferArray, byteBufferArray.length, n2, n);
    }

    private boolean writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, IovArray iovArray, int n) throws IOException {
        long l;
        long l2;
        long l3 = l2 = iovArray.size();
        int n2 = iovArray.count();
        assert (l2 != 0L);
        assert (n2 != 0);
        boolean bl = false;
        int n3 = 0;
        int n4 = n3 + n2;
        for (int i = n - 1; i >= 0 && (l = this.fd().writevAddresses(iovArray.memoryAddress(n3), n2)) != 0L; --i) {
            long l4;
            if ((l2 -= l) == 0L) {
                bl = true;
                break;
            }
            while ((l4 = iovArray.processWritten(n3, l)) != -1L) {
                --n2;
                if (++n3 < n4 && (l -= l4) > 0L) continue;
            }
        }
        channelOutboundBuffer.removeBytes(l3 - l2);
        return bl;
    }

    private boolean writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, ByteBuffer[] byteBufferArray, int n, long l, int n2) throws IOException {
        long l2;
        assert (l != 0L);
        long l3 = l;
        boolean bl = false;
        int n3 = 0;
        int n4 = n3 + n;
        block0: for (int i = n2 - 1; i >= 0 && (l2 = this.fd().writev(byteBufferArray, n3, n)) != 0L; --i) {
            int n5;
            if ((l -= l2) == 0L) {
                bl = true;
                break;
            }
            do {
                ByteBuffer byteBuffer = byteBufferArray[n3];
                int n6 = byteBuffer.position();
                n5 = byteBuffer.limit() - n6;
                if ((long)n5 > l2) {
                    byteBuffer.position(n6 + (int)l2);
                    continue block0;
                }
                --n;
            } while (++n3 < n4 && (l2 -= (long)n5) > 0L);
        }
        channelOutboundBuffer.removeBytes(l3 - l);
        return bl;
    }

    private boolean writeFileRegion(ChannelOutboundBuffer channelOutboundBuffer, DefaultFileRegion defaultFileRegion, int n) throws Exception {
        long l = defaultFileRegion.count();
        if (defaultFileRegion.transferred() >= l) {
            channelOutboundBuffer.remove();
            return true;
        }
        long l2 = defaultFileRegion.position();
        boolean bl = false;
        long l3 = 0L;
        for (int i = n - 1; i >= 0; --i) {
            long l4 = defaultFileRegion.transferred();
            long l5 = Native.sendfile(this.fd().intValue(), defaultFileRegion, l2, l4, l - l4);
            if (l5 == 0L) break;
            l3 += l5;
            if (defaultFileRegion.transfered() < l) continue;
            bl = true;
            break;
        }
        if (l3 > 0L) {
            channelOutboundBuffer.progress(l3);
        }
        if (bl) {
            channelOutboundBuffer.remove();
        }
        return bl;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        int n;
        int n2 = this.config().getWriteSpinCount();
        do {
            if ((n = channelOutboundBuffer.size()) != 0) continue;
            this.clearFlag(Native.EPOLLOUT);
            return;
        } while (!(n > 1 && channelOutboundBuffer.current() instanceof ByteBuf ? !this.doWriteMultiple(channelOutboundBuffer, n2) : !this.doWriteSingle(channelOutboundBuffer, n2)));
        this.setFlag(Native.EPOLLOUT);
    }

    protected boolean doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer, int n) throws Exception {
        Object object = channelOutboundBuffer.current();
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (!this.writeBytes(channelOutboundBuffer, byteBuf, n)) {
                return false;
            }
        } else if (object instanceof DefaultFileRegion) {
            DefaultFileRegion defaultFileRegion = (DefaultFileRegion)object;
            if (!this.writeFileRegion(channelOutboundBuffer, defaultFileRegion, n)) {
                return false;
            }
        } else if (object instanceof SpliceOutTask) {
            if (!((SpliceOutTask)object).spliceOut()) {
                return false;
            }
            channelOutboundBuffer.remove();
        } else {
            throw new Error();
        }
        return true;
    }

    private boolean doWriteMultiple(ChannelOutboundBuffer channelOutboundBuffer, int n) throws Exception {
        if (PlatformDependent.hasUnsafe()) {
            IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanArray();
            channelOutboundBuffer.forEachFlushedMessage(iovArray);
            int n2 = iovArray.count();
            if (n2 >= 1) {
                if (!this.writeBytesMultiple(channelOutboundBuffer, iovArray, n)) {
                    return false;
                }
            } else {
                channelOutboundBuffer.removeBytes(0L);
            }
        } else {
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers();
            int n3 = channelOutboundBuffer.nioBufferCount();
            if (n3 >= 1) {
                if (!this.writeBytesMultiple(channelOutboundBuffer, byteBufferArray, n3, channelOutboundBuffer.nioBufferSize(), n)) {
                    return false;
                }
            } else {
                channelOutboundBuffer.removeBytes(0L);
            }
        }
        return true;
    }

    @Override
    protected Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (!(byteBuf.hasMemoryAddress() || !PlatformDependent.hasUnsafe() && byteBuf.isDirect())) {
                if (byteBuf instanceof CompositeByteBuf) {
                    CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
                    if (!compositeByteBuf.isDirect() || compositeByteBuf.nioBufferCount() > Native.IOV_MAX) {
                        byteBuf = this.newDirectBuffer(byteBuf);
                        assert (byteBuf.hasMemoryAddress());
                    }
                } else {
                    byteBuf = this.newDirectBuffer(byteBuf);
                    assert (byteBuf.hasMemoryAddress());
                }
            }
            return byteBuf;
        }
        if (object instanceof DefaultFileRegion || object instanceof SpliceOutTask) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    private void shutdownOutput0(ChannelPromise channelPromise) {
        try {
            this.fd().shutdown(false, true);
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.fd().shutdown(true, false);
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    private void shutdown0(ChannelPromise channelPromise) {
        try {
            this.fd().shutdown(true, true);
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this.fd().isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this.fd().isInputShutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.fd().isShutdown();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise channelPromise) {
        Executor executor = ((EpollStreamUnsafe)this.unsafe()).prepareToClose();
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractEpollStreamChannel.this.shutdownOutput0(channelPromise);
                }
            });
        } else {
            EventLoop eventLoop = this.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.shutdownOutput0(channelPromise);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEpollStreamChannel.this.shutdownOutput0(channelPromise);
                    }
                });
            }
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownInput(final ChannelPromise channelPromise) {
        Executor executor = ((EpollStreamUnsafe)this.unsafe()).prepareToClose();
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractEpollStreamChannel.this.shutdownInput0(channelPromise);
                }
            });
        } else {
            EventLoop eventLoop = this.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.shutdownInput0(channelPromise);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEpollStreamChannel.this.shutdownInput0(channelPromise);
                    }
                });
            }
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown(final ChannelPromise channelPromise) {
        Executor executor = ((EpollStreamUnsafe)this.unsafe()).prepareToClose();
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractEpollStreamChannel.this.shutdown0(channelPromise);
                }
            });
        } else {
            EventLoop eventLoop = this.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.shutdown0(channelPromise);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEpollStreamChannel.this.shutdown0(channelPromise);
                    }
                });
            }
        }
        return channelPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        try {
            ScheduledFuture<?> scheduledFuture;
            ChannelPromise channelPromise = this.connectPromise;
            if (channelPromise != null) {
                channelPromise.tryFailure(DO_CLOSE_CLOSED_CHANNEL_EXCEPTION);
                this.connectPromise = null;
            }
            if ((scheduledFuture = this.connectTimeoutFuture) != null) {
                scheduledFuture.cancel(false);
                this.connectTimeoutFuture = null;
            }
            super.doClose();
        }
        finally {
            AbstractEpollStreamChannel.safeClosePipe(this.pipeIn);
            AbstractEpollStreamChannel.safeClosePipe(this.pipeOut);
            this.clearSpliceQueue();
        }
    }

    private void clearSpliceQueue() {
        SpliceInTask spliceInTask;
        if (this.spliceQueue == null) {
            return;
        }
        while ((spliceInTask = this.spliceQueue.poll()) != null) {
            spliceInTask.promise.tryFailure(CLEAR_SPLICE_QUEUE_CLOSED_CHANNEL_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) throws Exception {
        if (socketAddress2 != null) {
            this.fd().bind(socketAddress2);
        }
        boolean bl = false;
        try {
            boolean bl2 = this.fd().connect(socketAddress);
            if (!bl2) {
                this.setFlag(Native.EPOLLOUT);
            }
            bl = true;
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            if (!bl) {
                this.doClose();
            }
        }
    }

    private static void safeClosePipe(FileDescriptor fileDescriptor) {
        block3: {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                }
                catch (IOException iOException) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("Error while closing a pipe", iOException);
                }
            }
        }
    }

    private void addToSpliceQueue(final SpliceInTask spliceInTask) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.addToSpliceQueue0(spliceInTask);
        } else {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractEpollStreamChannel.this.addToSpliceQueue0(spliceInTask);
                }
            });
        }
    }

    private void addToSpliceQueue0(SpliceInTask spliceInTask) {
        if (this.spliceQueue == null) {
            this.spliceQueue = PlatformDependent.newMpscQueue();
        }
        this.spliceQueue.add(spliceInTask);
    }

    private final class SpliceFdTask
    extends SpliceInTask {
        private final FileDescriptor fd;
        private final ChannelPromise promise;
        private final int offset;

        SpliceFdTask(FileDescriptor fileDescriptor, int n, int n2, ChannelPromise channelPromise) {
            super(n2, channelPromise);
            this.fd = fileDescriptor;
            this.promise = channelPromise;
            this.offset = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean spliceIn(RecvByteBufAllocator.Handle handle) {
            assert (AbstractEpollStreamChannel.this.eventLoop().inEventLoop());
            if (this.len == 0) {
                this.promise.setSuccess();
                return true;
            }
            try {
                FileDescriptor[] fileDescriptorArray = FileDescriptor.pipe();
                FileDescriptor fileDescriptor2 = fileDescriptorArray[0];
                FileDescriptor fileDescriptor = fileDescriptorArray[1];
                try {
                    int n;
                    int n2 = this.spliceIn(fileDescriptor, handle);
                    if (n2 > 0) {
                        if (this.len != Integer.MAX_VALUE) {
                            this.len -= n2;
                        }
                        while ((n2 -= (n = Native.splice(fileDescriptor2.intValue(), -1L, this.fd.intValue(), this.offset, n2))) > 0) {
                        }
                        if (this.len == 0) {
                            this.promise.setSuccess();
                            n = 1;
                            return n != 0;
                        }
                    }
                    n = 0;
                    return n != 0;
                }
                finally {
                    AbstractEpollStreamChannel.safeClosePipe(fileDescriptor2);
                    AbstractEpollStreamChannel.safeClosePipe(fileDescriptor);
                }
            }
            catch (Throwable throwable2) {
                this.promise.setFailure(throwable2);
                return true;
            }
        }
    }

    private final class SpliceOutTask {
        private final AbstractEpollStreamChannel ch;
        private final boolean autoRead;
        private int len;

        SpliceOutTask(AbstractEpollStreamChannel abstractEpollStreamChannel2, int n, boolean bl) {
            this.ch = abstractEpollStreamChannel2;
            this.len = n;
            this.autoRead = bl;
        }

        public boolean spliceOut() throws Exception {
            assert (this.ch.eventLoop().inEventLoop());
            try {
                int n = Native.splice(this.ch.pipeIn.intValue(), -1L, this.ch.fd().intValue(), -1L, this.len);
                this.len -= n;
                if (this.len == 0) {
                    if (this.autoRead) {
                        AbstractEpollStreamChannel.this.config().setAutoRead(true);
                    }
                    return true;
                }
                return false;
            }
            catch (IOException iOException) {
                if (this.autoRead) {
                    AbstractEpollStreamChannel.this.config().setAutoRead(true);
                }
                throw iOException;
            }
        }
    }

    private final class SpliceInChannelTask
    extends SpliceInTask
    implements ChannelFutureListener {
        private final AbstractEpollStreamChannel ch;

        SpliceInChannelTask(AbstractEpollStreamChannel abstractEpollStreamChannel2, int n, ChannelPromise channelPromise) {
            super(n, channelPromise);
            this.ch = abstractEpollStreamChannel2;
        }

        @Override
        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            if (!channelFuture.isSuccess()) {
                this.promise.setFailure(channelFuture.cause());
            }
        }

        @Override
        public boolean spliceIn(RecvByteBufAllocator.Handle handle) {
            assert (this.ch.eventLoop().inEventLoop());
            if (this.len == 0) {
                this.promise.setSuccess();
                return true;
            }
            try {
                int n;
                FileDescriptor fileDescriptor = this.ch.pipeOut;
                if (fileDescriptor == null) {
                    FileDescriptor[] fileDescriptorArray = FileDescriptor.pipe();
                    this.ch.pipeIn = fileDescriptorArray[0];
                    fileDescriptor = this.ch.pipeOut = fileDescriptorArray[1];
                }
                if ((n = this.spliceIn(fileDescriptor, handle)) > 0) {
                    if (this.len != Integer.MAX_VALUE) {
                        this.len -= n;
                    }
                    ChannelPromise channelPromise = this.len == 0 ? this.promise : this.ch.newPromise().addListener(this);
                    boolean bl = AbstractEpollStreamChannel.this.config().isAutoRead();
                    this.ch.unsafe().write(new SpliceOutTask(this.ch, n, bl), channelPromise);
                    this.ch.unsafe().flush();
                    if (bl && !channelPromise.isDone()) {
                        AbstractEpollStreamChannel.this.config().setAutoRead(false);
                    }
                }
                return this.len == 0;
            }
            catch (Throwable throwable) {
                this.promise.setFailure(throwable);
                return true;
            }
        }
    }

    protected abstract class SpliceInTask {
        final ChannelPromise promise;
        int len;

        protected SpliceInTask(int n, ChannelPromise channelPromise) {
            this.promise = channelPromise;
            this.len = n;
        }

        abstract boolean spliceIn(RecvByteBufAllocator.Handle var1);

        protected final int spliceIn(FileDescriptor fileDescriptor, RecvByteBufAllocator.Handle handle) throws IOException {
            int n;
            int n2 = Math.min(handle.guess(), this.len);
            int n3 = 0;
            while ((n = Native.splice(AbstractEpollStreamChannel.this.fd().intValue(), -1L, fileDescriptor.intValue(), -1L, n2)) != 0) {
                n3 += n;
                n2 -= n;
            }
            return n3;
        }
    }

    class EpollStreamUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        EpollStreamUnsafe() {
        }

        @Override
        protected Executor prepareToClose() {
            return super.prepareToClose();
        }

        private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl, EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            epollRecvByteAllocatorHandle.readComplete();
            channelPipeline.fireChannelReadComplete();
            channelPipeline.fireExceptionCaught(throwable);
            if (bl || throwable instanceof IOException) {
                this.shutdownInput();
            }
        }

        @Override
        public void connect(final SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            try {
                if (AbstractEpollStreamChannel.this.connectPromise != null) {
                    throw new IllegalStateException("connection attempt already made");
                }
                boolean bl = AbstractEpollStreamChannel.this.isActive();
                if (AbstractEpollStreamChannel.this.doConnect(socketAddress, socketAddress2)) {
                    this.fulfillConnectPromise(channelPromise, bl);
                } else {
                    AbstractEpollStreamChannel.this.connectPromise = channelPromise;
                    AbstractEpollStreamChannel.this.requestedRemoteAddress = socketAddress;
                    int n = AbstractEpollStreamChannel.this.config().getConnectTimeoutMillis();
                    if (n > 0) {
                        AbstractEpollStreamChannel.this.connectTimeoutFuture = AbstractEpollStreamChannel.this.eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ChannelPromise channelPromise = AbstractEpollStreamChannel.this.connectPromise;
                                ConnectTimeoutException connectTimeoutException = new ConnectTimeoutException("connection timed out: " + socketAddress);
                                if (channelPromise != null && channelPromise.tryFailure(connectTimeoutException)) {
                                    EpollStreamUnsafe.this.close(EpollStreamUnsafe.this.voidPromise());
                                }
                            }
                        }, (long)n, TimeUnit.MILLISECONDS);
                    }
                    channelPromise.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            if (channelFuture.isCancelled()) {
                                if (AbstractEpollStreamChannel.this.connectTimeoutFuture != null) {
                                    AbstractEpollStreamChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractEpollStreamChannel.this.connectPromise = null;
                                EpollStreamUnsafe.this.close(EpollStreamUnsafe.this.voidPromise());
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                this.closeIfClosed();
                channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl) {
            if (channelPromise == null) {
                return;
            }
            AbstractEpollStreamChannel.this.active = true;
            boolean bl2 = channelPromise.trySuccess();
            if (!bl && AbstractEpollStreamChannel.this.isActive()) {
                AbstractEpollStreamChannel.this.pipeline().fireChannelActive();
            }
            if (!bl2) {
                this.close(this.voidPromise());
            }
        }

        private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
            if (channelPromise == null) {
                return;
            }
            channelPromise.tryFailure(throwable);
            this.closeIfClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishConnect() {
            assert (AbstractEpollStreamChannel.this.eventLoop().inEventLoop());
            boolean bl = false;
            try {
                boolean bl2 = AbstractEpollStreamChannel.this.isActive();
                if (!this.doFinishConnect()) {
                    bl = true;
                    return;
                }
                this.fulfillConnectPromise(AbstractEpollStreamChannel.this.connectPromise, bl2);
            }
            catch (Throwable throwable) {
                this.fulfillConnectPromise(AbstractEpollStreamChannel.this.connectPromise, this.annotateConnectException(throwable, AbstractEpollStreamChannel.this.requestedRemoteAddress));
            }
            finally {
                if (!bl) {
                    if (AbstractEpollStreamChannel.this.connectTimeoutFuture != null) {
                        AbstractEpollStreamChannel.this.connectTimeoutFuture.cancel(false);
                    }
                    AbstractEpollStreamChannel.this.connectPromise = null;
                }
            }
        }

        @Override
        void epollOutReady() {
            if (AbstractEpollStreamChannel.this.connectPromise != null) {
                this.finishConnect();
            } else {
                super.epollOutReady();
            }
        }

        boolean doFinishConnect() throws Exception {
            if (AbstractEpollStreamChannel.this.fd().finishConnect()) {
                AbstractEpollStreamChannel.this.clearFlag(Native.EPOLLOUT);
                return true;
            }
            AbstractEpollStreamChannel.this.setFlag(Native.EPOLLOUT);
            return false;
        }

        @Override
        EpollRecvByteAllocatorHandle newEpollHandle(RecvByteBufAllocator.Handle handle) {
            return new EpollRecvByteAllocatorStreamingHandle(handle, AbstractEpollStreamChannel.this.config());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            if (AbstractEpollStreamChannel.this.fd().isInputShutdown()) {
                this.clearEpollIn0();
                return;
            }
            EpollChannelConfig epollChannelConfig = AbstractEpollStreamChannel.this.config();
            EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
            epollRecvByteAllocatorHandle.edgeTriggered(AbstractEpollStreamChannel.this.isFlagSet(Native.EPOLLET));
            ChannelPipeline channelPipeline = AbstractEpollStreamChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = epollChannelConfig.getAllocator();
            epollRecvByteAllocatorHandle.reset(epollChannelConfig);
            this.epollInBefore();
            ByteBuf byteBuf = null;
            boolean bl = false;
            try {
                do {
                    SpliceInTask spliceInTask;
                    if (AbstractEpollStreamChannel.this.spliceQueue != null && (spliceInTask = (SpliceInTask)AbstractEpollStreamChannel.this.spliceQueue.peek()) != null) {
                        if (!spliceInTask.spliceIn(epollRecvByteAllocatorHandle)) break;
                        if (!AbstractEpollStreamChannel.this.isActive()) continue;
                        AbstractEpollStreamChannel.this.spliceQueue.remove();
                        continue;
                    }
                    byteBuf = epollRecvByteAllocatorHandle.allocate(byteBufAllocator);
                    epollRecvByteAllocatorHandle.lastBytesRead(AbstractEpollStreamChannel.this.doReadBytes(byteBuf));
                    if (epollRecvByteAllocatorHandle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        bl = epollRecvByteAllocatorHandle.lastBytesRead() < 0;
                        break;
                    }
                    epollRecvByteAllocatorHandle.incMessagesRead(1);
                    this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                    byteBuf = null;
                    if (AbstractEpollStreamChannel.this.fd().isInputShutdown()) break;
                } while (epollRecvByteAllocatorHandle.continueReading());
                epollRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (bl) {
                    this.shutdownInput();
                }
            }
            catch (Throwable throwable) {
                this.handleReadException(channelPipeline, byteBuf, throwable, bl, epollRecvByteAllocatorHandle);
            }
            finally {
                this.epollInFinally(epollChannelConfig);
            }
        }
    }
}

