/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.WrappedCompositeByteBuf;
import io.netty.util.ResourceLeak;
import java.nio.ByteOrder;

final class SimpleLeakAwareCompositeByteBuf
extends WrappedCompositeByteBuf {
    private final ResourceLeak leak;

    SimpleLeakAwareCompositeByteBuf(CompositeByteBuf compositeByteBuf, ResourceLeak resourceLeak) {
        super(compositeByteBuf);
        this.leak = resourceLeak;
    }

    @Override
    public boolean release() {
        boolean bl = super.release();
        if (bl) {
            this.leak.close();
        }
        return bl;
    }

    @Override
    public boolean release(int n) {
        boolean bl = super.release(n);
        if (bl) {
            this.leak.close();
        }
        return bl;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        this.leak.record();
        if (this.order() == byteOrder) {
            return this;
        }
        return new SimpleLeakAwareByteBuf(super.order(byteOrder), this.leak);
    }

    @Override
    public ByteBuf slice() {
        return new SimpleLeakAwareByteBuf(super.slice(), this.leak);
    }

    @Override
    public ByteBuf retainedSlice() {
        return new SimpleLeakAwareByteBuf(super.retainedSlice(), this.leak);
    }

    @Override
    public ByteBuf slice(int n, int n2) {
        return new SimpleLeakAwareByteBuf(super.slice(n, n2), this.leak);
    }

    @Override
    public ByteBuf retainedSlice(int n, int n2) {
        return new SimpleLeakAwareByteBuf(super.retainedSlice(n, n2), this.leak);
    }

    @Override
    public ByteBuf duplicate() {
        return new SimpleLeakAwareByteBuf(super.duplicate(), this.leak);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return new SimpleLeakAwareByteBuf(super.retainedDuplicate(), this.leak);
    }

    @Override
    public ByteBuf readSlice(int n) {
        return new SimpleLeakAwareByteBuf(super.readSlice(n), this.leak);
    }

    @Override
    public ByteBuf readRetainedSlice(int n) {
        return new SimpleLeakAwareByteBuf(super.readRetainedSlice(n), this.leak);
    }

    @Override
    public ByteBuf asReadOnly() {
        return new SimpleLeakAwareByteBuf(super.asReadOnly(), this.leak);
    }
}

