/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.BootstrapConfig;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.util.AbstractConstant;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;

public class Bootstrap
extends AbstractBootstrap<Bootstrap, Channel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private static final AddressResolverGroup<?> DEFAULT_RESOLVER = DefaultAddressResolverGroup.INSTANCE;
    private final BootstrapConfig config = new BootstrapConfig(this);
    private volatile AddressResolverGroup<SocketAddress> resolver = DEFAULT_RESOLVER;
    private volatile SocketAddress remoteAddress;

    public Bootstrap() {
    }

    private Bootstrap(Bootstrap bootstrap) {
        super(bootstrap);
        this.resolver = bootstrap.resolver;
        this.remoteAddress = bootstrap.remoteAddress;
    }

    public Bootstrap resolver(AddressResolverGroup<?> addressResolverGroup) {
        this.resolver = addressResolverGroup == null ? DEFAULT_RESOLVER : addressResolverGroup;
        return this;
    }

    public Bootstrap remoteAddress(SocketAddress socketAddress) {
        this.remoteAddress = socketAddress;
        return this;
    }

    public Bootstrap remoteAddress(String string, int n) {
        this.remoteAddress = InetSocketAddress.createUnresolved(string, n);
        return this;
    }

    public Bootstrap remoteAddress(InetAddress inetAddress, int n) {
        this.remoteAddress = new InetSocketAddress(inetAddress, n);
        return this;
    }

    public ChannelFuture connect() {
        this.validate();
        SocketAddress socketAddress = this.remoteAddress;
        if (socketAddress == null) {
            throw new IllegalStateException("remoteAddress not set");
        }
        return this.doResolveAndConnect(socketAddress, this.config.localAddress());
    }

    public ChannelFuture connect(String string, int n) {
        return this.connect(InetSocketAddress.createUnresolved(string, n));
    }

    public ChannelFuture connect(InetAddress inetAddress, int n) {
        return this.connect(new InetSocketAddress(inetAddress, n));
    }

    public ChannelFuture connect(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.validate();
        return this.doResolveAndConnect(socketAddress, this.config.localAddress());
    }

    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.validate();
        return this.doResolveAndConnect(socketAddress, socketAddress2);
    }

    private ChannelFuture doResolveAndConnect(final SocketAddress socketAddress, final SocketAddress socketAddress2) {
        ChannelFuture channelFuture = this.initAndRegister();
        final Channel channel = channelFuture.channel();
        if (channelFuture.isDone()) {
            if (!channelFuture.isSuccess()) {
                return channelFuture;
            }
            return this.doResolveAndConnect0(channel, socketAddress, socketAddress2, channel.newPromise());
        }
        final AbstractBootstrap.PendingRegistrationPromise pendingRegistrationPromise = new AbstractBootstrap.PendingRegistrationPromise(channel);
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                Throwable throwable = channelFuture.cause();
                if (throwable != null) {
                    pendingRegistrationPromise.setFailure(throwable);
                } else {
                    pendingRegistrationPromise.registered();
                    Bootstrap.this.doResolveAndConnect0(channel, socketAddress, socketAddress2, pendingRegistrationPromise);
                }
            }
        });
        return pendingRegistrationPromise;
    }

    private ChannelFuture doResolveAndConnect0(final Channel channel, SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        try {
            EventLoop eventLoop = channel.eventLoop();
            AddressResolver<SocketAddress> addressResolver = this.resolver.getResolver(eventLoop);
            if (!addressResolver.isSupported(socketAddress) || addressResolver.isResolved(socketAddress)) {
                Bootstrap.doConnect(socketAddress, socketAddress2, channelPromise);
                return channelPromise;
            }
            Future<SocketAddress> future = addressResolver.resolve(socketAddress);
            if (future.isDone()) {
                Throwable throwable = future.cause();
                if (throwable != null) {
                    channel.close();
                    channelPromise.setFailure(throwable);
                } else {
                    Bootstrap.doConnect(future.getNow(), socketAddress2, channelPromise);
                }
                return channelPromise;
            }
            future.addListener((GenericFutureListener<Future<SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) throws Exception {
                    if (future.cause() != null) {
                        channel.close();
                        channelPromise.setFailure(future.cause());
                    } else {
                        Bootstrap.doConnect(future.getNow(), socketAddress2, channelPromise);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
        }
        return channelPromise;
    }

    private static void doConnect(final SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        final Channel channel = channelPromise.channel();
        channel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                if (socketAddress2 == null) {
                    channel.connect(socketAddress, channelPromise);
                } else {
                    channel.connect(socketAddress, socketAddress2, channelPromise);
                }
                channelPromise.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void init(Channel channel) throws Exception {
        ChannelPipeline channelPipeline = channel.pipeline();
        channelPipeline.addLast(this.config.handler());
        Map<ChannelOption<?>, Object> map = this.options0();
        Map<AbstractConstant, Object> map2 = map;
        synchronized (map2) {
            for (Map.Entry<ChannelOption<?>, Object> object : map.entrySet()) {
                try {
                    if (channel.config().setOption(object.getKey(), object.getValue())) continue;
                    logger.warn("Unknown channel option: " + object);
                }
                catch (Throwable entry) {
                    logger.warn("Failed to set a channel option: " + channel, entry);
                }
            }
        }
        map2 = this.attrs0();
        Map<AbstractConstant, Object> map3 = map2;
        synchronized (map3) {
            for (Map.Entry<AbstractConstant, Object> entry : map2.entrySet()) {
                channel.attr((AttributeKey)entry.getKey()).set(entry.getValue());
            }
        }
    }

    @Override
    public Bootstrap validate() {
        super.validate();
        if (this.config.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
        return this;
    }

    @Override
    public Bootstrap clone() {
        return new Bootstrap(this);
    }

    public Bootstrap clone(EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = new Bootstrap(this);
        bootstrap.group = eventLoopGroup;
        return bootstrap;
    }

    public final BootstrapConfig config() {
        return this.config;
    }

    final SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    final AddressResolverGroup<?> resolver() {
        return this.resolver;
    }
}

