/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.scc.dei.ecplean;

import edu.kit.scc.dei.ecplean.ECPAuthState;
import edu.kit.scc.dei.ecplean.ECPAuthenticationException;
import edu.kit.scc.dei.ecplean.ECPAuthenticationInfo;
import edu.kit.scc.dei.ecplean.ECPAuthenticatorBase;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import org.apache.http.impl.client.HttpClientBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ECPIdPAuth
extends ECPAuthenticatorBase {
    public ECPIdPAuth(String string, String string2, URI uRI) {
        this(HttpClientBuilder.create(), string, string2, uRI);
    }

    public ECPIdPAuth(HttpClientBuilder httpClientBuilder, String string, String string2, URI uRI) {
        super(httpClientBuilder);
        this.authInfo = new ECPAuthenticationInfo(string, string2, uRI, null, null, null);
        this.authInfo.setAuthState(ECPAuthState.NOT_STARTED);
    }

    public String authenticate(String string) throws ECPAuthenticationException {
        String string2;
        String string3;
        Document document;
        try {
            document = this.buildDocumentFromString(string);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            LOG.fine("Parsing SP Request failed");
            throw new ECPAuthenticationException(exception);
        }
        try {
            string3 = (String)this.queryDocument(document, "//ecp:RelayState", XPathConstants.STRING);
        }
        catch (XPathException xPathException) {
            LOG.fine("Could not find relay state in PAOS answer from SP");
            throw new ECPAuthenticationException(xPathException);
        }
        LOG.info("Got relayState: " + string3);
        try {
            string2 = (String)this.queryDocument(document, "/S:Envelope/S:Header/paos:Request/@responseConsumerURL", XPathConstants.STRING);
        }
        catch (XPathException xPathException) {
            LOG.fine("Could not find response consumer url in PAOS answer from SP");
            throw new ECPAuthenticationException(xPathException);
        }
        LOG.info("Got responseConsumerUrl: " + string2);
        Node node = document.getDocumentElement().getFirstChild();
        document.getDocumentElement().removeChild(node);
        Document document2 = this.authenticateIdP(document);
        document2.getDocumentElement().getFirstChild().getFirstChild().setTextContent(string3);
        try {
            return this.documentToString(document2);
        }
        catch (TransformerException transformerException) {
            LOG.fine("documentToString failed");
            throw new ECPAuthenticationException(transformerException);
        }
    }
}

