/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.update;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamCallback;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.update.UpdateSetting;
import de.dal33t.powerfolder.util.update.UpdaterEvent;
import de.dal33t.powerfolder.util.update.UpdaterHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Updater
extends Thread {
    private static Logger LOG = Logger.getLogger(Updater.class.getName());
    protected Controller controller;
    protected UpdateSetting settings;
    private UpdaterHandler handler;

    public Updater(Controller controller, UpdaterHandler updaterHandler) {
        this(controller, controller.getUpdateSettings(), updaterHandler);
    }

    public Updater(Controller controller, UpdateSetting updateSetting, UpdaterHandler updaterHandler) {
        super("Update checker");
        Reject.ifNull(controller, "Controller is null");
        Reject.ifNull(updateSetting, "Settings are null");
        Reject.ifNull(updaterHandler, "Handler is null");
        this.controller = controller;
        this.settings = updateSetting;
        this.handler = updaterHandler;
    }

    @Override
    public void run() {
        this.checkForNewRelease();
    }

    public static void installPeriodicalUpdateCheck(final Controller controller, final UpdaterHandler updaterHandler) {
        Reject.ifNull(controller, "Controller is null");
        if (!ConfigurationEntry.ENABLE_UPDATE.getValueBoolean(controller).booleanValue()) {
            return;
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                new Updater(controller, updaterHandler).start();
            }
        };
        controller.scheduleAndRepeat(timerTask, 15000L, 3600000L);
    }

    private void checkForNewRelease() {
        LOG.fine("Checking for newer version");
        if (!this.handler.shouldCheckForNewVersion()) {
            return;
        }
        String string = this.newerReleaseVersionAvailable();
        if (string != null) {
            this.handler.newReleaseAvailable(new UpdaterEvent(this, string, this.getReleaseExeURL()));
        } else {
            this.handler.noNewReleaseAvailable(new UpdaterEvent(this));
        }
    }

    public Process downloadAndUpdate(URL uRL, StreamCallback streamCallback, boolean bl) {
        Path path = this.download(uRL, streamCallback);
        if (path == null) {
            return null;
        }
        try {
            if (!this.verifySignatureWithPowerShell(path)) {
                Files.delete(path);
                LOG.warning("Signature not existing on " + path + ". The file has been deleted.");
                return null;
            }
        }
        catch (Exception exception) {
            LOG.warning("Signature not existing on " + path + ". " + exception);
            return null;
        }
        return this.openReleaseExe(path, bl);
    }

    private boolean verifySignatureWithPowerShell(Path path) throws IOException, InterruptedException {
        String string = String.format("powershell.exe -Command \"& { $signature = Get-AuthenticodeSignature -FilePath '%s'; if ($signature.Status -eq 'Valid') { Write-Output 'Valid'; } elseif ($signature.Status -eq 'UnknownError' -and $signature.StatusMessage -match '(certificate|zeitstempel|timestamp)') { Write-Output 'Valid-Ignoring-Timestamp'; } else { Write-Output 'Invalid'; }; }\"", path.toString().replace("\\", "\\\\"));
        ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", string);
        Process process = processBuilder.start();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
             BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                LOG.fine(string2);
                if (!string2.contains("Valid") && !string2.contains("Valid-Ignoring-Timestamp")) continue;
                boolean bl = true;
                return bl;
            }
            while ((string2 = bufferedReader2.readLine()) != null) {
                LOG.warning("Error: " + string2);
            }
        }
        int n = process.waitFor();
        if (n != 0) {
            LOG.warning("PowerShell script failed with exit code " + n);
        }
        return false;
    }

    public Path download(URL uRL, StreamCallback streamCallback) {
        URLConnection uRLConnection;
        String string = uRL.getFile();
        if (StringUtils.isBlank(string)) {
            string = "PowerFolder_Latest_Win32_Installer.exe";
        }
        if (string.contains("/")) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        Path path = Controller.getTempFilesLocation().resolve(string);
        try {
            uRLConnection = uRL.openConnection();
            uRLConnection.connect();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to download from " + uRL, iOException);
            return null;
        }
        LOG.log(Level.INFO, "Downloading latest version from " + uRLConnection.getURL());
        Path path2 = path.getParent().resolve("(downloading) " + path.getFileName().toString());
        try {
            uRLConnection.connect();
            PathUtils.copyFromStreamToFile(uRLConnection.getInputStream(), path2, streamCallback, uRLConnection.getContentLength());
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Unable to download from " + uRL, iOException);
            return null;
        }
        try {
            Files.deleteIfExists(path);
            Files.move(path2, path, new CopyOption[0]);
            Files.setLastModifiedTime(path, FileTime.fromMillis(uRLConnection.getLastModified()));
            if (path.getFileName().toString().toLowerCase().endsWith("jar") && !PathUtils.isValidZipFile(path)) {
                Files.delete(path);
                return null;
            }
        }
        catch (IOException iOException) {
            LOG.warning("Unable to download auto update: " + iOException);
            return null;
        }
        return path;
    }

    private String newerReleaseVersionAvailable() {
        String string = this.latestReleaseVersionAvailable();
        if (string == null) {
            LOG.warning("Unable to retrieve latest version from " + this.settings.versionCheckURL);
            return null;
        }
        if (Util.compareVersions(string, "23.3.100")) {
            LOG.info("Latest available version (" + string + ") is newer than this version (23.3.100)");
            return string;
        }
        LOG.fine("This version is up-to-date (23.3.100)");
        return null;
    }

    public String latestReleaseVersionAvailable() {
        URL uRL;
        try {
            uRL = new URL(this.settings.versionCheckURL);
        }
        catch (MalformedURLException malformedURLException) {
            LOG.log(Level.FINER, malformedURLException.toString(), malformedURLException);
            return null;
        }
        try {
            int n;
            InputStream inputStream = (InputStream)uRL.getContent();
            Object object = "";
            while ((n = inputStream.read()) >= 0) {
                object = (String)object + (char)n;
            }
            if (object != null) {
                if (((String)(object = ((String)object).trim())).length() > 50) {
                    LOG.log(Level.WARNING, "Received illegal response while checking latest available version from " + this.settings.versionCheckURL + ": " + (String)object);
                    return null;
                }
                LOG.fine("Latest available version: " + (String)object + " @ " + this.settings.versionCheckURL);
                return object;
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Unable to retrieve latest available version for: " + this.settings.versionCheckURL + ". " + iOException);
            LOG.log(Level.FINER, iOException.toString(), iOException);
        }
        return null;
    }

    private URL getReleaseExeURL() {
        URL uRL = null;
        try {
            if (StringUtils.isNotBlank(this.settings.downloadLinkInfoURL)) {
                URL uRL2 = new URL(this.settings.downloadLinkInfoURL);
                InputStream inputStream = (InputStream)uRL2.getContent();
                StringBuilder stringBuilder = new StringBuilder();
                while (inputStream.available() > 0) {
                    stringBuilder.append((char)inputStream.read());
                }
                inputStream.close();
                uRL = new URL(stringBuilder.toString());
                LOG.info("Latest available version download: " + uRL.toExternalForm());
            }
        }
        catch (MalformedURLException malformedURLException) {
            LOG.log(Level.FINER, malformedURLException.toString(), malformedURLException);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINER, iOException.toString(), iOException);
        }
        if (uRL == null) {
            try {
                uRL = new URL(this.settings.windowsExeURL);
            }
            catch (MalformedURLException malformedURLException) {
                LOG.log(Level.SEVERE, "Invalid release exec download location", malformedURLException);
            }
        }
        return uRL;
    }

    private Process openReleaseExe(Path path, boolean bl) {
        try {
            Object object = "cmd.exe";
            object = (String)object + " /c ";
            object = (String)object + "\"";
            object = (String)object + path.toAbsolutePath().toString();
            if (bl) {
                object = (String)object + " /S";
            }
            object = (String)object + "\"";
            LOG.info("Executing: " + (String)object);
            return Runtime.getRuntime().exec((String)object);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to start update exe at " + path.toAbsolutePath() + ". " + iOException, iOException);
            return null;
        }
    }
}

