/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.os.Win32;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.logging.Loggable;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.ShellLink;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Logger;

public class WinUtils
extends Loggable {
    private static final Logger LOG = Logger.getLogger(WinUtils.class.getName());
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String DESKTOP_FOLDER_CMD = "reg query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v DESKTOP";
    private static final String MSI_MARKER_FILE = "MSI_INSTALLATION.txt";
    public static final int CSIDL_COMMON_STARTUP = 24;
    public static final int CSIDL_STARTUP = 7;
    public static final int CSIDL_DESKTOP = 0;
    public static final int CSIDL_PERSONAL = 5;
    public static final int CSIDL_FAVORITES = 6;
    public static final int CSIDL_START_MENU = 11;
    public static final int CSIDL_MYMUSIC = 13;
    public static final int CSIDL_MYVIDEO = 14;
    public static final int CSIDL_MYPICTURES = 39;
    public static final int CSIDL_WINDOWS = 36;
    public static final int CSIDL_APP_DATA = 26;
    public static final int CSIDL_LOCAL_APP_DATA = 28;
    public static final int CSIDL_COMMON_APP_DATA = 35;
    private static WinUtils instance;
    private static boolean error;
    private static final String TASKLIST = "tasklist";
    private static final String KILL = "taskkill /IM ";

    private WinUtils() {
    }

    public static boolean isSupported() {
        return WinUtils.getInstance() != null;
    }

    public static synchronized WinUtils getInstance() {
        if (!OSUtil.isWindowsSystem()) {
            return null;
        }
        if (instance == null && !error) {
            if (OSUtil.loadLibrary(WinUtils.class, "desktoputils")) {
                instance = new WinUtils();
                instance.init();
            } else {
                error = true;
            }
        }
        return instance;
    }

    public native String getSystemFolderPath(int var1, boolean var2);

    public native void createLink(ShellLink var1, String var2) throws IOException;

    private native void init();

    public void setPFLinks(boolean bl, Controller controller) throws IOException {
        String string = System.getProperty("user.home");
        Path path = Paths.get(string, "Links");
        if (Files.notExists(path, new LinkOption[0])) {
            this.logWarning("Could not locate the Links directory in " + string);
            return;
        }
        Path path2 = controller.getFolderRepository().getFoldersBasedir();
        Path path3 = path.resolve(path2.getFileName().toString() + ".lnk");
        if (bl) {
            ShellLink shellLink = new ShellLink(null, path2.getFileName().toString(), path2.toAbsolutePath().toString(), null);
            this.createLink(shellLink, path3.toAbsolutePath().toString());
        } else {
            try {
                Files.deleteIfExists(path3);
            }
            catch (IOException iOException) {
                LOG.warning("Unable to delete shortcut " + path3.toString() + ". " + iOException);
            }
        }
    }

    public static void removePFLinks(String string) {
        if (!OSUtil.isWindowsSystem()) {
            return;
        }
        Path path = Paths.get(System.getProperty("user.home"), "Links");
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        Path path2 = path.resolve(string + ".lnk");
        try {
            Files.delete(path2);
        }
        catch (IOException iOException) {
            LOG.warning("Unable to delete shortcut " + string + ". " + iOException);
        }
    }

    public static boolean isPFLinks(String string) {
        if (!OSUtil.isWindowsSystem()) {
            return false;
        }
        Path path = Paths.get(System.getProperty("user.home"), "Links");
        if (Files.notExists(path, new LinkOption[0])) {
            return false;
        }
        Path path2 = path.resolve(string + ".lnk");
        return Files.exists(path2, new LinkOption[0]);
    }

    public void setPFStartup(boolean bl, Controller controller) throws IOException, UnsupportedOperationException {
        Path path = WinUtils.getProgramInstallationPath(controller);
        Path path2 = null;
        if (path != null) {
            path2 = path.resolve(controller.getDistribution().getBinaryName() + ".exe");
        }
        if (path2 == null || Files.notExists(path2, new LinkOption[0])) {
            path2 = Paths.get(controller.getDistribution().getBinaryName() + ".exe", new String[0]).toAbsolutePath();
            if (Files.notExists(path2, new LinkOption[0])) {
                String string = Translation.get("exception.startup_item.executable_not_found.text", controller.getDistribution().getBinaryName(), path2.getFileName().toString());
                this.logWarning(string);
                throw new UnsupportedOperationException(string);
            }
            return;
        }
        this.logFiner("Found " + path2.toAbsolutePath());
        String string = controller.getDistribution().getName() + ".lnk";
        Path path3 = Paths.get(this.getSystemFolderPath(7, false), string);
        if (bl) {
            ShellLink shellLink = new ShellLink("--minimized", Translation.get("winutils.shortcut.description"), path2.toAbsolutePath().toString(), path2.getParent().toString());
            this.logInfo("Creating startup link: " + path3.toAbsolutePath());
            this.createLink(shellLink, path3.toAbsolutePath().toString());
        } else {
            this.logInfo("Deleting startup link.");
            try {
                Files.deleteIfExists(path3);
                string = controller.getDistribution().getBinaryName() + ".lnk";
                path3 = Paths.get(this.getSystemFolderPath(7, false), string);
                Files.deleteIfExists(path3);
            }
            catch (IOException iOException) {
                this.logInfo("Could not delete file " + path3.toAbsolutePath() + ". " + iOException);
            }
        }
    }

    public boolean hasPFStartup(Controller controller) {
        String string = controller.getDistribution().getName() + ".lnk";
        Path path = Paths.get(this.getSystemFolderPath(7, false), string);
        String string2 = controller.getDistribution().getBinaryName() + ".lnk";
        Path path2 = Paths.get(this.getSystemFolderPath(7, false), string2);
        return Files.exists(path, new LinkOption[0]) || Files.exists(path2, new LinkOption[0]);
    }

    public static Path getProgramInstallationPath(Controller controller) {
        Object object;
        String string = System.getenv("PROGRAMFILES");
        if (StringUtils.isBlank(string)) {
            LOG.warning("Unable find installation path. Program files directory not found");
            return null;
        }
        if (controller != null) {
            Path path;
            object = ConfigurationEntry.DIST_COMPANY.getValue(controller);
            String string2 = ConfigurationEntry.DIST_BINARY_NAME.getValue(controller);
            if (StringUtils.isNotBlank((String)object) && StringUtils.isNotBlank(string2) && Files.exists(path = Paths.get(string + "/" + (String)object + "/" + string2, new String[0]), new LinkOption[0])) {
                return path;
            }
        }
        if (Files.exists((Path)(object = Paths.get(string + "/PowerFolder.com/PowerFolder", new String[0])), new LinkOption[0])) {
            return object;
        }
        object = Paths.get(string + " (x86)/PowerFolder.com/PowerFolder", new String[0]);
        if (Files.exists((Path)object, new LinkOption[0])) {
            return object;
        }
        try {
            object = Paths.get("", new String[0]).toRealPath(new LinkOption[0]);
            if (Files.exists((Path)object, new LinkOption[0])) {
                return object;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.warning("Unable find installation path. Program files directory not found");
        return null;
    }

    public static String getAppDataCurrentUser() {
        String string = System.getenv("APPDATA");
        if (StringUtils.isBlank(string) && WinUtils.getInstance() != null) {
            string = WinUtils.getInstance().getSystemFolderPath(26, false);
        }
        if (StringUtils.isBlank(string) && OSUtil.isWindowsSystem()) {
            LOG.severe("Unable to find APPDATA (current user) directory");
        }
        return string;
    }

    public static String getAppDataAllUsers() {
        Object object;
        Path object22;
        if (WinUtils.getInstance() != null) {
            return WinUtils.getInstance().getSystemFolderPath(35, false);
        }
        if (StringUtils.isNotBlank(System.getenv("ProgramData")) && Files.exists(object22 = Paths.get((String)(object = System.getenv("ProgramData")), new String[0]), new LinkOption[0])) {
            LOG.fine("Retrieved APPDATA (all users) via ENV(ProgramData): " + (String)object);
            return object;
        }
        if (StringUtils.isNotBlank(System.getenv("USERPROFILE")) && StringUtils.isNotBlank(System.getenv("APPDATA")) && StringUtils.isNotBlank(System.getenv("ALLUSERSPROFILE"))) {
            String string;
            object = System.getenv("USERPROFILE");
            String string2 = System.getenv("APPDATA");
            String string3 = System.getenv("ALLUSERSPROFILE");
            String string4 = string3 + (string = string2.replace((CharSequence)object, ""));
            Path path = Paths.get(string4, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                LOG.warning("Retrieved APPDATA (all users) via ENV(USERPROFILE/APPDATA/ALLUSERSPROFILE): " + string4);
                return string4;
            }
        }
        LOG.severe("Unable to find APPDATA (all users) directory");
        LOG.warning("Dump of environment variables: ");
        for (Map.Entry entry : System.getenv().entrySet()) {
            LOG.warning(" " + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return null;
    }

    public static boolean isProcessRunging(String string) throws Exception {
        String string2;
        Process process = Runtime.getRuntime().exec(TASKLIST);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            System.out.println(string2);
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static void killProcess(String string) throws Exception {
        Runtime.getRuntime().exec(KILL + string);
    }

    public static boolean isMSI(Controller controller) {
        return Files.exists(WinUtils.getProgramInstallationPath(controller).resolve(MSI_MARKER_FILE), new LinkOption[0]);
    }

    public static String mountWebDAV(ServerClient serverClient, String string) {
        return WinUtils.mountWebDAV(serverClient, '\u0000', string);
    }

    public static String mountWebDAV(ServerClient serverClient, char c, String string) {
        block4: {
            try {
                String string2 = serverClient.isTokenLogin() ? serverClient.getWebDAVToken() : serverClient.getPasswordClearText();
                Account account = serverClient.getAccount();
                String string3 = account.isValid() ? account.getUsername() : serverClient.getUsername();
                Object object = c == '\u0000' ? "*" : c + ":";
                String string4 = "net use " + (String)object + " \"" + string + "\" /User:" + string3 + " \"" + string2 + "\" /persistent:yes";
                Process process = Runtime.getRuntime().exec(string4);
                byte[] byArray = StreamUtils.readIntoByteArray(process.getInputStream());
                String string5 = new String(byArray);
                byte[] byArray2 = StreamUtils.readIntoByteArray(process.getErrorStream());
                String string6 = new String(byArray2);
                if (StringUtils.isEmpty(string6)) {
                    if (!StringUtils.isEmpty(string5)) {
                        return "Y" + string5;
                    }
                    break block4;
                }
                return "N" + string6;
            }
            catch (Exception exception) {
                return "N" + exception.getMessage();
            }
        }
        return null;
    }

    public static boolean isWebDAVAlreadyMapped(ServerClient serverClient, char c) {
        Path path = Paths.get(c + ":\\", new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            return false;
        }
        for (FolderInfo folderInfo : serverClient.getAccount().getFoldersCharged()) {
            if (!Files.notExists(path.resolve(folderInfo.getLocalizedName()), new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    private static String getCurrentUserDesktopPath() {
        try {
            Process process = Runtime.getRuntime().exec(DESKTOP_FOLDER_CMD);
            StreamReader streamReader = new StreamReader(process.getInputStream());
            streamReader.start();
            process.waitFor();
            streamReader.join();
            String string = streamReader.getResult();
            int n = string.indexOf(REGSTR_TOKEN);
            if (n == -1) {
                return null;
            }
            return string.substring(n + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        error = false;
    }

    private static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(InputStream inputStream) {
            this.is = inputStream;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int n;
                while ((n = this.is.read()) != -1) {
                    this.sw.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

