/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.logging.handlers;

import de.dal33t.powerfolder.util.Reject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class BufferedHandler
extends Handler {
    private List<LogRecord> logRecords;
    private int size;

    public BufferedHandler(int n) {
        Reject.ifTrue(n <= 0 || n >= 10000, "Illegal size " + n);
        this.logRecords = Collections.synchronizedList(new LinkedList());
        this.size = n;
    }

    @Override
    public void close() throws SecurityException {
        this.logRecords.clear();
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        List<LogRecord> list = this.logRecords;
        synchronized (list) {
            this.logRecords.add(0, logRecord);
            if (this.logRecords.size() > this.size) {
                this.logRecords.remove(this.logRecords.size() - 1);
            }
        }
    }

    public void clear() {
        this.logRecords.clear();
    }

    public List<LogRecord> getLogRecords() {
        return this.logRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFormattedLogLines(int n, Formatter formatter, Level level) {
        List<LogRecord> list = this.logRecords;
        synchronized (list) {
            ArrayList<String> arrayList = new ArrayList<String>(this.logRecords.size());
            int n2 = Math.min(n, this.logRecords.size());
            for (int i = 0; i < n2; ++i) {
                LogRecord logRecord = this.logRecords.get(i);
                if (level != null && logRecord.getLevel().intValue() < level.intValue()) continue;
                String string = formatter.format(logRecord);
                string = this.buildLinks(string);
                string = string.replace("de.dal33t.powerfolder.", "");
                arrayList.add(string);
            }
            return arrayList;
        }
    }

    private String buildLinks(String object) {
        String string = object;
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            n = ((String)object).toLowerCase().indexOf("http", n + 1);
            if (++n2 > 100) {
                return string;
            }
            if (n < 0) continue;
            if (((String)object).charAt(n - 1) == '\'' || ((String)object).charAt(n - 1) == '\"') {
                ++n;
                continue;
            }
            int n3 = ((String)object).indexOf(" ", n);
            if (n3 < n) {
                n3 = ((String)object).indexOf(",", n);
            }
            if (n3 < n) {
                n3 = ((String)object).indexOf("'", n);
            }
            if (n3 < n) {
                n3 = ((String)object).indexOf("\n", n);
            }
            if (n3 < 0) {
                n3 = ((String)object).length() + 1;
            }
            if (n <= 0 || n3 <= n) continue;
            if (((String)object).charAt(n3 - 1) == '/') {
                --n3;
            }
            String string2 = ((String)object).substring(n, n3);
            int n4 = ((String)object).length();
            object = ((String)object).substring(0, n) + "<a target='_blank' href='" + string2 + "'>" + string2 + "</a>" + ((String)object).substring(n3, ((String)object).length());
            n4 = ((String)object).length() - n4;
            n += n4;
        }
        return object;
    }
}

