/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.intern;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.net.NodeManager;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.intern.Internalizer;

public class MemberInfoInternalizer
implements Internalizer<MemberInfo> {
    private NodeManager nodeManager;
    private volatile int hits;
    private volatile int misses;

    public MemberInfoInternalizer(NodeManager nodeManager) {
        Reject.ifNull(nodeManager, "NodeManager");
        this.nodeManager = nodeManager;
    }

    @Override
    public MemberInfo intern(MemberInfo memberInfo) {
        if (memberInfo == null) {
            return null;
        }
        Member member = this.nodeManager.getNode(memberInfo);
        if (member != null) {
            ++this.hits;
            return member.getInfo();
        }
        ++this.hits;
        return this.nodeManager.addNode(memberInfo).getInfo();
    }

    @Override
    public MemberInfo rename(MemberInfo memberInfo) {
        return this.intern(memberInfo);
    }
}

