/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.delta;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.protocol.FilePartInfoProto;
import java.io.Serializable;
import java.util.Arrays;

public final class PartInfo
implements Serializable,
D2DObject {
    private static final long serialVersionUID = 1L;
    private long index;
    private long checksum;
    private byte[] digest;

    public PartInfo(long l, long l2, byte[] byArray) {
        this.index = l;
        this.checksum = l2;
        this.digest = byArray;
    }

    public PartInfo(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public long getChecksum() {
        return this.checksum;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public long getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.digest.length; ++i) {
            stringBuilder.append('-').append(Integer.toHexString(this.digest[i] & 0xFF));
        }
        return "{" + this.getIndex() + ": " + this.getChecksum() + ", '" + stringBuilder.toString() + "'}";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PartInfo) {
            PartInfo partInfo = (PartInfo)object;
            return this.index == partInfo.index && this.checksum == partInfo.checksum && Arrays.equals(this.digest, partInfo.digest);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.index ^ (int)(this.index >> 32) ^ (int)this.checksum ^ (int)(this.checksum >> 32) ^ Arrays.hashCode(this.digest);
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FilePartInfoProto.FilePartInfo) {
            FilePartInfoProto.FilePartInfo filePartInfo = (FilePartInfoProto.FilePartInfo)abstractMessage;
            this.index = filePartInfo.getIndex();
            this.checksum = filePartInfo.getChecksum();
            this.digest = filePartInfo.getDigest().toByteArray();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FilePartInfoProto.FilePartInfo.Builder builder = FilePartInfoProto.FilePartInfo.newBuilder();
        builder.setClazzName("FilePartInfo");
        builder.setIndex(this.index);
        builder.setChecksum(this.checksum);
        builder.setDigest(ByteString.copyFrom(this.digest));
        return builder.build();
    }
}

