/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.db;

import de.dal33t.powerfolder.disk.dao.FolderInfoDAO;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderOwnerPermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.FolderReadWritePermission;
import de.dal33t.powerfolder.security.GroupAdminPermission;
import de.dal33t.powerfolder.security.OrganizationAdminPermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.security.UnknownPermission;
import de.dal33t.powerfolder.util.StackDump;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class PermissionUserType
extends Loggable
implements UserType {
    private static final int[] sqlTypes = new int[]{12};
    private static List<FolderInfoDAO> FOLDER_INFO_DAOS = new LinkedList<FolderInfoDAO>();

    @Override
    public Object assemble(Serializable serializable, Object object) throws HibernateException {
        return serializable;
    }

    @Override
    public Object deepCopy(Object object) throws HibernateException {
        return object;
    }

    @Override
    public Serializable disassemble(Object object) throws HibernateException {
        return (Serializable)object;
    }

    @Override
    public boolean equals(Object object, Object object2) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    @Override
    public int hashCode(Object object) throws HibernateException {
        return object.hashCode();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, Object object) throws HibernateException, SQLException {
        Object object2;
        Exception exception;
        String string;
        Permission permission;
        block31: {
            permission = null;
            string = resultSet.getString(stringArray[0]);
            exception = null;
            if (StringUtils.isBlank(string)) {
                if (this.isFiner()) {
                    this.logFiner("Permission ID is empty");
                }
                return null;
            }
            if (string.contains("_FP_")) {
                FolderInfoDAO folderInfoDAO;
                object2 = string.split("_FP_");
                String string2 = object2[0];
                String string3 = object2[1];
                if (FOLDER_INFO_DAOS.isEmpty()) {
                    throw new IllegalStateException("FolderInfoDAO not set! Maybe server is already shut down or not started?");
                }
                FolderInfo folderInfo = null;
                Iterator<FolderInfoDAO> iterator = FOLDER_INFO_DAOS.iterator();
                while (iterator.hasNext() && (folderInfo = (FolderInfo)(folderInfoDAO = iterator.next()).findByID(string2)) == null) {
                }
                if (folderInfo == null) {
                    this.logWarning("FolderInfo with ID " + string2 + " not found", new StackDump());
                    folderInfo = FolderInfoFactory.lookupInstance(string2);
                } else if (!folderInfo.isLookupInstance()) {
                    if (folderInfo.intern().getVersion() > folderInfo.getVersion()) {
                        this.logInfo(folderInfo.intern() + ": Found newer version is memory. in DB " + folderInfo);
                        folderInfo = folderInfo.intern();
                    }
                } else {
                    this.logWarning(folderInfo + ": Found lookup instance in DB. Please correct this via SQL if the problem persists: UPDATE FolderInfo SET version = 0 WHERE version < 0;");
                }
                if (StringUtils.isBlank(folderInfo.getName()) && this.isFine()) {
                    this.logFine("Unknown folder with ID=" + folderInfo.getId());
                }
                if (string3.equals(FolderAdminPermission.class.getSimpleName())) {
                    permission = FolderPermission.admin(folderInfo);
                } else if (string3.equals(FolderOwnerPermission.class.getSimpleName())) {
                    permission = FolderPermission.owner(folderInfo);
                } else if (string3.equals(FolderReadPermission.class.getSimpleName())) {
                    permission = FolderPermission.read(folderInfo);
                } else if (string3.equals(FolderReadWritePermission.class.getSimpleName())) {
                    permission = FolderPermission.readWrite(folderInfo);
                }
            } else if (string.contains("_GP_")) {
                object2 = string.split("_GP_");
                String string4 = object2[0];
                String string5 = object2[1];
                if (string5.equals(GroupAdminPermission.class.getSimpleName())) {
                    permission = new GroupAdminPermission(string4);
                }
            } else if (string.contains("_OP_")) {
                object2 = string.split("_OP_");
                String string6 = object2[0];
                String string7 = object2[1];
                if (string7.equals(OrganizationAdminPermission.class.getSimpleName())) {
                    permission = new OrganizationAdminPermission(string6);
                }
            } else {
                object2 = "de.dal33t.powerfolder.security." + string;
                try {
                    Object object3;
                    Class<?> clazz = Class.forName((String)object2);
                    try {
                        Field field = clazz.getField("INSTANCE");
                        object3 = field.get(null);
                    }
                    catch (Exception exception2) {
                        object3 = clazz.newInstance();
                    }
                    permission = (Permission)object3;
                }
                catch (Exception exception3) {
                    exception = exception3;
                    if (!this.isFine()) break block31;
                    String string8 = object instanceof Account ? ((Account)object).getUsername() : object.toString();
                    this.logFine(string8 + ": Unable to resolve permission: " + string + ". " + exception3, exception3);
                }
            }
        }
        if (permission == null) {
            if (this.isWarning()) {
                object2 = object instanceof Account ? ((Account)object).getUsername() : object.toString();
                this.logWarning((String)object2 + ": Unknown permission with ID: " + string + ". " + exception);
            }
            return new UnknownPermission(string);
        }
        return permission;
    }

    @Override
    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        if (object == null) {
            preparedStatement.setNull(n, 12);
        } else {
            Permission permission = (Permission)object;
            preparedStatement.setString(n, permission.getId());
        }
    }

    @Override
    public Object replace(Object object, Object object2, Object object3) throws HibernateException {
        return object;
    }

    @Override
    public Class<?> returnedClass() {
        return Permission.class;
    }

    @Override
    public int[] sqlTypes() {
        return sqlTypes;
    }

    public static void setFolderInfoDAO(FolderInfoDAO folderInfoDAO) {
        if (folderInfoDAO == null) {
            FOLDER_INFO_DAOS.clear();
            return;
        }
        FOLDER_INFO_DAOS.add(0, folderInfoDAO);
        if (FOLDER_INFO_DAOS.size() > 1) {
            Logger logger = Logger.getLogger(PermissionUserType.class.getName());
            logger.warning("FolderInfoDAO was already set! The reset should not happen!");
        }
    }
}

