/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.compare;

import de.dal33t.powerfolder.transfer.DownloadManager;
import java.util.Comparator;

public class DownloadManagerComparator
implements Comparator<DownloadManager> {
    public static final int BY_EXT = 0;
    public static final int BY_FILE_NAME = 1;
    public static final int BY_PROGRESS = 2;
    public static final int BY_SIZE = 3;
    public static final int BY_FOLDER = 4;
    public static final int BY_MEMBER = 5;
    public static final int BY_COMPLETED_DATE = 6;
    private int sortBy;

    public DownloadManagerComparator(int n) {
        this.sortBy = n;
    }

    @Override
    public int compare(DownloadManager downloadManager, DownloadManager downloadManager2) {
        switch (this.sortBy) {
            case 0: {
                return downloadManager.getFileInfo().getExtension().compareTo(downloadManager2.getFileInfo().getExtension());
            }
            case 1: {
                return downloadManager.getFileInfo().getFilenameOnly().compareToIgnoreCase(downloadManager2.getFileInfo().getFilenameOnly());
            }
            case 2: {
                int n = downloadManager.getState().compareTo(downloadManager2.getState());
                if (n == 0 && downloadManager.getCompletedDate() != null && downloadManager2.getCompletedDate() != null) {
                    return -downloadManager.getCompletedDate().compareTo(downloadManager2.getCompletedDate());
                }
                return n;
            }
            case 3: {
                long l = downloadManager.getFileInfo().getSize();
                long l2 = downloadManager2.getFileInfo().getSize();
                if (l == l2) {
                    return 0;
                }
                return l - l2 > 0L ? 1 : -1;
            }
            case 4: {
                return downloadManager.getFileInfo().getFolderInfo().getName().compareTo(downloadManager2.getFileInfo().getFolderInfo().getName());
            }
            case 5: {
                if (downloadManager.getSources().size() > 1 && downloadManager.getSources().size() > 1) {
                    return 0;
                }
                if (downloadManager.getSources().size() == 1 && downloadManager2.getSources().size() == 1) {
                    return downloadManager.getSources().iterator().next().getPartner().getNick().compareTo(downloadManager2.getSources().iterator().next().getPartner().getNick());
                }
                return downloadManager.getSources().size();
            }
            case 6: {
                if (downloadManager.getCompletedDate() == null) {
                    if (downloadManager2.getCompletedDate() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (downloadManager2.getCompletedDate() == null) {
                    return 1;
                }
                return downloadManager.getCompletedDate().compareTo(downloadManager2.getCompletedDate());
            }
        }
        return 0;
    }

    public String toString() {
        Object object = "FileInfo comparator, sorting by ";
        switch (this.sortBy) {
            case 0: {
                object = (String)object + "extension";
                break;
            }
            case 1: {
                object = (String)object + "extension";
                break;
            }
            case 2: {
                object = (String)object + "progress";
                break;
            }
            case 3: {
                object = (String)object + "size";
                break;
            }
            case 4: {
                object = (String)object + "folder";
                break;
            }
            case 5: {
                object = (String)object + "member";
            }
        }
        return object;
    }
}

