/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.collection;

import de.dal33t.powerfolder.util.collection.CompositeCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CompositeSet
extends CompositeCollection
implements Set {
    private static Integer INTEGER_ONE = 1;

    public CompositeSet() {
    }

    public CompositeSet(Set set) {
        super(set);
    }

    public CompositeSet(Set[] setArray) {
        super(setArray);
    }

    @Override
    public synchronized void addComposited(Collection collection) {
        if (!(collection instanceof Set)) {
            throw new IllegalArgumentException("Collections added must implement java.util.Set");
        }
        for (Set set : this.getCollections()) {
            Collection collection2 = CompositeSet.intersection(set, collection);
            if (collection2.size() <= 0) continue;
            if (this.mutator == null) {
                throw new UnsupportedOperationException("Collision adding composited collection with no SetMutator set");
            }
            if (!(this.mutator instanceof SetMutator)) {
                throw new UnsupportedOperationException("Collision adding composited collection to a CompositeSet with a CollectionMutator instead of a SetMutator");
            }
            ((SetMutator)this.mutator).resolveCollision(this, set, (Set)collection, collection2);
            if (CompositeSet.intersection(set, collection).size() <= 0) continue;
            throw new IllegalArgumentException("Attempt to add illegal entry unresolved by SetMutator.resolveCollision()");
        }
        super.addComposited(new Collection[]{collection});
    }

    @Override
    public synchronized void addComposited(Collection collection, Collection collection2) {
        if (!(collection instanceof Set)) {
            throw new IllegalArgumentException("Argument must implement java.util.Set");
        }
        if (!(collection2 instanceof Set)) {
            throw new IllegalArgumentException("Argument must implement java.util.Set");
        }
        this.addComposited(new Set[]{(Set)collection, (Set)collection2});
    }

    @Override
    public synchronized void addComposited(Collection[] collectionArray) {
        for (int i = collectionArray.length - 1; i >= 0; --i) {
            this.addComposited(collectionArray[i]);
        }
    }

    @Override
    public void setMutator(CompositeCollection.CollectionMutator collectionMutator) {
        super.setMutator(collectionMutator);
    }

    @Override
    public boolean remove(Object object) {
        for (Set set : this.getCollections()) {
            if (!set.contains(object)) continue;
            return set.remove(object);
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        Set set;
        return object instanceof Set && (set = (Set)object).containsAll(this) && set.size() == this.size();
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (Object e : this) {
            n += e != null ? e.hashCode() : 0;
        }
        return n;
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CompositeSet.getCardinalityMap(collection);
        Map map2 = CompositeSet.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        for (Object e : hashSet) {
            int n = Math.min(CompositeSet.getFreq(e, map), CompositeSet.getFreq(e, map2));
            for (int i = 0; i < n; ++i) {
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    private static final int getFreq(Object object, Map map) {
        Integer n = (Integer)map.get(object);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static Map getCardinalityMap(Collection collection) {
        HashMap hashMap = new HashMap();
        for (Object e : collection) {
            Integer n = (Integer)hashMap.get(e);
            if (n == null) {
                hashMap.put(e, INTEGER_ONE);
                continue;
            }
            hashMap.put(e, n + 1);
        }
        return hashMap;
    }

    public static interface SetMutator
    extends CompositeCollection.CollectionMutator {
        public void resolveCollision(CompositeSet var1, Set var2, Set var3, Collection var4);
    }
}

