/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.notices.NoticeSeverity;
import de.dal33t.powerfolder.ui.notices.RunnableNotice;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemoryMonitor
implements Runnable {
    private static final Logger log = Logger.getLogger(MemoryMonitor.class.getName());
    private Controller controller;
    private boolean runAlready;

    public MemoryMonitor(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void run() {
        if (this.runAlready) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        long l2 = runtime.totalMemory();
        log.fine("Max Memory: " + Format.formatBytesShort(l) + ", Total Memory: " + Format.formatBytesShort(l2));
        if ((double)l2 > 0.95 * (double)l) {
            this.addWarning();
            this.runAlready = true;
        }
    }

    private void addWarning() {
        RunnableNotice runnableNotice = new RunnableNotice(Translation.get("warning_notice.title"), Translation.get("warning_notice.low_memory"), new Runnable(){

            @Override
            public void run() {
                if ((OSUtil.isWindowsSystem() || OSUtil.isMacOS()) && !OSUtil.isWebStart()) {
                    int n = DialogFactory.genericDialog(MemoryMonitor.this.controller, Translation.get("low_memory.title"), Translation.get("low_memory.text", Help.getWikiArticleURL(MemoryMonitor.this.controller, "Memory_configuration")), new String[]{Translation.get("low_memory.increase"), Translation.get("low_memory.do_nothing")}, 0, GenericDialogType.WARN);
                    if (n == 0) {
                        MemoryMonitor.this.increaseAvailableMemory();
                    }
                } else {
                    DialogFactory.genericDialog(MemoryMonitor.this.controller, Translation.get("low_memory.title"), Translation.get("low_memory.warn"), new String[]{Translation.get("general.ok")}, 0, GenericDialogType.WARN);
                }
            }
        }, NoticeSeverity.WARNING);
        this.controller.getUIController().getApplicationModel().getNoticesModel().handleNotice(runnableNotice);
    }

    public void increaseAvailableMemory() {
        if (!OSUtil.is64BitPlatform()) {
            DialogFactory.genericDialog(this.controller, Translation.get("low_memory.title"), Translation.get("low_memory.install_64bit"), GenericDialogType.WARN);
            return;
        }
        boolean bl = OSUtil.isMacOS() ? this.increaseAvailableMemoryMac() : this.increaseAvailableMemoryWin();
        if (!bl) {
            PreferencesEntry.MEMORY_LIMIT_INCREASE.setValue(this.controller, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean increaseAvailableMemoryWin() {
        boolean bl = false;
        try (PrintWriter printWriter = null;){
            boolean bl2;
            boolean bl3 = bl2 = Runtime.getRuntime().totalMemory() / 1024L / 1024L > 8000L;
            if (!bl2) {
                printWriter = new PrintWriter(new FileWriter(this.controller.getL4JININame()));
                log.fine("Writing new ini...");
                printWriter.println("-Xms256m");
                printWriter.println("-Xmx8192m");
                printWriter.println("-XX:NewRatio=8");
                printWriter.println("-XX:MinHeapFreeRatio=10");
                printWriter.println("-XX:MaxHeapFreeRatio=20");
                printWriter.flush();
                bl = true;
                log.fine("Wrote new ini...");
            }
        }
        if (bl) {
            DialogFactory.genericDialog(this.controller, Translation.get("low_memory.title"), Translation.get("low_memory.configure_success"), GenericDialogType.INFO);
        } else {
            DialogFactory.genericDialog(this.controller, Translation.get("low_memory.title"), Translation.get("low_memory.configure_failure"), GenericDialogType.WARN);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean increaseAvailableMemoryMac() {
        boolean bl = false;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            log.fine("Looking for Contents/Info.plist...");
            Path path = Paths.get(this.controller.getDistribution().getBinaryName() + ".app/Contents/Info.plist", new String[0]);
            log.info("Modifing " + path.toRealPath(new LinkOption[0]));
            Path path2 = Paths.get(this.controller.getDistribution().getBinaryName() + ".app/Contents/Info.plist.temp", new String[0]);
            Path path3 = Paths.get(this.controller.getDistribution().getBinaryName() + ".app/Contents/Info.plist.backup", new String[0]);
            bufferedReader = Files.newBufferedReader(path, Charset.forName("UTF-8"));
            printWriter = new PrintWriter(Files.newBufferedWriter(path2, Charset.forName("UTF-8"), new OpenOption[0]));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().startsWith("<string>-Xm") && !string.contains("-Xmx8192m")) {
                    printWriter.write("      <string>-Xms256m -Xmx8192m -XX:NewRatio=8 -XX:MinHeapFreeRatio=5 -XX:MaxHeapFreeRatio=10</string>");
                    bl = true;
                } else {
                    printWriter.write(string);
                }
                printWriter.write(10);
            }
            bufferedReader.close();
            printWriter.close();
            PathUtils.copyFile(path, path3);
            PathUtils.copyFile(path2, path);
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Problem reconfiguring Contents/Info.plist: " + iOException.getMessage(), iOException);
            bl = false;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        if (bl) {
            DialogFactory.genericDialog(this.controller, Translation.get("low_memory.title"), Translation.get("low_memory.configure_success"), GenericDialogType.INFO);
        } else {
            DialogFactory.genericDialog(this.controller, Translation.get("low_memory.title"), Translation.get("low_memory.configure_failure"), GenericDialogType.WARN);
        }
        return bl;
    }
}

