/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BrowserLauncher {
    private static final Logger log = Logger.getLogger(BrowserLauncher.class.getName());
    private static final String errMsg = "Error attempting to launch web browser";

    public static void openURL(Controller controller, final String string) {
        BrowserLauncher.open(controller, new URLProducer(){

            @Override
            public String url() {
                return string;
            }
        });
    }

    public static void open(Controller controller, final URLProducer uRLProducer) {
        Reject.ifNull(uRLProducer, "producer");
        if (controller != null && controller.getIOProvider() != null) {
            controller.getIOProvider().startIO(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrowserLauncher.openURL(uRLProducer.url());
                    }
                    catch (IOException iOException) {
                        log.log(Level.WARNING, "Unable to open web browser. " + iOException);
                    }
                }
            });
        } else {
            try {
                BrowserLauncher.openURL(uRLProducer.url());
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Unable to open web browser. " + iOException);
            }
        }
    }

    public static void openURL(String string) throws IOException {
        if (StringUtils.isBlank(string)) {
            log.warning("Not opening blank url!");
            return;
        }
        if (BrowserLauncher.java6impl(string)) {
            return;
        }
        try {
            if (OSUtil.isMacOS()) {
                Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                Method method = clazz.getDeclaredMethod("openURL", String.class);
                method.invoke(null, string);
            } else if (OSUtil.isWindowsSystem()) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
            } else {
                String[] stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String string2 = null;
                for (int i = 0; i < stringArray.length && string2 == null; ++i) {
                    if (Runtime.getRuntime().exec(new String[]{"which", stringArray[i]}).waitFor() != 0) continue;
                    string2 = stringArray[i];
                }
                if (string2 == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{string2, string});
            }
        }
        catch (Exception exception) {
            throw (IOException)new IOException(errMsg).initCause(exception);
        }
    }

    private static boolean java6impl(String string) {
        log.fine("Launching " + string);
        try {
            if (Desktop.isDesktopSupported()) {
                log.fine("Using Java6 Desktop.browse()");
                Desktop.getDesktop().browse(new URI(string));
                return true;
            }
        }
        catch (LinkageError linkageError) {
            log.log(Level.FINER, "LinkageError", linkageError);
        }
        catch (IOException | URISyntaxException exception) {
            log.fine("Cannot open URL using Desktop. Trying fallback. " + exception.toString());
        }
        return false;
    }

    public static interface URLProducer {
        public String url();
    }
}

